/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp.management;

import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import tlc2.tool.fp.FPSetStatistic;
import tlc2.tool.fp.management.DiskFPSetMXBean;
import tlc2.tool.management.TLCStandardMBean;

public class DiskFPSetMXWrapper
extends TLCStandardMBean
implements DiskFPSetMXBean {
    private static int COUNT = 0;
    protected final FPSetStatistic fpset;
    private final String objectName;

    public DiskFPSetMXWrapper(FPSetStatistic diskFPSet) throws NotCompliantMBeanException {
        super((Class)DiskFPSetMXBean.class);
        this.fpset = diskFPSet;
        this.objectName = "DiskFPSet" + COUNT++;
        this.registerMBean("tlc2.tool.fp:type=" + this.objectName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public long getTblCnt() {
        return this.fpset.getTblCnt();
    }

    @Override
    public long getFileCnt() {
        return this.fpset.getFileCnt();
    }

    @Override
    public long getIndexCnt() {
        return this.fpset.getIndexCapacity();
    }

    @Override
    public long getDiskLookupCnt() {
        return this.fpset.getDiskLookupCnt();
    }

    @Override
    public long getMemHitCnt() {
        return this.fpset.getMemHitCnt();
    }

    @Override
    public long getDiskHitCnt() {
        return this.fpset.getDiskHitCnt();
    }

    @Override
    public long getDiskWriteCnt() {
        return this.fpset.getDiskWriteCnt();
    }

    @Override
    public long getDiskSeekCnt() {
        return this.fpset.getDiskSeekCnt();
    }

    @Override
    public long getDiskSeekCache() {
        return this.fpset.getDiskSeekCache();
    }

    @Override
    public double getDiskSeekRate() {
        long diskSeekCnt = this.getDiskSeekCnt();
        long diskSeekCache = this.getDiskSeekCache();
        return (double)diskSeekCache / (double)(diskSeekCache + diskSeekCnt);
    }

    @Override
    public int getGrowDiskMark() {
        return this.fpset.getGrowDiskMark();
    }

    @Override
    public int getCheckPointMark() {
        return this.fpset.getCheckPointMark();
    }

    @Override
    public long getBucketCapacity() {
        return this.fpset.getBucketCapacity();
    }

    @Override
    public long getTblCapacity() {
        return this.fpset.getTblCapacity();
    }

    @Override
    public long getOverallCapacity() {
        return this.fpset.getOverallCapacity();
    }

    @Override
    public long getTblLoad() {
        return this.fpset.getTblLoad();
    }

    @Override
    public long getSizeOf() {
        return this.fpset.sizeof();
    }

    @Override
    public long getFlushTime() {
        return this.fpset.getFlushTime();
    }

    @Override
    public int getReaderWriterCnt() {
        return this.fpset.getReaderWriterCnt();
    }

    @Override
    public long getCollisionBucketCnt() {
        return this.fpset.getCollisionBucketCnt();
    }

    @Override
    public double getCollisionRatio() {
        return this.fpset.getCollisionRatio();
    }

    @Override
    public double getLoadFactor() {
        return this.fpset.getLoadFactor();
    }

    @Override
    public void forceFlush() {
        this.fpset.forceFlush();
    }

    @Override
    public boolean checkInvariant() throws IOException {
        return this.fpset.checkInvariant();
    }
}

