/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import sun.misc.Unsafe;
import util.Assert;

public final class OffHeapDiskFPSetHelper {
    private OffHeapDiskFPSetHelper() {
    }

    public static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to use Sun VM specific sun.misc.Unsafe implementation but no Sun based VM detected.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zeroMemory(final Unsafe u, final long baseAddress, int numThreads, long fingerprintCount) throws IOException {
        final int addressSize = u.addressSize();
        final long segmentSize = fingerprintCount / (long)numThreads;
        ExecutorService es = Executors.newFixedThreadPool(numThreads);
        try {
            ArrayList<1> tasks = new ArrayList<1>(numThreads);
            int i = 0;
            while (i < numThreads) {
                final int offset = i++;
                tasks.add(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        long lowerBound = segmentSize * (long)offset;
                        long upperBound = (long)(1 + offset) * segmentSize;
                        for (long i = lowerBound; i < upperBound; ++i) {
                            long address = baseAddress + i * (long)addressSize;
                            u.putAddress(address, 0L);
                        }
                        return true;
                    }
                });
            }
            List invokeAll = es.invokeAll(tasks);
            Assert.check(!invokeAll.isEmpty(), 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            es.shutdown();
        }
    }
}

