/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Unsafe;
import tlc2.output.MP;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetStatistic;
import tlc2.tool.fp.OffHeapDiskFPSetHelper;
import util.Assert;

public class OffHeapDiskFPSet
extends DiskFPSet
implements FPSetStatistic {
    protected static final double COLLISION_BUCKET_RATIO = 0.025;
    protected final int bucketCapacity;
    private final Unsafe u;
    private final long baseAddress;
    private final int logAddressSize;
    protected CollisionBucket collisionBucket;
    private final Indexer indexer;
    private final ReadWriteLock csRWLock = new ReentrantReadWriteLock();

    protected OffHeapDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        long n;
        long memoryInFingerprintCnt = fpSetConfig.getMemoryInFingerprintCnt();
        this.u = OffHeapDiskFPSetHelper.getUnsafe();
        int cnt = -1;
        for (int addressSize = this.u.addressSize(); addressSize > 0; addressSize >>>= 1) {
            ++cnt;
        }
        this.logAddressSize = cnt;
        long bytes = memoryInFingerprintCnt << this.logAddressSize;
        this.baseAddress = this.u.allocateMemory(bytes);
        int csCapacity = (int)((double)this.maxTblCnt * 0.025);
        this.collisionBucket = new TreeSetCollisionBucket(csCapacity);
        this.flusher = new OffHeapMSBFlusher();
        int moveBy = 0;
        for (n = (Long.MAX_VALUE >>> fpSetConfig.getPrefixBits()) - (memoryInFingerprintCnt - 1L); n >= memoryInFingerprintCnt; n >>>= 1) {
            ++moveBy;
        }
        int bitCount = Long.bitCount(memoryInFingerprintCnt);
        if (bitCount == 1) {
            this.bucketCapacity = 16;
            this.indexer = new BitshiftingIndexer(moveBy, fpSetConfig.getPrefixBits());
        } else {
            cnt = -1;
            while (bytes > 0L) {
                ++cnt;
                bytes >>>= 1;
            }
            long extraMem = memoryInFingerprintCnt * 8L - (long)Math.pow(2.0, cnt);
            int x = (int)(extraMem / ((n + 1L) / 16L));
            this.bucketCapacity = 16 + x / 8;
            Assert.check(this.bucketCapacity < 32, 1000);
            this.indexer = new Indexer(moveBy, fpSetConfig.getPrefixBits());
        }
    }

    @Override
    public void init(int numThreads, String aMetadir, String filename) throws IOException {
        super.init(numThreads, aMetadir, filename);
        OffHeapDiskFPSetHelper.zeroMemory(this.u, this.baseAddress, numThreads, this.fpSetConfig.getMemoryInFingerprintCnt());
    }

    @Override
    public long sizeof() {
        long size = 44L;
        size += this.maxTblCnt * 8L;
        size += this.getIndexCapacity() * 4L;
        return size += this.getCollisionBucketCnt() * 8L;
    }

    @Override
    protected boolean needsDiskFlush() {
        return this.collisionRatioExceeds(0.025) && this.loadFactorExceeds(0.25) || this.loadFactorExceeds(1.0) || this.forceFlush;
    }

    private boolean loadFactorExceeds(double limit) {
        double d = (this.tblCnt.doubleValue() - (double)this.collisionBucket.size()) / (double)this.maxTblCnt;
        return d >= limit;
    }

    private boolean collisionRatioExceeds(double limit) {
        long size = this.collisionBucket.size();
        double d = (double)size / (this.tblCnt.doubleValue() - (double)size);
        return d >= limit;
    }

    @Override
    protected int getLockIndex(long fp) {
        return this.indexer.getLockIndex(fp);
    }

    @Override
    boolean memLookup(long fp) {
        long position = this.indexer.getLogicalPosition(fp);
        long l = -1L;
        for (int i = 0; i < this.bucketCapacity && l != 0L; ++i) {
            l = this.u.getAddress(this.log2phy(position, i));
            if (fp != (l & Long.MAX_VALUE)) continue;
            return true;
        }
        return this.csLookup(fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean csLookup(long fp) {
        try {
            this.csRWLock.readLock().lock();
            boolean bl = this.collisionBucket.contains(fp);
            return bl;
        }
        finally {
            this.csRWLock.readLock().unlock();
        }
    }

    @Override
    boolean memInsert(long fp) {
        long position = this.indexer.getLogicalPosition(fp);
        long l = -1L;
        long freePosition = -1L;
        for (int i = 0; i < this.bucketCapacity && l != 0L; ++i) {
            l = this.u.getAddress(this.log2phy(position, i));
            if (fp == (l & Long.MAX_VALUE)) {
                return true;
            }
            if (l == 0L && freePosition == -1L) {
                if (i == 0) {
                    ++this.tblLoad;
                }
                this.u.putAddress(this.log2phy(position, i), fp);
                this.tblCnt.getAndIncrement();
                return false;
            }
            if (l >= 0L || freePosition != -1L) continue;
            freePosition = this.log2phy(position, i);
        }
        if (freePosition > -1L && !this.csLookup(fp)) {
            this.u.putAddress(freePosition, fp);
            this.tblCnt.getAndIncrement();
            return false;
        }
        boolean success = this.csInsert(fp);
        if (success) {
            this.tblCnt.getAndIncrement();
        }
        return !success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean csInsert(long fp) {
        try {
            this.csRWLock.writeLock().lock();
            boolean bl = this.collisionBucket.add(fp);
            return bl;
        }
        finally {
            this.csRWLock.writeLock().unlock();
        }
    }

    private long log2phy(long bucketNumber, long inBucketPosition) {
        return this.log2phy(bucketNumber + inBucketPosition);
    }

    private long log2phy(long logicalAddress) {
        return this.baseAddress + (logicalAddress << this.logAddressSize);
    }

    @Override
    public long getTblCapacity() {
        return this.maxTblCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCollisionBucketCnt() {
        try {
            this.csRWLock.readLock().lock();
            long l = this.collisionBucket.size();
            return l;
        }
        finally {
            this.csRWLock.readLock().unlock();
        }
    }

    @Override
    public double getCollisionRatio() {
        return (double)this.getCollisionBucketCnt() / this.tblCnt.doubleValue();
    }

    public class PrettyPrinter {
        public void printDistribution(int increments) {
            int mask = increments - 1;
            int cnt = 0;
            int min = Integer.MAX_VALUE;
            int max = 0;
            for (long i = OffHeapDiskFPSet.this.maxTblCnt - 1L; i >= 0L; --i) {
                if ((i & (long)mask) == 0L) {
                    if (cnt > max) {
                        max = cnt;
                    }
                    if (cnt < min) {
                        min = cnt;
                    }
                    System.out.println(i + " " + cnt);
                    cnt = 0;
                }
                if (OffHeapDiskFPSet.this.u.getAddress(OffHeapDiskFPSet.this.log2phy(i)) <= 0L) continue;
                ++cnt;
            }
            System.out.println("max: " + max + " min: " + min + " avg:" + (double)OffHeapDiskFPSet.this.tblLoad / OffHeapDiskFPSet.this.tblCnt.doubleValue());
        }

        public void printBuckets() {
            this.printBuckets(0, OffHeapDiskFPSet.this.maxTblCnt);
        }

        public void printBuckets(int from, long to) {
            for (long i = (long)from; i < OffHeapDiskFPSet.this.maxTblCnt && i < to; ++i) {
                if (i % (long)OffHeapDiskFPSet.this.bucketCapacity == 0L) {
                    System.out.println("Bucket idx: " + i);
                }
                System.out.println(OffHeapDiskFPSet.this.u.getAddress(OffHeapDiskFPSet.this.log2phy(i)));
            }
        }
    }

    public class TreeSetCollisionBucket
    implements CollisionBucket {
        private final TreeSet<Long> set = new TreeSet();

        public TreeSetCollisionBucket(int initialCapacity) {
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public void prepareForFlush() {
        }

        @Override
        public void remove(long first) {
            this.set.remove(first);
        }

        @Override
        public long first() {
            return this.set.first();
        }

        @Override
        public long last() {
            return this.set.last();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean add(long fp) {
            return this.set.add(fp);
        }

        @Override
        public boolean contains(long fp) {
            return this.set.contains(fp);
        }

        @Override
        public long size() {
            return this.set.size();
        }
    }

    public static interface CollisionBucket {
        public void clear();

        public void prepareForFlush();

        public void remove(long var1);

        public long first();

        public long last();

        public boolean isEmpty();

        public boolean add(long var1);

        public boolean contains(long var1);

        public long size();
    }

    public class ByteBufferIterator {
        private final CollisionBucket cs;
        private long bufferElements;
        private final long totalElements;
        private long logicalPosition = 0L;
        private long previous = -1L;
        private long readElements = 0L;
        private long cache = -1L;
        private final Unsafe unsafe;

        public ByteBufferIterator(Unsafe u, long baseAddress, CollisionBucket collisionBucket, long expectedElements) {
            this.unsafe = u;
            this.logicalPosition = 0L;
            this.totalElements = expectedElements;
            this.bufferElements = expectedElements - collisionBucket.size();
            this.cs = collisionBucket;
            this.cs.prepareForFlush();
        }

        public long next() {
            long first;
            long result = -1L;
            if (this.cache < 0L && this.bufferElements > 0L) {
                result = this.getNextFromBuffer();
                --this.bufferElements;
            } else {
                result = this.cache;
                this.cache = -1L;
            }
            if (!(this.cs.isEmpty() || result <= (first = this.cs.first()) && result != -1L)) {
                this.cs.remove(first);
                this.cache = result;
                result = first;
            }
            if (result == -1L) {
                throw new NoSuchElementException();
            }
            Assert.check(this.previous < result, 1000);
            this.previous = result;
            ++this.readElements;
            return result;
        }

        private long getNextFromBuffer() {
            this.sortNextBucket();
            long l = this.unsafe.getAddress(this.log2phy(this.logicalPosition));
            if (l > 0L) {
                this.unsafe.putAddress(this.log2phy(this.logicalPosition++), l | Long.MIN_VALUE);
                return l;
            }
            while ((l = this.unsafe.getAddress(this.log2phy(this.logicalPosition))) <= 0L && this.logicalPosition < OffHeapDiskFPSet.this.maxTblCnt) {
                this.logicalPosition = OffHeapDiskFPSet.this.indexer.getNextBucketBasePosition(this.logicalPosition);
                this.sortNextBucket();
            }
            if (l > 0L) {
                this.unsafe.putAddress(this.log2phy(this.logicalPosition++), l | Long.MIN_VALUE);
                return l;
            }
            throw new NoSuchElementException();
        }

        private void sortNextBucket() {
            if (OffHeapDiskFPSet.this.indexer.isBucketBasePosition(this.logicalPosition)) {
                long l;
                int i;
                long[] longBuffer = new long[OffHeapDiskFPSet.this.bucketCapacity];
                for (i = 0; i < OffHeapDiskFPSet.this.bucketCapacity && (l = this.unsafe.getAddress(this.log2phy(this.logicalPosition + (long)i))) > 0L; ++i) {
                    longBuffer[i] = l;
                }
                if (i > 0) {
                    Arrays.sort(longBuffer, 0, i);
                    for (int j = 0; j < i; ++j) {
                        this.unsafe.putAddress(this.log2phy(this.logicalPosition, j), longBuffer[j]);
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.readElements < this.totalElements;
        }

        public long getLast() {
            long tmpLogicalPosition = this.logicalPosition;
            this.logicalPosition = OffHeapDiskFPSet.this.maxTblCnt - (long)OffHeapDiskFPSet.this.bucketCapacity;
            this.sortNextBucket();
            long l = 1L;
            while ((l = this.unsafe.getAddress(this.log2phy(this.logicalPosition-- + (long)OffHeapDiskFPSet.this.bucketCapacity - 1L))) <= 0L) {
                this.sortNextBucket();
            }
            this.logicalPosition = tmpLogicalPosition;
            if (!this.cs.isEmpty()) {
                l = Math.max(this.cs.last(), l);
            }
            if (l > 0L) {
                return l;
            }
            throw new NoSuchElementException();
        }

        private long log2phy(long logicalAddress) {
            return OffHeapDiskFPSet.this.log2phy(logicalAddress);
        }

        private long log2phy(long bucketAddress, long inBucketAddress) {
            return OffHeapDiskFPSet.this.log2phy(bucketAddress, inBucketAddress);
        }
    }

    public class OffHeapMSBFlusher
    extends DiskFPSet.Flusher {
        @Override
        void flushTable() throws IOException {
            super.flushTable();
            OffHeapDiskFPSet.this.collisionBucket.clear();
        }

        @Override
        protected void mergeNewEntries(RandomAccessFile inRAF, RandomAccessFile outRAF) throws IOException {
            long buffLen = OffHeapDiskFPSet.this.tblCnt.get();
            ByteBufferIterator itr = new ByteBufferIterator(OffHeapDiskFPSet.this.u, OffHeapDiskFPSet.this.baseAddress, OffHeapDiskFPSet.this.collisionBucket, buffLen);
            long maxVal = itr.getLast();
            if (OffHeapDiskFPSet.this.index != null) {
                maxVal = Math.max(maxVal, OffHeapDiskFPSet.this.index[OffHeapDiskFPSet.this.index.length - 1]);
            }
            int indexLen = OffHeapDiskFPSet.this.calculateIndexLen(buffLen);
            OffHeapDiskFPSet.this.index = new long[indexLen];
            OffHeapDiskFPSet.this.index[indexLen - 1] = maxVal;
            OffHeapDiskFPSet.this.currIndex = 0;
            OffHeapDiskFPSet.this.counter = 0;
            long value = 0L;
            boolean eof = false;
            if (OffHeapDiskFPSet.this.fileCnt > 0L) {
                try {
                    value = inRAF.readLong();
                }
                catch (EOFException e) {
                    eof = true;
                }
            } else {
                eof = true;
            }
            boolean eol = false;
            long fp = itr.next();
            while (!eof || !eol) {
                if ((value < fp || eol) && !eof) {
                    OffHeapDiskFPSet.this.writeFP(outRAF, value);
                    try {
                        value = inRAF.readLong();
                    }
                    catch (EOFException e) {
                        eof = true;
                    }
                    continue;
                }
                if (value == fp) {
                    MP.printWarning(2166, String.valueOf(value));
                }
                OffHeapDiskFPSet.this.writeFP(outRAF, fp);
                try {
                    fp = itr.next();
                }
                catch (NoSuchElementException e) {
                    Assert.check(!itr.hasNext(), 1000);
                    eol = true;
                }
            }
            Assert.check(eof && eol, 1000);
            Assert.check(OffHeapDiskFPSet.this.currIndex == indexLen - 1, 2134);
            OffHeapDiskFPSet.this.fileCnt += buffLen;
        }
    }

    public class BitshiftingIndexer
    extends Indexer {
        protected final long bucketBaseIdx;

        public BitshiftingIndexer(int moveBy, int prefixBits) throws RemoteException {
            super(moveBy, prefixBits);
            this.bucketBaseIdx = Long.MAX_VALUE - (long)(OffHeapDiskFPSet.this.bucketCapacity - 1);
        }

        @Override
        protected long getLogicalPosition(long fp) {
            long position = (fp & this.prefixMask) >> this.moveBy & this.bucketBaseIdx;
            return position;
        }

        @Override
        public long getNextBucketBasePosition(long logicalPosition) {
            return logicalPosition + (long)OffHeapDiskFPSet.this.bucketCapacity & this.bucketBaseIdx;
        }

        @Override
        public boolean isBucketBasePosition(long logicalPosition) {
            return (logicalPosition & 0xFL) == 0L;
        }
    }

    public class Indexer {
        protected final long prefixMask;
        protected final int moveBy;
        protected final int lockMoveBy;

        public Indexer(int moveBy, int prefixBits) {
            this.prefixMask = Long.MAX_VALUE >>> prefixBits;
            this.moveBy = moveBy;
            this.lockMoveBy = 63 - prefixBits - DiskFPSet.LogLockCnt;
        }

        protected int getLockIndex(long fp) {
            long idx = (fp & this.prefixMask) >> this.lockMoveBy;
            Assert.check(0L <= idx && idx < (long)OffHeapDiskFPSet.this.lockCnt, 1000);
            return (int)idx;
        }

        protected long getLogicalPosition(long fp) {
            long position = (fp & this.prefixMask) >> this.moveBy;
            Assert.check(0L <= (position = this.floorToBucket(position)) && position < OffHeapDiskFPSet.this.maxTblCnt, 1000);
            return position;
        }

        public long getNextBucketBasePosition(long logicalPosition) {
            return this.floorToBucket(logicalPosition + (long)OffHeapDiskFPSet.this.bucketCapacity);
        }

        private long floorToBucket(long logicalPosition) {
            long d = (long)Math.floor(logicalPosition / (long)OffHeapDiskFPSet.this.bucketCapacity);
            return (long)OffHeapDiskFPSet.this.bucketCapacity * d;
        }

        public boolean isBucketBasePosition(long logicalPosition) {
            return logicalPosition % (long)OffHeapDiskFPSet.this.bucketCapacity == 0L;
        }
    }
}

