/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.rmi.RemoteException;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSetConfiguration;
import util.Assert;

public abstract class HeapBasedDiskFPSet
extends DiskFPSet {
    protected final int lockMask;
    protected long[][] tbl;
    protected long mask;
    protected final int capacity;
    protected int logMaxMemCnt;
    protected static final int BucketSizeIncrement = 4;
    protected static final int LogDefaultMaxTblCnt = 19;
    static final int DefaultMaxTblCnt = 524288;

    protected HeapBasedDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        long maxMemCnt = (long)((double)fpSetConfig.getMemoryInFingerprintCnt() / this.getAuxiliaryStorageRequirement());
        if (maxMemCnt - 4L <= 0L) {
            maxMemCnt = 524288L;
        }
        this.logMaxMemCnt = 63 - Long.numberOfLeadingZeros(maxMemCnt);
        Assert.check(this.logMaxMemCnt - 4 >= 0, "Underflow when computing HeapBasedDiskFPSet");
        this.capacity = 1 << this.logMaxMemCnt - 4;
        this.maxTblCnt = this.logMaxMemCnt >= 31 ? Integer.MAX_VALUE : (long)(1 << this.logMaxMemCnt);
        Assert.check(this.maxTblCnt <= fpSetConfig.getMemoryInFingerprintCnt(), "Exceeded upper memory storage limit");
        Assert.check(this.maxTblCnt > (long)this.capacity && (long)this.capacity > this.tblCnt.get(), "negative maxTblCnt");
        this.mask = this.capacity - 1;
        this.lockMask = this.lockCnt - 1;
        this.tbl = new long[this.capacity][];
    }

    @Override
    public long sizeof() {
        long size = 44L;
        this.rwLock.acquireAllLocks();
        size += (long)(16 + this.tbl.length * 4);
        for (int i = 0; i < this.tbl.length; ++i) {
            if (this.tbl[i] == null) continue;
            size += 16L + (long)this.tbl[i].length * 8L;
        }
        this.rwLock.releaseAllLocks();
        return size += this.getIndexCapacity() * 4L;
    }

    @Override
    public long getTblCapacity() {
        return this.tbl.length;
    }

    protected int getIndex(long fp) {
        return (int)this.index(fp, this.mask);
    }

    @Override
    protected int getLockIndex(long fp) {
        return (int)this.index(fp, this.lockMask);
    }

    protected long index(long fp, long aMask) {
        return fp & aMask;
    }

    @Override
    boolean memLookup(long fp) {
        long[] bucket = this.tbl[this.getIndex(fp)];
        if (bucket == null) {
            return false;
        }
        int bucketLen = bucket.length;
        for (int i = 0; i < bucketLen && bucket[i] != 0L; ++i) {
            if (fp != (bucket[i] & Long.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean memInsert(long fp) {
        int index = this.getIndex(fp);
        long[] bucket = this.tbl[index];
        if (bucket == null) {
            bucket = new long[16];
            bucket[0] = fp;
            this.tbl[index] = bucket;
            this.bucketsCapacity += 16L;
            ++this.tblLoad;
        } else {
            int j;
            int bucketLen = bucket.length;
            int i = -1;
            for (j = 0; j < bucketLen && bucket[j] != 0L; ++j) {
                long fp1 = bucket[j];
                long l = fp1 & Long.MAX_VALUE;
                if (fp == l) {
                    return true;
                }
                if (i != -1 || fp1 >= 0L) continue;
                i = j;
            }
            if (i == -1) {
                if (j == bucketLen) {
                    long[] oldBucket = bucket;
                    bucket = new long[bucketLen + 4];
                    System.arraycopy(oldBucket, 0, bucket, 0, bucketLen);
                    this.tbl[index] = bucket;
                    this.bucketsCapacity += 4L;
                }
                bucket[j] = fp;
            } else {
                if (j != bucketLen) {
                    bucket[j] = bucket[i];
                }
                bucket[i] = fp;
            }
        }
        this.tblCnt.getAndIncrement();
        return false;
    }
}

