/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.TLCTrace;
import tlc2.tool.WorkerException;
import tlc2.tool.distributed.DistApp;
import tlc2.tool.distributed.DistributedFPSetTLCServer;
import tlc2.tool.distributed.InternRMI;
import tlc2.tool.distributed.TLCApp;
import tlc2.tool.distributed.TLCServerRMI;
import tlc2.tool.distributed.TLCServerThread;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.tool.distributed.fp.NonDistributedFPSetManager;
import tlc2.tool.distributed.management.TLCServerMXWrapper;
import tlc2.tool.distributed.selector.BlockSelectorFactory;
import tlc2.tool.distributed.selector.IBlockSelector;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.FP64;
import util.Assert;
import util.FileUtil;
import util.MailSender;
import util.SimpleFilenameToStream;
import util.UniqueString;

public class TLCServer
extends UnicastRemoteObject
implements TLCServerRMI,
InternRMI {
    public static final String THREAD_NAME_PREFIX = "TLCWorkerThread-";
    static long finalNumberOfDistinctStates = -1L;
    public static int Port = Integer.getInteger(TLCServer.class.getName() + ".port", 10997);
    private static final int REPORT_INTERVAL = Integer.getInteger(TLCServer.class.getName() + ".report", 60000);
    private static final boolean VETO_CLEANUP = Boolean.getBoolean(TLCServer.class.getName() + ".vetoCleanup");
    private static final int expectedFPSetCount = Integer.getInteger(TLCServer.class.getName() + ".expectedFPSetCount", 0);
    private long distinctStatesPerMinute;
    private long statesPerMinute;
    protected final AtomicLong workerStatesGenerated = new AtomicLong(0L);
    private final ExecutorService es = Executors.newCachedThreadPool();
    public final IFPSetManager fpSetManager;
    public final IStateQueue stateQueue;
    public final TLCTrace trace;
    private final DistApp work;
    private final String metadir;
    private final String filename;
    private TLCState errState = null;
    private boolean done = false;
    private boolean keepCallStack = false;
    private final Map<TLCServerThread, TLCWorkerRMI> threadsToWorkers = new ConcurrentHashMap<TLCServerThread, TLCWorkerRMI>();
    private final IBlockSelector blockSelector;

    public TLCServer(TLCApp work) throws IOException, NotBoundException {
        Assert.check(work != null, "TLC server found null work.");
        this.metadir = work.getMetadir();
        int end = this.metadir.length();
        if (this.metadir.endsWith(FileUtil.separator)) {
            --end;
        }
        int start = this.metadir.lastIndexOf(FileUtil.separator, end - 1);
        this.filename = this.metadir.substring(start + 1, end);
        this.work = work;
        this.stateQueue = new DiskStateQueue(this.metadir);
        this.trace = new TLCTrace(this.metadir, this.work.getFileName(), this.work);
        this.fpSetManager = this.getFPSetManagerImpl(work, this.metadir, expectedFPSetCount);
        this.blockSelector = BlockSelectorFactory.getBlockSelector(this);
    }

    protected IFPSetManager getFPSetManagerImpl(TLCApp work, String metadir, int fpsetCount) throws IOException {
        FPSet fpSet = FPSetFactory.getFPSet(work.getFPSetConfiguration());
        fpSet.init(1, metadir, work.getFileName());
        return new NonDistributedFPSetManager(fpSet, InetAddress.getLocalHost().getCanonicalHostName());
    }

    @Override
    public final Boolean getCheckDeadlock() {
        return this.work.getCheckDeadlock();
    }

    @Override
    public final Boolean getPreprocess() {
        return this.work.getPreprocess();
    }

    @Override
    public IFPSetManager getFPSetManager() {
        return this.fpSetManager;
    }

    @Override
    public final long getIrredPolyForFP() {
        return FP64.getIrredPoly();
    }

    @Override
    public final UniqueString intern(String str) {
        return UniqueString.uniqueStringOf(str);
    }

    @Override
    public final synchronized void registerWorker(TLCWorkerRMI worker) throws IOException {
        this.stateQueue.resumeAllStuck();
        TLCServerThread thread = new TLCServerThread(worker, worker.getURI(), this, this.es, this.blockSelector);
        this.threadsToWorkers.put(thread, worker);
        thread.start();
        MP.printMessage(7001, worker.getURI().toString());
    }

    @Override
    public synchronized void registerFPSet(FPSetRMI fpSet, String hostname) throws RemoteException {
        throw new UnsupportedOperationException("Not applicable for non-distributed TLCServer");
    }

    public TLCWorkerRMI removeTLCServerThread(TLCServerThread thread) {
        TLCWorkerRMI worker = this.threadsToWorkers.remove(thread);
        if (worker != null) {
            MP.printMessage(7002, thread.getUri().toString());
        }
        return worker;
    }

    public final synchronized boolean setErrState(TLCState s, boolean keep) {
        if (this.done) {
            return false;
        }
        this.done = true;
        this.errState = s;
        this.keepCallStack = keep;
        return true;
    }

    public final void setDone() {
        this.done = true;
    }

    public void addStatesGeneratedDelta(long delta) {
        this.workerStatesGenerated.addAndGet(delta);
    }

    public void checkpoint() throws IOException, InterruptedException {
        if (this.stateQueue.suspendAll()) {
            MP.printMessage(2195, "-- Checkpointing of run " + this.metadir + " compl");
            this.stateQueue.beginChkpt();
            this.trace.beginChkpt();
            this.fpSetManager.checkpoint(this.filename);
            this.stateQueue.resumeAll();
            UniqueString.internTbl.beginChkpt(this.metadir);
            this.stateQueue.commitChkpt();
            this.trace.commitChkpt();
            UniqueString.internTbl.commitChkpt(this.metadir);
            this.fpSetManager.commitChkpt();
            MP.printMessage(2196, "eted.");
        }
    }

    public final void recover() throws IOException, InterruptedException {
        this.trace.recover();
        this.stateQueue.recover();
        this.fpSetManager.recover(this.filename);
    }

    private final Set<Long> doInit() throws Exception {
        TreeSet<Long> set = new TreeSet<Long>();
        TLCState curState = null;
        try {
            TLCState[] initStates = this.work.getInitStates();
            for (int i = 0; i < initStates.length; ++i) {
                curState = initStates[i];
                boolean inConstraints = this.work.isInModel(curState);
                boolean seen = false;
                if (inConstraints) {
                    long fp = curState.fingerPrint();
                    boolean bl = seen = !set.add(fp);
                    if (!seen) {
                        initStates[i].uid = this.trace.writeState(fp);
                        this.stateQueue.enqueue(initStates[i]);
                    }
                }
                if (inConstraints && seen) continue;
                this.work.checkState(null, curState);
            }
        }
        catch (Exception e) {
            this.errState = curState;
            this.keepCallStack = true;
            if (e instanceof WorkerException) {
                this.errState = ((WorkerException)e).state2;
                this.keepCallStack = ((WorkerException)e).keepCallStack;
            }
            this.done = true;
            throw e;
        }
        return set;
    }

    public final void close(boolean cleanup) throws IOException {
        this.trace.close();
        this.fpSetManager.close(cleanup);
        if (cleanup && !VETO_CLEANUP) {
            FileUtil.deleteDir(new File(this.metadir), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modelCheck() throws IOException, InterruptedException, NotBoundException {
        boolean recovered = false;
        if (this.work.canRecover()) {
            MP.printMessage(2197, this.metadir);
            this.recover();
            MP.printMessage(2198, new String[]{String.valueOf(this.fpSetManager.size()), String.valueOf(this.stateQueue.size())});
            recovered = true;
        }
        Set<Object> initFPs = new TreeSet();
        if (!recovered) {
            try {
                MP.printMessage(2189);
                initFPs = this.doInit();
                MP.printMessage(2190, new String[]{String.valueOf(this.stateQueue.size()), "(s)"});
            }
            catch (Throwable e) {
                this.done = true;
                MP.printError(1000, "initializing the server", e);
                if (this.errState != null) {
                    MP.printMessage(2102, "While working on the initial state: " + this.errState);
                }
                this.work.setCallStack();
                try {
                    initFPs = this.doInit();
                }
                catch (Throwable e1) {
                    MP.printError(1000, "evaluating the nested\nexpressions at the following positions:\n" + this.work.printCallStack(), e);
                }
            }
        }
        if (this.done) {
            this.close(false);
            return;
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        Registry rg = LocateRegistry.createRegistry(Port);
        rg.rebind("TLCServer", this);
        MP.printMessage(7000, hostname);
        this.waitForFPSetManager();
        for (Long fp : initFPs) {
            this.fpSetManager.put(fp);
        }
        long oldNumOfGenStates = 0L;
        long oldFPSetSize = 0L;
        TLCServer tLCServer = this;
        synchronized (tLCServer) {
            this.wait(REPORT_INTERVAL);
        }
        while (true) {
            if (TLCGlobals.doCheckPoint()) {
                this.checkpoint();
            }
            tLCServer = this;
            synchronized (tLCServer) {
                if (!this.done) {
                    long numOfGenStates = this.getStatesGenerated();
                    long fpSetSize = this.fpSetManager.size();
                    double factor = (double)REPORT_INTERVAL / 60000.0;
                    this.statesPerMinute = (long)((double)(numOfGenStates - oldNumOfGenStates) / factor);
                    this.distinctStatesPerMinute = (long)((double)(fpSetSize - oldFPSetSize) / factor);
                    MP.printMessage(2200, new String[]{String.valueOf(this.trace.getLevelForReporting()), String.valueOf(numOfGenStates), String.valueOf(fpSetSize), String.valueOf(this.getNewStates()), String.valueOf(this.statesPerMinute), String.valueOf(this.distinctStatesPerMinute)});
                    this.wait(REPORT_INTERVAL);
                    oldFPSetSize = fpSetSize;
                    oldNumOfGenStates = numOfGenStates;
                }
                if (this.done) {
                    break;
                }
            }
        }
        Assert.check(!this.hasNoErrors() || this.stateQueue.isEmpty(), 1000);
        for (Map.Entry<TLCServerThread, TLCWorkerRMI> entry : this.threadsToWorkers.entrySet()) {
            TLCServerThread thread = entry.getKey();
            TLCWorkerRMI worker = entry.getValue();
            thread.join();
            int sentStates = thread.getSentStates();
            int receivedStates = thread.getReceivedStates();
            double cacheHitRatio = thread.getCacheRateRatio();
            URI name = thread.getUri();
            MP.printMessage(7003, new String[]{name.toString(), Integer.toString(sentStates), Integer.toString(receivedStates), cacheHitRatio < 0.0 ? "n/a" : String.format("%1$,.2f", cacheHitRatio)});
            try {
                worker.exit();
            }
            catch (NoSuchObjectException e) {
                MP.printWarning(1000, "Ignoring attempt to exit dead worker");
            }
        }
        this.es.shutdown();
        finalNumberOfDistinctStates = this.fpSetManager.size();
        long statesGenerated = this.getStatesGenerated();
        long statesLeftInQueue = this.getNewStates();
        int level = this.trace.getLevelForReporting();
        this.statesPerMinute = 0L;
        this.distinctStatesPerMinute = 0L;
        if (this.hasNoErrors()) {
            double actualProb = this.fpSetManager.checkFPs();
            long statesSeen = this.fpSetManager.getStatesSeen();
            ModelChecker.reportSuccess(finalNumberOfDistinctStates, actualProb, statesSeen);
        } else if (this.keepCallStack) {
            this.work.setCallStack();
        }
        TLCServer.printSummary(level, statesGenerated, statesLeftInQueue, finalNumberOfDistinctStates, this.hasNoErrors());
        MP.printMessage(2186);
        MP.flush();
        this.close(this.hasNoErrors());
        rg.unbind("TLCServer");
        UnicastRemoteObject.unexportObject(this, false);
    }

    protected void waitForFPSetManager() throws InterruptedException {
    }

    public long getStatesGeneratedPerMinute() {
        return this.statesPerMinute;
    }

    public long getDistinctStatesGeneratedPerMinute() {
        return this.distinctStatesPerMinute;
    }

    public long getAverageBlockCnt() {
        return this.blockSelector.getAverageBlockCnt();
    }

    private boolean hasNoErrors() {
        return this.errState == null;
    }

    public synchronized long getNewStates() {
        long res = this.stateQueue.size();
        for (TLCServerThread thread : this.threadsToWorkers.keySet()) {
            res += (long)thread.getCurrentSize();
        }
        return res;
    }

    public long getStatesGenerated() {
        return this.workerStatesGenerated.get() + this.fpSetManager.getStatesSeen();
    }

    public static final void printSummary(int level, long statesGenerated, long statesLeftInQueue, long distinctStates, boolean success) throws IOException {
        if (TLCGlobals.tool) {
            MP.printMessage(2200, new String[]{String.valueOf(level), String.valueOf(statesGenerated), String.valueOf(distinctStates), String.valueOf(statesLeftInQueue), "0", "0"});
        }
        MP.printMessage(2199, new String[]{String.valueOf(statesGenerated), String.valueOf(distinctStates), String.valueOf(statesLeftInQueue)});
        if (success) {
            MP.printMessage(2194, String.valueOf(level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        MP.printMessage(1000, "TLC Server " + TLCGlobals.versionOfTLC);
        TLCStandardMBean tlcServerMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
        MailSender mail = null;
        TLCServer server = null;
        try {
            TLCGlobals.setNumWorkers(0);
            TLCApp app = TLCApp.create(argv);
            mail = new MailSender(app.getFileName());
            server = expectedFPSetCount > 0 ? new DistributedFPSetTLCServer(app, expectedFPSetCount) : new TLCServer(app);
            tlcServerMXWrapper = new TLCServerMXWrapper(server);
            if (server != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(new WorkerShutdownHook(server)));
                server.modelCheck();
            }
        }
        catch (Throwable e) {
            System.gc();
            if (e instanceof StackOverflowError) {
                MP.printError(1005, e);
            } else if (e instanceof OutOfMemoryError) {
                MP.printError(1001, e);
            } else {
                MP.printError(1000, e);
            }
            if (server != null) {
                try {
                    server.close(false);
                }
                catch (Exception e1) {
                    MP.printError(1000, e1);
                }
            }
        }
        finally {
            tlcServerMXWrapper.unregister();
            boolean send = mail.send();
            if (!send) {
                System.exit(1);
            }
        }
    }

    public int getWorkerCount() {
        return this.threadsToWorkers.size();
    }

    synchronized TLCServerThread[] getThreads() {
        return this.threadsToWorkers.keySet().toArray(new TLCServerThread[this.threadsToWorkers.size()]);
    }

    public boolean isRunning() {
        return !this.done;
    }

    @Override
    public boolean isDone() throws RemoteException {
        return this.done;
    }

    @Override
    public String getSpecFileName() throws RemoteException {
        return this.work.getFileName();
    }

    @Override
    public String getConfigFileName() throws RemoteException {
        return this.work.getConfigName();
    }

    @Override
    public byte[] getFile(String file) throws RemoteException {
        String name = new File(file).getName();
        File f = new SimpleFilenameToStream().resolve(name);
        return this.read(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] read(File file) {
        byte[] buffer;
        block19: {
            FileInputStream in;
            RuntimeException pending;
            block16: {
                if (file.isDirectory()) {
                    throw new RuntimeException("Unsupported operation, file " + file.getAbsolutePath() + " is a directory");
                }
                if (file.length() > Integer.MAX_VALUE) {
                    throw new RuntimeException("Unsupported operation, file " + file.getAbsolutePath() + " is too big");
                }
                pending = null;
                in = null;
                buffer = new byte[(int)file.length()];
                in = new FileInputStream(file);
                in.read(buffer);
                if (in == null) break block16;
                try {
                    in.close();
                }
                catch (Exception e) {
                    if (pending != null) break block16;
                    pending = new RuntimeException("Exception occured on closing file" + file.getAbsolutePath(), e);
                }
            }
            if (pending != null) {
                throw new RuntimeException(pending);
            }
            break block19;
            catch (Exception e) {
                block17: {
                    try {
                        pending = new RuntimeException("Exception occured on reading file " + file.getAbsolutePath(), e);
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception e2) {
                                    if (pending != null) break block18;
                                    pending = new RuntimeException("Exception occured on closing file" + file.getAbsolutePath(), e2);
                                }
                            }
                        }
                        if (pending != null) {
                            throw new RuntimeException(pending);
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e3) {
                        if (pending != null) break block17;
                        pending = new RuntimeException("Exception occured on closing file" + file.getAbsolutePath(), e3);
                    }
                }
                if (pending != null) {
                    throw new RuntimeException(pending);
                }
            }
        }
        return buffer;
    }

    private static class WorkerShutdownHook
    implements Runnable {
        private final TLCServer server;

        public WorkerShutdownHook(TLCServer aServer) {
            this.server = aServer;
        }

        @Override
        public void run() {
            for (TLCWorkerRMI worker : this.server.threadsToWorkers.values()) {
                try {
                    worker.exit();
                }
                catch (ConnectException e) {
                }
                catch (NoSuchObjectException e) {
                }
                catch (IOException e) {
                    MP.printError(1000, e);
                }
            }
        }
    }
}

