/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.Defns;
import tlc2.tool.ModelConfig;
import tlc2.tool.TLAClass;
import tlc2.tool.TLARegistry;
import tlc2.tool.TLCState;
import tlc2.tool.ToolGlobals;
import tlc2.util.Context;
import tlc2.util.List;
import tlc2.util.ObjLongTable;
import tlc2.util.Vect;
import tlc2.value.BoolValue;
import tlc2.value.IntValue;
import tlc2.value.LazyValue;
import tlc2.value.MethodValue;
import tlc2.value.ModelValue;
import tlc2.value.OpRcdValue;
import tlc2.value.SetEnumValue;
import tlc2.value.StringValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import util.Assert;
import util.FilenameToStream;
import util.ToolIO;
import util.UniqueString;

public class Spec
implements ValueConstants,
ToolGlobals,
Serializable {
    public String specDir;
    public String rootFile;
    protected String configFile;
    protected ModelConfig config;
    protected ExternalModuleTable moduleTbl;
    protected ModuleNode rootModule;
    protected HashSet processedDefs;
    protected Defns defns;
    public OpDeclNode[] variablesNodes;
    protected TLAClass tlaClass;
    protected Vect initPredVec;
    protected Action nextPred;
    protected Action[] temporals;
    protected String[] temporalNames;
    protected Action[] impliedTemporals;
    protected String[] impliedTemporalNames;
    protected Action[] invariants;
    protected String[] invNames;
    protected Action[] impliedInits;
    protected String[] impliedInitNames;
    protected Action[] impliedActions;
    protected String[] impliedActNames;
    protected ExprNode[] modelConstraints;
    protected ExprNode[] actionConstraints;
    protected ExprNode[] assumptions;
    protected boolean[] assumptionIsAxiom;
    private FilenameToStream resolver;
    private Vect invVec = new Vect();
    private Vect invNameVec = new Vect();
    private Vect impliedInitVec = new Vect();
    private Vect impliedInitNameVec = new Vect();
    private Vect impliedActionVec = new Vect();
    private Vect impliedActNameVec = new Vect();
    private Vect temporalVec = new Vect();
    private Vect temporalNameVec = new Vect();
    private Vect impliedTemporalVec = new Vect();
    private Vect impliedTemporalNameVec = new Vect();

    public Spec(String specDir, String file, FilenameToStream resolver) {
        this.processedDefs = new HashSet();
        this.specDir = specDir;
        this.rootFile = file;
        this.rootModule = null;
        this.config = null;
        this.moduleTbl = null;
        this.variablesNodes = null;
        this.defns = new Defns();
        this.tlaClass = new TLAClass("tlc2.module");
        this.initPredVec = new Vect(5);
        this.nextPred = null;
        this.temporals = null;
        this.temporalNames = null;
        this.impliedTemporals = null;
        this.impliedTemporalNames = null;
        this.invariants = null;
        this.invNames = null;
        this.impliedInits = null;
        this.impliedInitNames = null;
        this.impliedActions = null;
        this.impliedActNames = null;
        this.modelConstraints = null;
        this.actionConstraints = null;
        this.assumptions = null;
        this.assumptionIsAxiom = null;
        this.resolver = resolver;
    }

    public Spec(String specDir, String specFile, String configFile, FilenameToStream resolver) {
        this(specDir, specFile, resolver);
        ModelValue.init();
        this.configFile = configFile;
        this.config = new ModelConfig(configFile + ".cfg", resolver);
        this.config.parse();
        ModelValue.setValues();
    }

    protected final SpecObj processSpec(SpecObj spec) {
        String rhs;
        UniqueString lhs;
        int i;
        UniqueString modName;
        int i2;
        if (spec == null) {
            spec = new SpecObj(this.rootFile, this.resolver);
            if (TLCGlobals.tool) {
                MP.printMessage(2220);
            }
            try {
                SANY.frontEndMain(spec, this.rootFile, ToolIO.out);
            }
            catch (FrontEndException e) {
                Assert.fail(2171, e);
            }
            if (TLCGlobals.tool) {
                MP.printMessage(2219);
            }
            MP.printMessage(2185);
        }
        if (!(spec.initErrors.isSuccess() && spec.parseErrors.isSuccess() && spec.semanticErrors.isSuccess())) {
            Assert.fail(3002);
        }
        this.moduleTbl = spec.getExternalModuleTable();
        UniqueString rootName = UniqueString.uniqueStringOf(this.rootFile);
        this.rootModule = this.moduleTbl.getModuleNode(rootName);
        OpDeclNode[] varDecls = this.rootModule.getVariableDecls();
        this.variablesNodes = new OpDeclNode[varDecls.length];
        UniqueString[] varNames = new UniqueString[varDecls.length];
        for (int i3 = 0; i3 < varDecls.length; ++i3) {
            this.variablesNodes[i3] = varDecls[i3];
            varNames[i3] = varDecls[i3].getName();
            varNames[i3].setLoc(i3);
        }
        TLCState.setVariables(this.variablesNodes);
        UniqueString.setVariableCount(varDecls.length);
        this.defns.setDefnCount(varDecls.length);
        this.defns.put("TRUE", (Object)ValTrue);
        this.defns.put("FALSE", (Object)ValFalse);
        Value[] elems = new Value[]{ValFalse, ValTrue};
        this.defns.put("BOOLEAN", (Object)new SetEnumValue(elems, true));
        Class stringModule = this.tlaClass.loadClass("Strings");
        if (stringModule == null) {
            Assert.fail(2119);
        }
        Method[] ms = stringModule.getDeclaredMethods();
        for (int i4 = 0; i4 < ms.length; ++i4) {
            int mod = ms[i4].getModifiers();
            if (!Modifier.isStatic(mod)) continue;
            String name = TLARegistry.mapName(ms[i4].getName());
            int acnt = ms[i4].getParameterTypes().length;
            if (ms[i4].isSynthetic()) continue;
            MethodValue mv = new MethodValue(ms[i4]);
            MethodValue val = acnt == 0 ? mv.apply(EmptyArgs, 0) : mv;
            this.defns.put(name, (Object)val);
        }
        ModuleNode[] mods = this.moduleTbl.getModuleNodes();
        HashSet<String> modSet = new HashSet<String>();
        for (int i5 = 0; i5 < mods.length; ++i5) {
            this.processConstants(mods[i5]);
            modSet.add(mods[i5].getName().toString());
        }
        AssumeNode[] assumes = this.rootModule.getAssumptions();
        this.assumptions = new ExprNode[assumes.length];
        this.assumptionIsAxiom = new boolean[assumes.length];
        for (int i6 = 0; i6 < assumes.length; ++i6) {
            this.assumptions[i6] = assumes[i6].getAssume();
            this.assumptionIsAxiom[i6] = assumes[i6].getIsAxiom();
        }
        Hashtable constants = this.initializeConstants();
        Hashtable overrides = this.config.getOverrides();
        OpDeclNode[] rootConsts = this.rootModule.getConstantDecls();
        for (int i7 = 0; i7 < rootConsts.length; ++i7) {
            UniqueString name = rootConsts[i7].getName();
            Object val = constants.get(name.toString());
            if (val == null && !overrides.containsKey(name.toString())) {
                Assert.fail(2222, name.toString());
            }
            rootConsts[i7].setToolObject(TLCGlobals.ToolId, val);
            this.defns.put(name, val);
        }
        OpDefNode[] rootOpDefs = this.rootModule.getOpDefs();
        for (int i8 = 0; i8 < rootOpDefs.length; ++i8) {
            UniqueString name = rootOpDefs[i8].getName();
            Object val = constants.get(name.toString());
            if (val == null) {
                this.defns.put(name, (Object)rootOpDefs[i8]);
                continue;
            }
            rootOpDefs[i8].setToolObject(TLCGlobals.ToolId, val);
            this.defns.put(name, val);
        }
        Hashtable modConstants = this.initializeModConstants();
        for (i2 = 0; i2 < mods.length; ++i2) {
            modName = mods[i2].getName();
            Hashtable mConsts = (Hashtable)modConstants.get(modName.toString());
            if (mConsts == null) continue;
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString name = opDefs[j].getName();
                Object val = mConsts.get(name.toString());
                if (val == null) continue;
                opDefs[j].getBody().setToolObject(TLCGlobals.ToolId, val);
            }
        }
        for (i2 = 0; i2 < mods.length; ++i2) {
            modName = mods[i2].getName();
            Class userModule = this.tlaClass.loadClass(modName.toString());
            if (userModule == null) continue;
            Hashtable<UniqueString, MethodValue> javaDefs = new Hashtable<UniqueString, MethodValue>();
            Method[] mds = userModule.getDeclaredMethods();
            for (int j = 0; j < mds.length; ++j) {
                int mdf = mds[j].getModifiers();
                if (!Modifier.isPublic(mdf) || !Modifier.isStatic(mdf)) continue;
                String name = TLARegistry.mapName(mds[j].getName());
                UniqueString uname = UniqueString.uniqueStringOf(name);
                int acnt = mds[j].getParameterTypes().length;
                MethodValue mv = new MethodValue(mds[j]);
                boolean isConstant = acnt == 0 && Modifier.isFinal(mdf);
                MethodValue val = isConstant ? mv.apply(EmptyArgs, 0) : mv;
                javaDefs.put(uname, val);
            }
            OpDefNode[] opDefs = mods[i2].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                UniqueString uname = opDefs[j].getName();
                Object val = javaDefs.get(uname);
                if (val == null) continue;
                opDefs[j].getBody().setToolObject(TLCGlobals.ToolId, val);
                this.defns.put(uname, val);
            }
        }
        HashSet<String> overriden = new HashSet<String>();
        for (i = 0; i < rootConsts.length; ++i) {
            Object myVal;
            lhs = rootConsts[i].getName();
            rhs = (String)overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail(2223, rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail(2224, new String[]{lhs.toString(), rhs});
            }
            rootConsts[i].setToolObject(TLCGlobals.ToolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        for (i = 0; i < rootOpDefs.length; ++i) {
            Object myVal;
            lhs = rootOpDefs[i].getName();
            rhs = (String)overrides.get(lhs.toString());
            if (rhs == null) continue;
            if (overrides.containsKey(rhs)) {
                Assert.fail(2223, rhs);
            }
            if ((myVal = this.defns.get(rhs)) == null) {
                Assert.fail(2224, new String[]{lhs.toString(), rhs});
            }
            if (myVal instanceof OpDefNode && rootOpDefs[i].getNumberOfArgs() != ((OpDefNode)myVal).getNumberOfArgs()) {
                Assert.fail(2225, new String[]{lhs.toString(), rhs});
            }
            rootOpDefs[i].setToolObject(TLCGlobals.ToolId, myVal);
            this.defns.put(lhs, myVal);
            overriden.add(lhs.toString());
        }
        Enumeration keys = overrides.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (overriden.contains(key)) continue;
            Assert.fail(2226, key.toString());
        }
        Hashtable modOverrides = this.config.getModOverrides();
        for (int i9 = 0; i9 < mods.length; ++i9) {
            UniqueString modName2 = mods[i9].getName();
            Hashtable mDefs = (Hashtable)modOverrides.get(modName2.toString());
            HashSet<String> modOverriden = new HashSet<String>();
            if (mDefs == null) continue;
            OpDefNode[] opDefs = mods[i9].getOpDefs();
            for (int j = 0; j < opDefs.length; ++j) {
                Object myVal;
                UniqueString lhs2 = opDefs[j].getName();
                String rhs2 = (String)mDefs.get(lhs2.toString());
                if (rhs2 == null) continue;
                if (mDefs.containsKey(rhs2)) {
                    Assert.fail(2223, rhs2);
                }
                if ((myVal = this.defns.get(rhs2)) == null) {
                    Assert.fail(2224, new String[]{lhs2.toString(), rhs2});
                }
                if (myVal instanceof OpDefNode && opDefs[j].getNumberOfArgs() != ((OpDefNode)myVal).getNumberOfArgs()) {
                    Assert.fail(2225, new String[]{lhs2.toString(), rhs2});
                }
                opDefs[j].getBody().setToolObject(TLCGlobals.ToolId, myVal);
                modOverriden.add(lhs2.toString());
            }
            Enumeration mkeys = mDefs.keys();
            while (mkeys.hasMoreElements()) {
                Object mkey = mkeys.nextElement();
                if (modOverriden.contains(mkey)) continue;
                Assert.fail(2226, mkey.toString());
            }
        }
        Enumeration modKeys = modOverrides.keys();
        while (modKeys.hasMoreElements()) {
            Object modName3 = modKeys.nextElement();
            if (modSet.contains(modName3)) continue;
            Assert.fail(2245, modName3.toString());
        }
        return spec;
    }

    private final void processConstants(SemanticNode expr) {
        switch (expr.getKind()) {
            case 1: {
                ModuleNode expr1 = (ModuleNode)expr;
                OpDefNode[] opDefs = expr1.getOpDefs();
                for (int i = 0; i < opDefs.length; ++i) {
                    Object def = opDefs[i].getToolObject(TLCGlobals.ToolId);
                    if (def instanceof OpDefNode) {
                        this.processedDefs.add(def);
                        this.processConstants(((OpDefNode)def).getBody());
                    }
                    this.processConstants(opDefs[i].getBody());
                }
                ModuleNode[] imods = expr1.getInnerModules();
                for (int i = 0; i < imods.length; ++i) {
                    this.processConstants(imods[i]);
                }
                AssumeNode[] assumps = expr1.getAssumptions();
                for (int i = 0; i < assumps.length; ++i) {
                    this.processConstants(assumps[i]);
                }
                TheoremNode[] thms = expr1.getTheorems();
                for (int i = 0; i < thms.length; ++i) {
                    this.processConstants(thms[i]);
                }
                return;
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                SymbolNode opNode = expr1.getOperator();
                Object val = this.defns.get(opNode.getName());
                if (val != null) {
                    opNode.setToolObject(TLCGlobals.ToolId, val);
                } else {
                    ExprOrOpArgNode[] args = expr1.getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        this.processConstants(args[i]);
                    }
                    ExprNode[] bnds = expr1.getBdedQuantBounds();
                    for (int i = 0; i < bnds.length; ++i) {
                        this.processConstants(bnds[i]);
                    }
                }
                return;
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                for (int i = 0; i < letDefs.length; ++i) {
                    this.processConstants(letDefs[i].getBody());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                for (int i = 0; i < subs.length; ++i) {
                    this.processConstants(subs[i].getExpr());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                for (int i = 0; i < subs.length; ++i) {
                    this.processConstants(subs[i].getExpr());
                }
                this.processConstants(expr1.getBody());
                return;
            }
            case 16: {
                NumeralNode expr1 = (NumeralNode)expr;
                IntValue val = IntValue.gen(expr1.val());
                if (expr1.bigVal() != null) {
                    Assert.fail(2265, expr1.toString());
                    return;
                }
                expr1.setToolObject(TLCGlobals.ToolId, val);
                return;
            }
            case 17: {
                DecimalNode expr1 = (DecimalNode)expr;
                Assert.fail(2244, expr1.toString());
                return;
            }
            case 18: {
                StringNode expr1 = (StringNode)expr;
                StringValue val = new StringValue(expr1.getRep());
                expr1.setToolObject(TLCGlobals.ToolId, val);
                return;
            }
            case 20: {
                AssumeNode expr1 = (AssumeNode)expr;
                this.processConstants(expr1.getAssume());
                return;
            }
            case 12: {
                TheoremNode expr1 = (TheoremNode)expr;
                this.processConstants(expr1.getTheorem());
                return;
            }
            case 8: {
                OpDefNode opdef;
                SymbolNode opArgNode = ((OpArgNode)expr).getOp();
                if (opArgNode.getKind() == 5 && !this.processedDefs.contains(opdef = (OpDefNode)opArgNode)) {
                    this.processedDefs.add(opdef);
                    this.processConstants(opdef.getBody());
                }
                return;
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                this.processConstants(expr1.getBody());
            }
        }
    }

    public final SymbolNode getVar(SemanticNode expr, Context c, boolean cutoff) {
        SymbolNode opNode;
        if (expr instanceof OpApplNode && (opNode = ((OpApplNode)expr).getOperator()).getArity() == 0) {
            boolean isVarDecl = opNode.getKind() == 3;
            Object val = this.lookup(opNode, c, cutoff && isVarDecl);
            if (val instanceof LazyValue) {
                LazyValue lval = (LazyValue)val;
                return this.getVar(lval.expr, lval.con, cutoff);
            }
            if (val instanceof OpDefNode) {
                return this.getVar(((OpDefNode)val).getBody(), c, cutoff);
            }
            if (isVarDecl) {
                return opNode;
            }
        }
        return null;
    }

    public final SymbolNode getPrimedVar(SemanticNode expr, Context c, boolean cutoff) {
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            SymbolNode opNode = expr1.getOperator();
            if (BuiltInOPs.getOpCode(opNode.getName()) == 48) {
                return this.getVar(expr1.getArgs()[0], c, cutoff);
            }
            if (opNode.getArity() == 0) {
                boolean isVarDecl = opNode.getKind() == 3;
                Object val = this.lookup(opNode, c, cutoff && isVarDecl);
                if (val instanceof LazyValue) {
                    LazyValue lval = (LazyValue)val;
                    return this.getPrimedVar(lval.expr, lval.con, cutoff);
                }
                if (val instanceof OpDefNode) {
                    return this.getPrimedVar(((OpDefNode)val).getBody(), c, cutoff);
                }
            }
        }
        return null;
    }

    public final void processConfig() {
        int i;
        this.processConfigInvariants();
        String specName = this.config.getSpec();
        if (specName.length() == 0) {
            this.processConfigInitAndNext();
        } else {
            Object spec;
            if (this.config.getInit().length() != 0 || this.config.getNext().length() != 0) {
                Assert.fail(2227);
            }
            if ((spec = this.defns.get(specName)) instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)spec;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{specName});
                }
                this.processConfigSpec(opDef.getBody(), Context.Empty, List.Empty);
            } else if (spec == null) {
                Assert.fail(2229, new String[]{"name", specName});
            } else {
                Assert.fail(2230, new String[]{"value", specName, spec.toString()});
            }
        }
        Vect propNames = this.config.getProperties();
        for (i = 0; i < propNames.size(); ++i) {
            String propName = (String)propNames.elementAt(i);
            Object prop = this.defns.get(propName);
            if (prop instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)prop;
                if (opDef.getArity() != 0) {
                    Assert.fail(2228, new String[]{propName});
                }
                this.processConfigProps(propName, opDef.getBody(), Context.Empty, List.Empty);
                continue;
            }
            if (prop == null) {
                Assert.fail(2229, new String[]{"property", propName});
                continue;
            }
            if (prop instanceof BoolValue && ((BoolValue)prop).val) continue;
            Assert.fail(2230, new String[]{"property", propName, prop.toString()});
        }
        this.invariants = new Action[this.invVec.size()];
        this.invNames = new String[this.invVec.size()];
        for (i = 0; i < this.invariants.length; ++i) {
            this.invariants[i] = (Action)this.invVec.elementAt(i);
            this.invNames[i] = (String)this.invNameVec.elementAt(i);
        }
        this.invVec = null;
        this.invNameVec = null;
        this.impliedInits = new Action[this.impliedInitVec.size()];
        this.impliedInitNames = new String[this.impliedInitVec.size()];
        for (i = 0; i < this.impliedInits.length; ++i) {
            this.impliedInits[i] = (Action)this.impliedInitVec.elementAt(i);
            this.impliedInitNames[i] = (String)this.impliedInitNameVec.elementAt(i);
        }
        this.impliedInitVec = null;
        this.impliedInitNameVec = null;
        this.impliedActions = new Action[this.impliedActionVec.size()];
        this.impliedActNames = new String[this.impliedActionVec.size()];
        for (i = 0; i < this.impliedActions.length; ++i) {
            this.impliedActions[i] = (Action)this.impliedActionVec.elementAt(i);
            this.impliedActNames[i] = (String)this.impliedActNameVec.elementAt(i);
        }
        this.impliedActionVec = null;
        this.impliedActNameVec = null;
        this.temporals = new Action[this.temporalVec.size()];
        this.temporalNames = new String[this.temporalNameVec.size()];
        for (i = 0; i < this.temporals.length; ++i) {
            this.temporals[i] = (Action)this.temporalVec.elementAt(i);
            this.temporalNames[i] = (String)this.temporalNameVec.elementAt(i);
        }
        this.temporalVec = null;
        this.temporalNameVec = null;
        this.impliedTemporals = new Action[this.impliedTemporalVec.size()];
        this.impliedTemporalNames = new String[this.impliedTemporalNameVec.size()];
        for (i = 0; i < this.impliedTemporals.length; ++i) {
            this.impliedTemporals[i] = (Action)this.impliedTemporalVec.elementAt(i);
            this.impliedTemporalNames[i] = (String)this.impliedTemporalNameVec.elementAt(i);
        }
        this.impliedTemporalVec = null;
        this.impliedTemporalNameVec = null;
        if (this.initPredVec.size() == 0 && (this.impliedInits.length != 0 || this.impliedActions.length != 0 || this.variablesNodes.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2231);
        }
        if (this.nextPred == null && (this.impliedActions.length != 0 || this.invariants.length != 0 || this.impliedTemporals.length != 0)) {
            Assert.fail(2232);
        }
    }

    private void processConfigInitAndNext() {
        OpDefNode def;
        String name = this.config.getInit();
        if (name.length() != 0) {
            Object init = this.defns.get(name);
            if (init == null) {
                Assert.fail(2229, new String[]{"initial predicate", name});
            }
            if (!(init instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"initial predicate", name});
            }
            if ((def = (OpDefNode)init).getArity() != 0) {
                Assert.fail(2228, new String[]{"initial predicate", name});
            }
            this.initPredVec.addElement(new Action(def.getBody(), Context.Empty));
        }
        if ((name = this.config.getNext()).length() != 0) {
            Object next = this.defns.get(name);
            if (next == null) {
                Assert.fail(2229, new String[]{"next state action", name});
            }
            if (!(next instanceof OpDefNode)) {
                Assert.fail(2233, new String[]{"next state action", name});
            }
            if ((def = (OpDefNode)next).getArity() != 0) {
                Assert.fail(2228, new String[]{"next state action", name});
            }
            this.nextPred = new Action(def.getBody(), Context.Empty);
        }
    }

    private void processConfigInvariants() {
        Vect invs = this.config.getInvariants();
        for (int i = 0; i < invs.size(); ++i) {
            String name = (String)invs.elementAt(i);
            Object inv = this.defns.get(name);
            if (inv instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)inv;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"invariant", name});
                }
                this.invNameVec.addElement(name);
                this.invVec.addElement(new Action(def.getBody(), Context.Empty));
                continue;
            }
            if (inv == null) {
                Assert.fail(2229, new String[]{"invariant", name});
                continue;
            }
            if (inv instanceof BoolValue && ((BoolValue)inv).val) continue;
            Assert.fail(2230, new String[]{"invariant", name, inv.toString()});
        }
    }

    private final void processConfigSpec(ExprNode pred, Context c, List subs) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigSpec(pred1.getBody(), c, subs.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val = this.lookup(opNode, c, false);
                if (val instanceof OpDefNode) {
                    ExprNode body;
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail(2234, new String[]{opNode.getName().toString()});
                    }
                    if (this.getLevelBound(body = ((OpDefNode)val).getBody(), c) == 1) {
                        this.initPredVec.addElement(new Action(Spec.addSubsts(body, subs), c));
                    } else {
                        this.processConfigSpec(body, c, subs);
                    }
                } else if (val == null) {
                    Assert.fail(2235, new String[]{opNode.getName().toString()});
                } else if (val instanceof BoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val.toString(), "spec"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    this.processConfigSpec((ExprNode)args[i], c, subs);
                }
                return;
            }
            if (opcode == 59) {
                ExprOrOpArgNode boxArg = args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    ExprNode arg = (ExprNode)((OpApplNode)boxArg).getArgs()[0];
                    ExprNode subscript = (ExprNode)((OpApplNode)boxArg).getArgs()[1];
                    Vect varsInSubscript = null;
                    try {
                        class SubscriptCollector {
                            Vect components = new Vect();

                            SubscriptCollector() {
                            }

                            void enter(ExprNode subscript, Context c) {
                                SymbolNode var = Spec.this.getVar(subscript, c, false);
                                if (var != null) {
                                    this.components.addElement(var);
                                    return;
                                }
                                switch (subscript.getKind()) {
                                    case 9: {
                                        OpApplNode subscript1 = (OpApplNode)subscript;
                                        SymbolNode opNode = subscript1.getOperator();
                                        ExprOrOpArgNode[] args = subscript1.getArgs();
                                        int opCode = BuiltInOPs.getOpCode(opNode.getName());
                                        if (opCode == 23) {
                                            for (int i = 0; i < args.length; ++i) {
                                                this.enter((ExprNode)args[i], c);
                                            }
                                            return;
                                        }
                                        if (opCode != 0) {
                                            return;
                                        }
                                        Object opDef = Spec.this.lookup(opNode, c, false);
                                        if (opDef instanceof OpDefNode) {
                                            OpDefNode opDef1 = (OpDefNode)opDef;
                                            this.enter(opDef1.getBody(), Spec.this.getOpContext(opDef1, args, c, false));
                                            return;
                                        }
                                        if (!(opDef instanceof LazyValue)) break;
                                        LazyValue lv = (LazyValue)opDef;
                                        this.enter((ExprNode)lv.expr, lv.con);
                                        return;
                                    }
                                    case 13: {
                                        SubstInNode subscript1 = (SubstInNode)subscript;
                                        Subst[] subs = subscript1.getSubsts();
                                        Context c1 = c;
                                        for (int i = 0; i < subs.length; ++i) {
                                            c1 = c1.cons(subs[i].getOp(), Spec.this.getVal(subs[i].getExpr(), c, false));
                                        }
                                        this.enter(subscript1.getBody(), c1);
                                        return;
                                    }
                                    case 10: {
                                        LetInNode subscript1 = (LetInNode)subscript;
                                        this.enter(subscript1.getBody(), c);
                                        return;
                                    }
                                    case 29: {
                                        LabelNode subscript1 = (LabelNode)subscript;
                                        this.enter((ExprNode)subscript1.getBody(), c);
                                        return;
                                    }
                                    default: {
                                        Assert.fail(2238, subscript.toString());
                                        return;
                                    }
                                }
                            }

                            Vect getComponents() {
                                return this.components;
                            }
                        }
                        SubscriptCollector collector = new SubscriptCollector();
                        Context c1 = c;
                        List subs1 = subs;
                        while (!subs1.isEmpty()) {
                            SubstInNode sn = (SubstInNode)subs1.car();
                            Subst[] snsubs = sn.getSubsts();
                            for (int i = 0; i < snsubs.length; ++i) {
                                c1 = c1.cons(snsubs[i].getOp(), this.getVal(snsubs[i].getExpr(), c, false));
                            }
                            subs1 = subs1.cdr();
                        }
                        collector.enter(subscript, c1);
                        varsInSubscript = collector.getComponents();
                    }
                    catch (Exception e) {
                        MP.printWarning(2139, new String[0]);
                        varsInSubscript = null;
                    }
                    if (varsInSubscript != null) {
                        for (int i = 0; i < this.variablesNodes.length; ++i) {
                            if (varsInSubscript.contains(this.variablesNodes[i])) continue;
                            MP.printWarning(2140, new String[]{this.variablesNodes[i].getName().toString()});
                        }
                    }
                    if (this.nextPred == null) {
                        this.nextPred = new Action(Spec.addSubsts(arg, subs), c);
                    } else {
                        Assert.fail(2240);
                    }
                } else {
                    this.temporalVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
                    this.temporalNameVec.addElement(pred.toString());
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigSpec((ExprNode)args[0], c, subs);
                return;
            }
        }
        if ((level = this.getLevelBound(pred, c)) <= 1) {
            this.initPredVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
        } else if (level == 3) {
            this.temporalVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
            this.temporalNameVec.addElement(pred.toString());
        } else {
            Assert.fail(2239, pred.toString());
        }
    }

    private final void processConfigProps(String name, ExprNode pred, Context c, List subs) {
        int level;
        if (pred instanceof SubstInNode) {
            SubstInNode pred1 = (SubstInNode)pred;
            this.processConfigProps(name, pred1.getBody(), c, subs.cons(pred1));
            return;
        }
        if (pred instanceof OpApplNode) {
            OpApplNode pred1 = (OpApplNode)pred;
            ExprOrOpArgNode[] args = pred1.getArgs();
            if (args.length == 0) {
                SymbolNode opNode = pred1.getOperator();
                Object val = this.lookup(opNode, c, false);
                if (val instanceof OpDefNode) {
                    if (((OpDefNode)val).getArity() != 0) {
                        Assert.fail(2234, opNode.getName().toString());
                    }
                    this.processConfigProps(opNode.getName().toString(), ((OpDefNode)val).getBody(), c, subs);
                } else if (val == null) {
                    Assert.fail(2235, opNode.getName().toString());
                } else if (val instanceof BoolValue) {
                    if (!((BoolValue)val).val) {
                        Assert.fail(2237, opNode.getName().toString());
                    }
                } else {
                    Assert.fail(2236, new String[]{opNode.getName().toString(), val.toString(), "property"});
                }
                return;
            }
            int opcode = BuiltInOPs.getOpCode(pred1.getOperator().getName());
            if (opcode == 6 || opcode == 36) {
                for (int i = 0; i < args.length; ++i) {
                    ExprNode conj = (ExprNode)args[i];
                    this.processConfigProps(conj.toString(), conj, c, subs);
                }
                return;
            }
            if (opcode == 59) {
                ExprNode boxArg = (ExprNode)args[0];
                if (boxArg instanceof OpApplNode && BuiltInOPs.getOpCode(((OpApplNode)boxArg).getOperator().getName()) == 51) {
                    OpApplNode boxArg1 = (OpApplNode)boxArg;
                    if (boxArg1.getArgs().length == 0) {
                        name = boxArg1.getOperator().getName().toString();
                    }
                    this.impliedActNameVec.addElement(name);
                    this.impliedActionVec.addElement(new Action(Spec.addSubsts(boxArg, subs), c));
                } else if (this.getLevelBound(boxArg, c) < 2) {
                    this.invVec.addElement(new Action(Spec.addSubsts(boxArg, subs), c));
                    if (boxArg instanceof OpApplNode && ((OpApplNode)boxArg).getArgs().length == 0) {
                        name = ((OpApplNode)boxArg).getOperator().getName().toString();
                    }
                    this.invNameVec.addElement(name);
                } else {
                    this.impliedTemporalVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
                    this.impliedTemporalNameVec.addElement(name);
                }
                return;
            }
            if (opcode == 46) {
                this.processConfigProps(name, (ExprNode)args[0], c, subs);
                return;
            }
        }
        if ((level = this.getLevelBound(pred, c)) <= 1) {
            this.impliedInitVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
            this.impliedInitNameVec.addElement(name);
        } else if (level == 3) {
            this.impliedTemporalVec.addElement(new Action(Spec.addSubsts(pred, subs), c));
            this.impliedTemporalNameVec.addElement(name);
        } else {
            Assert.fail(2241, name);
        }
    }

    private final Hashtable makeConstantTable(Vect consts) {
        Hashtable<String, Object> constTbl = new Hashtable<String, Object>();
        for (int i = 0; i < consts.size(); ++i) {
            OpRcdValue opVal;
            Vect line = (Vect)consts.elementAt(i);
            int len = line.size();
            String name = (String)line.elementAt(0);
            if (len <= 2) {
                constTbl.put(name, line.elementAt(1));
                continue;
            }
            Object val = constTbl.get(name);
            if (val == null) {
                opVal = new OpRcdValue();
                opVal.addLine(line);
                constTbl.put(name, opVal);
                continue;
            }
            opVal = (OpRcdValue)val;
            int arity = ((Value[])opVal.domain.elementAt(0)).length;
            if (len != arity + 2) {
                Assert.fail(2242, name);
            }
            opVal.addLine(line);
        }
        return constTbl;
    }

    public final Hashtable initializeConstants() {
        Vect consts = this.config.getConstants();
        if (consts == null) {
            return new Hashtable();
        }
        return this.makeConstantTable(consts);
    }

    public final Hashtable initializeModConstants() {
        Hashtable modConstants = this.config.getModConstants();
        Hashtable<String, Hashtable> constants = new Hashtable<String, Hashtable>();
        Enumeration mods = modConstants.keys();
        while (mods.hasMoreElements()) {
            String modName = (String)mods.nextElement();
            constants.put(modName, this.makeConstantTable((Vect)modConstants.get(modName)));
        }
        return constants;
    }

    public final ExprNode[] getModelConstraints() {
        if (this.modelConstraints != null) {
            return this.modelConstraints;
        }
        Vect names = this.config.getConstraints();
        this.modelConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"constraint", name});
                }
                this.modelConstraints[idx++] = def.getBody();
                continue;
            }
            if (constr != null) {
                if (constr instanceof BoolValue && ((BoolValue)constr).val) continue;
                Assert.fail(2230, new String[]{"constraint", name, constr.toString()});
                continue;
            }
            Assert.fail(2229, new String[]{"constraint", name});
        }
        if (idx < this.modelConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.modelConstraints[i];
            }
            this.modelConstraints = constrs;
        }
        return this.modelConstraints;
    }

    public final ExprNode[] getActionConstraints() {
        if (this.actionConstraints != null) {
            return this.actionConstraints;
        }
        Vect names = this.config.getActionConstraints();
        this.actionConstraints = new ExprNode[names.size()];
        int idx = 0;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            Object constr = this.defns.get(name);
            if (constr instanceof OpDefNode) {
                OpDefNode def = (OpDefNode)constr;
                if (def.getArity() != 0) {
                    Assert.fail(2228, new String[]{"action constraint", name});
                }
                this.actionConstraints[idx++] = def.getBody();
                continue;
            }
            if (constr != null) {
                if (constr instanceof BoolValue && ((BoolValue)constr).val) continue;
                Assert.fail(2230, new String[]{"action constraint", name, constr.toString()});
                continue;
            }
            Assert.fail(2229, new String[]{"action constraint", name});
        }
        if (idx < this.actionConstraints.length) {
            ExprNode[] constrs = new ExprNode[idx];
            for (int i = 0; i < idx; ++i) {
                constrs[i] = this.actionConstraints[i];
            }
            this.actionConstraints = constrs;
        }
        return this.actionConstraints;
    }

    public final Vect getInitStateSpec() {
        return this.initPredVec;
    }

    public final Action getNextStateSpec() {
        return this.nextPred;
    }

    public final SemanticNode getViewSpec() {
        OpDefNode def;
        String name = this.config.getView();
        if (name.length() == 0) {
            return null;
        }
        Object view = this.defns.get(name);
        if (view == null) {
            Assert.fail(2229, new String[]{"view function", name});
        }
        if (!(view instanceof OpDefNode)) {
            Assert.fail(2233, new String[]{"view function", name});
        }
        if ((def = (OpDefNode)view).getArity() != 0) {
            Assert.fail(2228, new String[]{"view function", name});
        }
        return def.getBody();
    }

    public final SemanticNode getTypeSpec() {
        OpDefNode def;
        Object type;
        String name = this.config.getType();
        if (name.length() == 0) {
            Assert.fail(2243);
        }
        if ((type = this.defns.get(name)) == null) {
            Assert.fail(2229, new String[]{"type", name});
        }
        if (!(type instanceof OpDefNode)) {
            Assert.fail(2233, new String[]{"type", name});
        }
        if ((def = (OpDefNode)type).getArity() != 0) {
            Assert.fail(2228, new String[]{"type", name});
        }
        return def.getBody();
    }

    public final SemanticNode getTypeConstraintSpec() {
        OpDefNode def;
        String name = this.config.getTypeConstraint();
        if (name.length() == 0) {
            return null;
        }
        Object type = this.defns.get(name);
        if (type == null) {
            Assert.fail(2229, new String[]{"type constraint", name});
        }
        if (!(type instanceof OpDefNode)) {
            Assert.fail(2233, new String[]{"type constraint", name});
        }
        if ((def = (OpDefNode)type).getArity() != 0) {
            Assert.fail(2228, new String[]{"type cinstraint", name});
        }
        return def.getBody();
    }

    public final boolean livenessIsTrue() {
        return this.impliedTemporals.length == 0;
    }

    public final Action[] getTemporals() {
        return this.temporals;
    }

    public final String[] getTemporalNames() {
        return this.temporalNames;
    }

    public final Action[] getImpliedTemporals() {
        return this.impliedTemporals;
    }

    public final String[] getImpliedTemporalNames() {
        return this.impliedTemporalNames;
    }

    public final Action[] getInvariants() {
        return this.invariants;
    }

    public final String[] getInvNames() {
        return this.invNames;
    }

    public final Action[] getImpliedInits() {
        return this.impliedInits;
    }

    public final String[] getImpliedInitNames() {
        return this.impliedInitNames;
    }

    public final Action[] getImpliedActions() {
        return this.impliedActions;
    }

    public final String[] getImpliedActNames() {
        return this.impliedActNames;
    }

    public final ExprNode[] getAssumptions() {
        return this.assumptions;
    }

    public final boolean[] getAssumptionIsAxiom() {
        return this.assumptionIsAxiom;
    }

    public final Object lookup(SymbolNode opNode, Context c, TLCState s, boolean cutoff) {
        boolean isVarDecl = opNode.getKind() == 3;
        Object result = c.lookup(opNode, cutoff && isVarDecl);
        if (result != null) {
            return result;
        }
        result = opNode.getToolObject(TLCGlobals.ToolId);
        if (result != null) {
            return result;
        }
        if (opNode.getKind() == 5) {
            ExprNode body = ((OpDefNode)opNode).getBody();
            result = body.getToolObject(TLCGlobals.ToolId);
            while (result == null && body.getKind() == 13) {
                body = ((SubstInNode)body).getBody();
                result = body.getToolObject(TLCGlobals.ToolId);
            }
            if (result != null) {
                return result;
            }
        }
        if ((result = s.lookup(opNode.getName())) != null) {
            return result;
        }
        return opNode;
    }

    public final Object lookup(SymbolNode opNode, Context c, boolean cutoff) {
        boolean isVarDecl = opNode.getKind() == 3;
        Object result = c.lookup(opNode, cutoff && isVarDecl);
        if (result != null) {
            return result;
        }
        result = opNode.getToolObject(TLCGlobals.ToolId);
        if (result != null) {
            return result;
        }
        if (opNode.getKind() == 5) {
            ExprNode body = ((OpDefNode)opNode).getBody();
            result = body.getToolObject(TLCGlobals.ToolId);
            while (result == null && body.getKind() == 13) {
                body = ((SubstInNode)body).getBody();
                result = body.getToolObject(TLCGlobals.ToolId);
            }
            if (result != null) {
                return result;
            }
        }
        return opNode;
    }

    public final Object getVal(ExprOrOpArgNode expr, Context c, boolean cachable) {
        if (expr instanceof ExprNode) {
            LazyValue lval = new LazyValue(expr, c);
            if (!cachable) {
                lval.setUncachable();
            }
            return lval;
        }
        SymbolNode opNode = ((OpArgNode)expr).getOp();
        return this.lookup(opNode, c, false);
    }

    public final Context getOpContext(OpDefNode opDef, ExprOrOpArgNode[] args, Context c, boolean cachable) {
        FormalParamNode[] formals = opDef.getParams();
        int alen = args.length;
        Context c1 = c;
        for (int i = 0; i < alen; ++i) {
            Object aval = this.getVal(args[i], c, cachable);
            c1 = c1.cons(formals[i], aval);
        }
        return c1;
    }

    public final Context getOpContext(ThmOrAssumpDefNode opDef, ExprOrOpArgNode[] args, Context c, boolean cachable) {
        FormalParamNode[] formals = opDef.getParams();
        int alen = args.length;
        Context c1 = c;
        for (int i = 0; i < alen; ++i) {
            Object aval = this.getVal(args[i], c, cachable);
            c1 = c1.cons(formals[i], aval);
        }
        return c1;
    }

    public final ObjLongTable getPrimedLocs() {
        ObjLongTable tbl = new ObjLongTable(10);
        Action act = this.getNextStateSpec();
        this.collectPrimedLocs(act.pred, act.con, tbl);
        return tbl;
    }

    public final void collectPrimedLocs(SemanticNode pred, Context c, ObjLongTable tbl) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                this.collectPrimedLocsAppl(pred1, c, tbl);
                return;
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                Context c1 = c;
                for (int i = 0; i < subs.length; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                this.collectPrimedLocs(pred1.getBody(), c, tbl);
                return;
            }
        }
    }

    private final void collectPrimedLocsAppl(OpApplNode pred, Context c, ObjLongTable tbl) {
        ExprOrOpArgNode[] args = pred.getArgs();
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        switch (opcode) {
            case 9: {
                this.collectPrimedLocs(args[0], c, tbl);
                break;
            }
            case 11: {
                this.collectPrimedLocs(args[1], c, tbl);
                this.collectPrimedLocs(args[2], c, tbl);
                break;
            }
            case 4: {
                for (int i = 0; i < args.length; ++i) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    this.collectPrimedLocs(pair2.getArgs()[1], c, tbl);
                }
                break;
            }
            case 35: 
            case 42: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null || var.getName().getVarLoc() == -1) break;
                tbl.put(pred.toString(), 0L);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 46: {
                for (int i = 0; i < args.length; ++i) {
                    this.collectPrimedLocs(args[i], c, tbl);
                }
                break;
            }
            case 49: {
                this.collectUnchangedLocs(args[0], c, tbl);
                break;
            }
            case 50: {
                this.collectPrimedLocs(args[0], c, tbl);
                break;
            }
            case 51: {
                this.collectPrimedLocs(args[0], c, tbl);
                tbl.put(args[1].toString(), 0L);
                break;
            }
            default: {
                if (opcode != 0) break;
                Object val = this.lookup(opNode, c, false);
                if (val instanceof OpDefNode) {
                    OpDefNode opDef = (OpDefNode)val;
                    if (opDef.getInRecursive()) {
                        return;
                    }
                    Context c1 = this.getOpContext(opDef, args, c, true);
                    this.collectPrimedLocs(opDef.getBody(), c1, tbl);
                    break;
                }
                if (!(val instanceof LazyValue)) break;
                LazyValue lv = (LazyValue)val;
                this.collectPrimedLocs(lv.expr, lv.con, tbl);
            }
        }
    }

    private final void collectUnchangedLocs(SemanticNode expr, Context c, ObjLongTable tbl) {
        if (expr instanceof OpApplNode) {
            Object val;
            OpApplNode expr1 = (OpApplNode)expr;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opName.getVarLoc() >= 0) {
                tbl.put(expr.toString(), 0L);
                return;
            }
            ExprOrOpArgNode[] args = expr1.getArgs();
            if (opcode == 23) {
                for (int i = 0; i < args.length; ++i) {
                    this.collectUnchangedLocs(args[i], c, tbl);
                }
                return;
            }
            if (opcode == 0 && args.length == 0 && (val = this.lookup(opNode, c, false)) instanceof OpDefNode) {
                this.collectUnchangedLocs(((OpDefNode)val).getBody(), c, tbl);
                return;
            }
        }
    }

    public final int getLevelBound(SemanticNode expr, Context c) {
        switch (expr.getKind()) {
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                return this.getLevelBoundAppl(expr1, c);
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                OpDefNode[] letDefs = expr1.getLets();
                int letLen = letDefs.length;
                Context c1 = c;
                int level = 0;
                for (int i = 0; i < letLen; ++i) {
                    OpDefNode opDef = letDefs[i];
                    level = Math.max(level, this.getLevelBound(opDef.getBody(), c1));
                    c1 = c1.cons(opDef, ValOne);
                }
                return Math.max(level, this.getLevelBound(expr1.getBody(), c1));
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                return this.getLevelBound(expr1.getBody(), c1);
            }
            case 30: {
                APSubstInNode expr1 = (APSubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context c1 = c;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true));
                }
                return this.getLevelBound(expr1.getBody(), c1);
            }
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                return this.getLevelBound(expr1.getBody(), c);
            }
        }
        return 0;
    }

    private final int getLevelBoundAppl(OpApplNode expr, Context c) {
        SymbolNode opNode = expr.getOperator();
        UniqueString opName = opNode.getName();
        int opcode = BuiltInOPs.getOpCode(opName);
        if (BuiltInOPs.isTemporal(opcode)) {
            return 3;
        }
        if (BuiltInOPs.isAction(opcode)) {
            return 2;
        }
        if (opcode == 34) {
            return 1;
        }
        int level = 0;
        ExprNode[] bnds = expr.getBdedQuantBounds();
        for (int i = 0; i < bnds.length; ++i) {
            level = Math.max(level, this.getLevelBound(bnds[i], c));
        }
        if (opcode == 16) {
            FormalParamNode fname = expr.getUnbdedQuantSymbols()[0];
            c = c.cons(fname, ValOne);
        }
        ExprOrOpArgNode[] args = expr.getArgs();
        int alen = args.length;
        for (int i = 0; i < alen; ++i) {
            if (args[i] == null) continue;
            level = Math.max(level, this.getLevelBound(args[i], c));
        }
        if (opcode == 0) {
            if (opName.getVarLoc() >= 0) {
                return 1;
            }
            Object val = this.lookup(opNode, c, false);
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                c = c.cons(opNode, ValOne);
                level = Math.max(level, this.getLevelBound(opDef.getBody(), c));
            } else if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                level = Math.max(level, this.getLevelBound(lv.expr, lv.con));
            }
        }
        return level;
    }

    public FilenameToStream getResolver() {
        return this.resolver;
    }

    public static int getLevel(LevelNode expr, Context c) {
        HashSet lpSet = expr.getLevelParams();
        if (lpSet.isEmpty()) {
            return expr.getLevel();
        }
        int level = expr.getLevel();
        for (SymbolNode param : lpSet) {
            Object res = c.lookup(param, true);
            if (res == null) continue;
            if (res instanceof LazyValue) {
                LazyValue lv = (LazyValue)res;
                int plevel = Spec.getLevel((LevelNode)lv.expr, lv.con);
                level = plevel > level ? plevel : level;
                continue;
            }
            if (!(res instanceof OpDefNode)) continue;
            int plevel = Spec.getLevel((LevelNode)res, c);
            level = plevel > level ? plevel : level;
        }
        return level;
    }

    private static final ExprNode addSubsts(ExprNode expr, List subs) {
        ExprNode res = expr;
        while (!subs.isEmpty()) {
            SubstInNode sn = (SubstInNode)subs.car();
            res = new SubstInNode(sn.stn, sn.getSubsts(), res, sn.getInstantiatingModule(), sn.getInstantiatedModule());
            subs = subs.cdr();
        }
        return res;
    }
}

