/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.SymbolNode;

public class SymbolContext {
    private Map<Integer, Element> context;
    private Set<Integer> keys;
    public static final int OTHER_BUG = 0;
    private boolean[] flagArray;

    public SymbolContext() {
        this.context = new HashMap<Integer, Element>();
        this.keys = new HashSet<Integer>();
        this.flagArray = new boolean[1];
    }

    public SymbolContext(SymbolContext other) {
        this.context = other.context;
        this.keys = other.keys;
        this.flagArray = other.flagArray;
    }

    public void setFlag(int flag) {
        this.flagArray[flag] = true;
    }

    public boolean hasFlag(int flag) {
        return this.flagArray[flag];
    }

    public void put(SymbolNode nd, Document doc) {
        Integer k = new Integer(nd.myUID);
        if (!this.keys.contains(k)) {
            this.keys.add(k);
            this.context.put(k, nd.exportDefinition(doc, this));
        }
    }

    public Element getContextElement(Document doc) {
        Element ret = doc.createElement("context");
        for (Map.Entry<Integer, Element> entry : this.context.entrySet()) {
            Element e = doc.createElement("entry");
            Element id = doc.createElement("UID");
            id.appendChild(doc.createTextNode(entry.getKey().toString()));
            e.appendChild(id);
            e.appendChild(entry.getValue());
            ret.appendChild(e);
        }
        return ret;
    }
}

