/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import util.WrongInvocationException;

public class LevelNode
extends SemanticNode {
    public boolean levelCorrect = true;
    public int level = 0;
    public HashSet levelParams = new HashSet();
    public SetOfLevelConstraints levelConstraints = new SetOfLevelConstraints();
    public SetOfArgLevelConstraints argLevelConstraints = new SetOfArgLevelConstraints();
    public HashSet argLevelParams = new HashSet();
    public HashSet allParams = new HashSet();
    public HashSet nonLeibnizParams = new HashSet();
    public int levelChecked = 0;

    LevelNode(int kind, TreeNode stn) {
        super(kind, stn);
    }

    public boolean levelCheck(int iter) {
        throw new WrongInvocationException("Level checking of " + kinds[this.getKind()] + " node not implemented.");
    }

    public boolean levelCheckSubnodes(int iter, LevelNode[] sub) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        this.levelChecked = iter;
        for (int i = 0; i < sub.length; ++i) {
            if (sub[i].getKind() == 1 || sub[i].getKind() == 6) continue;
            boolean bl = this.levelCorrect = sub[i].levelCheck(iter) && this.levelCorrect;
            if (this.level < sub[i].getLevel()) {
                this.level = sub[i].getLevel();
            }
            this.levelParams.addAll(sub[i].getLevelParams());
            this.levelConstraints.putAll((Map)sub[i].getLevelConstraints());
            this.argLevelConstraints.putAll((Map)sub[i].getArgLevelConstraints());
            this.argLevelParams.addAll(sub[i].getArgLevelParams());
            this.allParams.addAll(sub[i].getAllParams());
            this.nonLeibnizParams.addAll(sub[i].getNonLeibnizParams());
        }
        return this.levelCorrect;
    }

    static void addTemporalLevelConstraintToConstants(HashSet params, SetOfLevelConstraints constrs) {
        for (LevelNode node : params) {
            if (node.getKind() != 2) continue;
            constrs.put(node, Levels[2]);
        }
    }

    public int getLevel() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevel called before levelCheck");
        }
        return this.level;
    }

    public HashSet getLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelParams called before levelCheck");
        }
        return this.levelParams;
    }

    public HashSet getAllParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getAllParams called before levelCheck");
        }
        return this.allParams;
    }

    public HashSet getNonLeibnizParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getAllParams called before levelCheck");
        }
        return this.nonLeibnizParams;
    }

    public SetOfLevelConstraints getLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelConstraints called before levelCheck");
        }
        return this.levelConstraints;
    }

    public SetOfArgLevelConstraints getArgLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelConstraints called before levelCheck");
        }
        return this.argLevelConstraints;
    }

    public HashSet getArgLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelParams called before levelCheck");
        }
        return this.argLevelParams;
    }

    public String defaultLevelDataToString() {
        return "Level:" + this.getLevel() + "\n" + "LevelParams: " + this.getLevelParams() + "\n" + "LevelConstraints: " + this.getLevelConstraints() + "\n" + "ArgLevelConstraints: " + this.getArgLevelConstraints() + "\n" + "ArgLevelParams: " + LevelNode.ALPHashSetToString(this.getArgLevelParams()) + "\n" + "AllParams: " + LevelNode.HashSetToString(this.getAllParams()) + "\n" + "NonLeibnizParams: " + LevelNode.HashSetToString(this.getNonLeibnizParams());
    }

    public static String HashSetToString(HashSet hs) {
        String rval = "{";
        boolean first = true;
        Iterator iter = hs.iterator();
        while (iter.hasNext()) {
            if (!first) {
                rval = rval + ", ";
            }
            rval = rval + ((SymbolNode)iter.next()).getName();
            first = false;
        }
        rval = rval + "}";
        return rval;
    }

    public static String ALPHashSetToString(HashSet hs) {
        String rval = "{";
        boolean first = true;
        Iterator iter = hs.iterator();
        while (iter.hasNext()) {
            if (!first) {
                rval = rval + ", ";
            }
            ArgLevelParam alp = (ArgLevelParam)iter.next();
            rval = rval + "<" + alp.op.getName() + ", " + alp.i + ", " + alp.param.getName() + ">";
            first = false;
        }
        rval = rval + "}";
        return rval;
    }

    @Override
    public String levelDataToString() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("levelDataToString called before levelCheck");
        }
        return this.defaultLevelDataToString();
    }

    @Override
    protected Element getSemanticElement(Document doc, SymbolContext context) {
        Element e = this.getLevelElement(doc, context);
        try {
            Element l = this.appendText(doc, "level", Integer.toString(this.getLevel()));
            e.insertBefore(l, e.getFirstChild());
        }
        catch (RuntimeException ee) {
            // empty catch block
        }
        return e;
    }

    protected Element getLevelElement(Document doc, SymbolContext context) {
        throw new UnsupportedOperationException("xml export is not yet supported for: " + this.getClass() + " with toString: " + this.toString(100));
    }
}

