/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.Location;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class Context
implements ExploreNode {
    private static Context initialContext = new Context(null, new Errors());
    private ExternalModuleTable exMT;
    private Errors errors;
    private Hashtable table = new Hashtable();
    private Pair lastPair;

    public Context(ExternalModuleTable mt, Errors errs) {
        this.exMT = mt;
        this.errors = errs;
        this.lastPair = null;
    }

    public static void reInit() {
        initialContext = new Context(null, new Errors());
    }

    public static Context getGlobalContext() {
        return initialContext;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public static void addGlobalSymbol(UniqueString name, SymbolNode sn, Errors errors) throws AbortException {
        if (initialContext.getSymbol(name) == null) {
            initialContext.addSymbolToContext(name, sn);
            return;
        }
        errors.addAbort(Location.nullLoc, "Error building initial context: Multiply-defined builtin operator " + name + " at " + sn, false);
    }

    public SymbolNode getSymbol(Object name) {
        Pair r = (Pair)this.table.get(name);
        if (r != null) {
            return r.info;
        }
        return null;
    }

    public void addSymbolToContext(Object name, SymbolNode s) {
        this.table.put(name, new Pair(s));
    }

    public boolean occurSymbol(Object name) {
        return this.table.containsKey(name);
    }

    public Enumeration content() {
        return this.table.elements();
    }

    public ContextSymbolEnumeration getContextSymbolEnumeration() {
        return new ContextSymbolEnumeration();
    }

    public Vector getByClass(Class template) {
        Vector result = new Vector();
        Enumeration list = this.table.elements();
        while (list.hasMoreElements()) {
            Pair elt = (Pair)list.nextElement();
            if (!template.isInstance(elt.info)) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector getOpDefs() {
        Pair nextPair = this.lastPair;
        Vector result = new Vector();
        while (nextPair != null) {
            if (nextPair.info instanceof OpDefNode && ((OpDefNode)nextPair.info).getKind() != 6 && ((OpDefNode)nextPair.info).getKind() != 7) {
                result.addElement((OpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector getThmOrAssDefs() {
        Pair nextPair = this.lastPair;
        Vector result = new Vector();
        while (nextPair != null) {
            if (nextPair.info instanceof ThmOrAssumpDefNode) {
                result.addElement((ThmOrAssumpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector getConstantDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration list = this.table.elements();
        Vector result = new Vector();
        while (list.hasMoreElements()) {
            Pair elt = (Pair)list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 2) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector getVariableDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration list = this.table.elements();
        Vector result = new Vector();
        while (list.hasMoreElements()) {
            Pair elt = (Pair)list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 3) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector getModDefs() {
        Class<ModuleNode> template = ModuleNode.class;
        Enumeration list = this.table.elements();
        Vector result = new Vector();
        while (list.hasMoreElements()) {
            Pair elt = (Pair)list.nextElement();
            if (!template.isInstance(elt.info)) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public boolean mergeExtendContext(Context ct) {
        boolean erc = true;
        Pair p = ct.lastPair.reversePairList();
        while (p != null) {
            SymbolNode sn = p.info;
            if (!sn.isLocal()) {
                Object sName = sn instanceof ModuleNode ? new SymbolTable.ModuleName(sn.getName()) : sn.getName();
                if (!this.table.containsKey(sName)) {
                    this.table.put(sName, new Pair(sn));
                } else {
                    SymbolNode symbol = ((Pair)this.table.get((Object)sName)).info;
                    if (symbol != sn) {
                        if (symbol.getClass() == sn.getClass()) {
                            if (!symbol.sameOriginallyDefinedInModule(sn)) {
                                this.errors.addWarning(sn.getTreeNode().getLocation(), "Warning: the " + Context.kindOfNode(symbol) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol) + " at " + symbol.getTreeNode().getLocation() + ".");
                            }
                        } else {
                            this.errors.addError(sn.getTreeNode().getLocation(), "The " + Context.kindOfNode(symbol) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol) + " at " + symbol.getTreeNode().getLocation() + ".");
                            erc = false;
                        }
                    }
                }
            }
            p = p.link;
        }
        return erc;
    }

    private static String kindOfNode(SymbolNode symbol) {
        if (symbol instanceof OpDefNode) {
            return "definition";
        }
        if (symbol instanceof FormalParamNode) {
            return "definition";
        }
        return "declaration";
    }

    public Context duplicate(ExternalModuleTable exMT) {
        Context dup = new Context(exMT, this.errors);
        Pair p = this.lastPair;
        Pair current = null;
        boolean firstTime = true;
        while (p != null) {
            if (firstTime) {
                dup.lastPair = current = new Pair(null, p.info);
                firstTime = false;
            } else {
                current = current.link = new Pair(null, p.info);
            }
            dup.table.put(current.info.getName(), current);
            p = p.link;
        }
        return dup;
    }

    @Override
    public String levelDataToString() {
        return "Dummy level string";
    }

    @Override
    public String toString(int depth) {
        return "Please use Context.getContextEntryStringVector() instead of Context.toString()";
    }

    public Vector getContextEntryStringVector(int depth, boolean b) {
        Vector ctxtEntries = new Vector(100);
        Context naturalsContext = this.exMT.getContext(UniqueString.uniqueStringOf("Naturals"));
        if (depth <= 0) {
            return ctxtEntries;
        }
        Pair p = this.lastPair;
        while (p != null) {
            UniqueString key = p.info.getName();
            if (b || !Context.initialContext.table.containsKey(key) && (naturalsContext == null || !naturalsContext.table.containsKey(key))) {
                SymbolNode symbNode = ((Pair)this.table.get((Object)key)).info;
                ctxtEntries.addElement("\nContext Entry: " + key.toString() + "  " + String.valueOf(symbNode.myUID).toString() + " " + Strings.indentSB(2, symbNode.toString(depth - 1)));
            }
            p = p.link;
        }
        int n = ctxtEntries.size();
        for (int i = 0; i < n / 2; ++i) {
            Object obj = ctxtEntries.elementAt(i);
            ctxtEntries.setElementAt(ctxtEntries.elementAt(n - 1 - i), i);
            ctxtEntries.setElementAt(obj, n - 1 - i);
        }
        return ctxtEntries;
    }

    @Override
    public void walkGraph(Hashtable semNodesTable) {
        Enumeration Enum2 = this.table.keys();
        while (Enum2.hasMoreElements()) {
            UniqueString key;
            Object next = Enum2.nextElement();
            if (next instanceof SymbolTable.ModuleName) {
                key = ((SymbolTable.ModuleName)next).name;
                System.out.println("Bug in debugging caused by inner module " + key.toString());
                System.out.println("SANY will throw a null pointer exception.");
                continue;
            }
            key = (UniqueString)next;
            ((Pair)this.table.get((Object)key)).info.walkGraph(semNodesTable);
        }
    }

    static /* synthetic */ Context access$100() {
        return initialContext;
    }

    public class ContextSymbolEnumeration {
        Enumeration e;

        public ContextSymbolEnumeration() {
            this.e = Context.this.content();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return ((Pair)this.e.nextElement()).getSymbol();
        }
    }

    public class InitialSymbolEnumeration {
        Enumeration e = Context.access$100().content();

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return ((Pair)this.e.nextElement()).getSymbol();
        }
    }

    class Pair {
        Pair link;
        SymbolNode info;

        Pair(Pair lnk, SymbolNode inf) {
            this.link = lnk;
            this.info = inf;
        }

        Pair(SymbolNode inf) {
            this.link = Context.this.lastPair;
            this.info = inf;
            Context.this.lastPair = this;
        }

        public SymbolNode getSymbol() {
            return this.info;
        }

        public Pair reversePairList() {
            Pair curResult = new Pair(null, this.info);
            Pair nextOriginal = this.link;
            while (nextOriginal != null) {
                curResult = new Pair(curResult, nextOriginal.info);
                nextOriginal = nextOriginal.link;
            }
            return curResult;
        }
    }
}

