/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import tla2sany.parser.Operators;
import tla2sany.st.SyntaxTreeConstants;
import util.UniqueString;

public class Operator
implements SyntaxTreeConstants {
    private UniqueString Id;
    private int Low;
    private int High;
    public int Associativity;
    public int Fix;
    private static Operator voidOperator = null;

    public static synchronized Operator VoidOperator() {
        if (voidOperator == null) {
            voidOperator = new Operator(UniqueString.uniqueStringOf("$$_void"), 0, 0, Operators.assocNone, Operators.infix);
        }
        return voidOperator;
    }

    public Operator(UniqueString id, int l, int h, int a, int f) {
        this.Id = id;
        this.Low = l;
        this.High = h;
        this.Associativity = a;
        this.Fix = f;
    }

    public Operator clone(UniqueString name) {
        return new Operator(name, this.Low, this.High, this.Associativity, this.Fix);
    }

    public String toString() {
        switch (this.Fix) {
            case 0: {
                return this.Id.toString() + ", nofix";
            }
            case 1: {
                return this.Id.toString() + ", prefix";
            }
            case 2: {
                return this.Id.toString() + ", postfix";
            }
            case 3: {
                return this.Id.toString() + ", infix";
            }
            case 4: {
                return this.Id.toString() + ", nfix";
            }
        }
        return null;
    }

    public final boolean isPrefix() {
        return this.Fix == Operators.prefix;
    }

    public final boolean isInfix() {
        return this.Fix == Operators.infix || this.Fix == Operators.nfix;
    }

    public final boolean isPostfix() {
        return this.Fix == Operators.postfix;
    }

    public final boolean isNfix() {
        return this.Fix == Operators.nfix;
    }

    public final boolean isPrefixDecl() {
        return this.Fix == Operators.prefix && this.Id.toString().endsWith(".");
    }

    public final boolean assocLeft() {
        return this.Associativity == Operators.assocLeft;
    }

    public final boolean assocRight() {
        return this.Associativity == Operators.assocRight;
    }

    static final boolean succ(Operator left, Operator right) {
        return left.Low > right.High;
    }

    static final boolean prec(Operator left, Operator right) {
        return left.High < right.Low;
    }

    static final boolean samePrec(Operator left, Operator right) {
        return left.High == right.High && left.Low == right.Low;
    }

    public final UniqueString getIdentifier() {
        return this.Id;
    }
}

