/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import de.prob.web.WebUtils;
import de.prob.web.worksheet.AbstractBox;
import de.prob.web.worksheet.BindingsSnapshot;
import de.prob.web.worksheet.EChangeEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pegdown.PegDownProcessor;

public class Markdown
extends AbstractBox {
    private final PegDownProcessor pegdown = new PegDownProcessor();
    private String content = "";

    @Override
    public List<Object> render(BindingsSnapshot snapshot) {
        ArrayList<Object> res = new ArrayList<Object>();
        String rendered = this.pegdown.markdownToHtml(this.content);
        if (rendered.isEmpty()) {
            rendered = "&nbsp;";
        }
        res.add(this.makeHtml(this.id, rendered));
        res.add(WebUtils.wrap("cmd", "Worksheet.renderMath", "box", this.id));
        return res;
    }

    @Override
    public void setContent(Map<String, String[]> data) {
        this.content = data.get("text")[0];
    }

    @Override
    protected String getContentAsJson() {
        return this.content;
    }

    @Override
    public EChangeEffect changeEffect() {
        return EChangeEffect.DONT_CARE;
    }

    @Override
    public boolean requiresReEvaluation() {
        return false;
    }
}

