/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.be4.ltl.core.parser.LtlParseException;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.domainobjects.LTL;
import de.prob.annotations.OneToOne;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.State;
import de.prob.statespace.Trace;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import de.prob.web.views.CurrentTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OneToOne
public class LtlFormula
extends AbstractAnimationBasedView {
    private final Logger logger = LoggerFactory.getLogger(CurrentTrace.class);
    private final List<LTLFormulaTuple> formulas = new ArrayList<LTLFormulaTuple>();
    private final Map<LTL, Map<State, String>> cache = new HashMap<LTL, Map<State, String>>();

    @Inject
    public LtlFormula(AnimationSelector animations) throws LtlParseException {
        super(animations);
        this.incrementalUpdate = false;
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        this.addFormulas();
    }

    private void addFormulas() throws LtlParseException {
        LTL ltl1 = new LTL("GF[new]");
        LTL ltl2 = new LTL("F[new]");
        LTL ltl3 = new LTL("true");
        this.formulas.add(new LTLFormulaTuple(ltl1));
        this.formulas.add(new LTLFormulaTuple(ltl2));
        this.formulas.add(new LTLFormulaTuple(ltl3));
        this.cache.put(ltl1, new HashMap());
        this.cache.put(ltl2, new HashMap());
        this.cache.put(ltl3, new HashMap());
    }

    public void submitFormulas() {
        int len = this.formulas.size();
        Object[] res = new Object[len];
        for (int i = 0; i < len; ++i) {
            LTLFormulaTuple tuple = this.formulas.get(i);
            String statusString = tuple.getStatus();
            res[i] = WebUtils.wrap("id", String.valueOf(i), "formulaText", tuple.getFormula().getCode(), "status", statusString);
        }
        Map<String, String> wrap = WebUtils.wrap("cmd", "LtlFormula.setFormulas", "formulas", WebUtils.toJson(res));
        this.submit(wrap);
    }

    public Object checkNthFormula(Map<String, String[]> params) {
        int pos = Integer.parseInt(this.get(params, "pos"));
        LTLFormulaTuple tuple = this.formulas.get(pos);
        LTL formula = tuple.getFormula();
        Trace currentTrace = this.getCurrentTrace();
        if (currentTrace != null) {
            State stateid = currentTrace.getCurrentState();
            EvaluationCommand lcc = formula.getCommand(stateid);
            currentTrace.getStateSpace().execute((AbstractCommand)lcc);
            String result = lcc.getValue().toString();
            tuple.setStatus(result);
            this.cache.get(formula).put(stateid, result);
            this.submitFormulas();
        }
        return null;
    }

    public Object removeFormula(Map<String, String[]> params) {
        int pos = Integer.parseInt(this.get(params, "pos"));
        this.formulas.remove(pos);
        this.submitFormulas();
        return null;
    }

    public Object addFormula(Map<String, String[]> params) throws LtlParseException {
        String formula = this.get(params, "val");
        if (formula == null || formula.isEmpty()) {
            return null;
        }
        LTL ltl = new LTL(formula);
        this.formulas.add(new LTLFormulaTuple(ltl));
        this.cache.put(ltl, new HashMap());
        this.logger.trace(params.toString());
        this.submitFormulas();
        return null;
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/ltlFormula/index.html");
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        this.submitFormulas();
    }

    @Override
    public void performTraceChange(Trace trace) {
        if (trace != null) {
            State current = trace.getCurrentState();
            for (LTLFormulaTuple tuple : this.formulas) {
                String cached = this.cache.get(tuple.formula).get(current);
                if (cached != null) {
                    tuple.setStatus(cached);
                    continue;
                }
                tuple.resetStatus();
            }
            this.submitFormulas();
        }
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "LtlFormula.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "LtlFormula.enable"));
        }
    }

    private class LTLFormulaTuple {
        private final LTL formula;
        private String status;

        public LTLFormulaTuple(LTL f) {
            this.formula = f;
            this.setStatus("unchecked");
        }

        public LTL getFormula() {
            return this.formula;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void resetStatus() {
            this.status = "unchecked";
        }
    }
}

