/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Singleton;
import de.prob.web.AbstractSession;
import de.prob.web.WebUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;

@Singleton
public class BUnit
extends AbstractSession {
    Set<String> suites = new HashSet<String>();

    public BUnit() {
        this.incrementalUpdate = false;
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/bunit/index.html");
    }

    public void reset() {
        this.submit(WebUtils.wrap("cmd", "BUnit.clearInput"));
        this.suites.clear();
    }

    public void startTest(String suiteName, String testName, String testId) {
        if (!this.suites.contains(suiteName)) {
            this.submit(WebUtils.wrap("cmd", "BUnit.addSuite", "name", suiteName));
            this.suites.add(suiteName);
        }
        this.submit(WebUtils.wrap("cmd", "BUnit.addTest", "suite", suiteName, "name", testName, "id", testId));
    }

    public void testFailure(String suiteName, String testId, String message) {
        this.submit(WebUtils.wrap("cmd", "BUnit.testFail", "suite", suiteName, "test", testId, "reason", message));
    }

    public void testError(String suiteName, String testId, String message) {
        this.submit(WebUtils.wrap("cmd", "BUnit.testError", "suite", suiteName, "test", testId, "reason", message));
    }

    public void testIgnore(String suiteName, String testName, String testId) {
        if (!this.suites.contains(suiteName)) {
            this.submit(WebUtils.wrap("cmd", "BUnit.addSuite", "name", suiteName));
            this.suites.add(suiteName);
        }
        this.submit(WebUtils.wrap("cmd", "BUnit.testIgnore", "suite", suiteName, "name", testName, "id", testId));
    }

    public void testRunFinished(int runCount, int failCount, int ignoreCount) {
        this.submit(WebUtils.wrap("cmd", "BUnit.setStats", "success", runCount - failCount, "total", runCount, "ignored", ignoreCount));
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        this.reset();
    }
}

