/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class WebUtils {
    private static final Gson GSON = new Gson();

    public static String render(String name, Object ... scopes) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile(name);
        StringWriter sw = new StringWriter();
        try {
            mustache.execute((Writer)sw, scopes).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static Map<String, String> wrap(Object ... content) {
        if (content.length % 2 != 0) {
            throw new IllegalArgumentException("wrap requires an even number of arguments");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < content.length; i += 2) {
            m.put(content[i].toString(), content[i + 1].toString());
        }
        return m;
    }

    public static Map<String, String> wrap(String ... content) {
        if (content.length % 2 != 0) {
            throw new IllegalArgumentException("wrap requires an even number of arguments");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < content.length; i += 2) {
            m.put(content[i], content[i + 1]);
        }
        return m;
    }

    public static String toJson(Object o) {
        return GSON.toJson(o);
    }
}

