/*
 * Decompiled with CFR 0.152.
 */
package de.prob.testing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.web.views.BUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import junit.framework.AssertionFailedError;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.SpockComparisonFailure;

@Singleton
public class ProBTestListener
extends RunListener {
    private final BUnit view;
    Map<String, String> uuidMapping = new HashMap<String, String>();
    Logger logger = LoggerFactory.getLogger(ProBTestListener.class);

    @Inject
    public ProBTestListener(BUnit view) {
        this.view = view;
    }

    public void testRunStarted(Description description) throws Exception {
        this.uuidMapping.clear();
        this.view.reset();
    }

    public void testRunFinished(Result result) throws Exception {
        this.view.testRunFinished(result.getRunCount(), result.getFailureCount(), result.getIgnoreCount());
    }

    public void testStarted(Description description) throws Exception {
        String randomUUID = UUID.randomUUID().toString();
        this.uuidMapping.put(description.getDisplayName(), randomUUID);
        this.view.startTest(description.getClassName(), description.getMethodName(), randomUUID);
    }

    public void testFinished(Description description) throws Exception {
        this.logger.info("Test Finished - " + description.getClassName() + " : " + description.getMethodName() + " : " + description.getDisplayName());
    }

    public void testFailure(Failure failure) throws Exception {
        String id = this.uuidMapping.get(failure.getDescription().getDisplayName());
        if (this.isFailure(failure)) {
            this.view.testFailure(failure.getDescription().getClassName(), id, failure.getMessage().replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;"));
        } else {
            this.view.testError(failure.getDescription().getClassName(), id, this.generateTraceMessage(failure.getMessage(), failure.getException()));
        }
    }

    public void testAssumptionFailure(Failure failure) {
        String id = this.uuidMapping.get(failure.getDescription().getDisplayName());
        if (this.isFailure(failure)) {
            this.view.testFailure(failure.getDescription().getClassName(), id, failure.getMessage().replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;"));
        } else {
            this.view.testError(failure.getDescription().getClassName(), id, this.generateTraceMessage(failure.getMessage(), failure.getException()));
        }
    }

    public void testIgnored(Description description) throws Exception {
        String randomUUID = UUID.randomUUID().toString();
        this.uuidMapping.put(description.getDisplayName(), randomUUID);
        this.view.testIgnore(description.getClassName(), description.getMethodName(), randomUUID);
    }

    private String generateTraceMessage(String message, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Message:</p><p>" + message.replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;") + "</p><p></p>");
        sb.append("<p>An Exception of " + e.getClass() + " was thrown.</p><p></p><ul class='trace'>");
        for (StackTraceElement element : e.getStackTrace()) {
            if (this.inFilter(element.getClassName())) continue;
            sb.append("<li>at " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private boolean inFilter(String e) {
        if (e.startsWith("junit.framework.")) {
            return true;
        }
        if (e.startsWith("java.lang.reflect.")) {
            return true;
        }
        if (e.startsWith("sun.reflect.")) {
            return true;
        }
        if (e.startsWith("groovy.lang.MetaClassImpl.")) {
            return true;
        }
        if (e.startsWith("groovy.lang.MetaMethod.")) {
            return true;
        }
        if (e.startsWith("org.codehaus.groovy.")) {
            return true;
        }
        if (e.startsWith("org.junit.")) {
            return true;
        }
        return e.startsWith("junit.framework.");
    }

    private boolean isFailure(Failure f) {
        return f.getException() instanceof AssertionFailedError || f.getException() instanceof AssertionError || f.getException() instanceof SpockComparisonFailure;
    }
}

