/*
 * Decompiled with CFR 0.152.
 */
package de.prob.servlet;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import de.prob.scripting.Downloader;
import de.prob.scripting.FileHandler;
import de.prob.servlet.MainModule;
import de.prob.webconsole.WebConsole;
import java.io.File;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static boolean restricted = true;
    public static boolean standalone = false;
    public static boolean local = false;
    public static boolean multianimation = false;
    public static int maxCacheSize = 100;
    private final Logger logger = LoggerFactory.getLogger(Main.class);
    private final CommandLineParser parser;
    private final Options options;
    private static Injector INJECTOR = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new MainModule()});
    public static final String PREFERENCE_FILE_NAME = "prob2preferences";
    public static final String PROB_HOME = Main.getProBDirectory();
    public static final String LOG_CONFIG = System.getProperty("PROB_LOG_CONFIG") == null ? "production.xml" : System.getProperty("PROB_LOG_CONFIG");
    private final Downloader downloader;

    public static Injector getInjector() {
        return INJECTOR;
    }

    public static void setInjector(Injector i) {
        INJECTOR = i;
    }

    @Inject
    public Main(CommandLineParser parser, Options options, Downloader downloader) {
        this.parser = parser;
        this.options = options;
        this.downloader = downloader;
        this.logger.debug("Java version: {}", (Object)System.getProperty("java.version"));
    }

    private void run(String[] args) throws Throwable {
        String url = "";
        int port = -1;
        String iface = "0.0.0.0";
        try {
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption("upgrade") || line.hasOption("cli")) {
                String version;
                String string = version = line.hasOption("upgrade") ? line.getOptionValue("upgrade") : line.getOptionValue("cli");
                if (version == null) {
                    version = "latest";
                }
                if (version.equals("cspm")) {
                    System.out.println(this.downloader.installCSPM());
                } else {
                    System.out.println(this.downloader.downloadCli(version));
                }
            }
            if (line.hasOption("browser")) {
                this.logger.debug("Browser");
                url = line.getOptionValue("browser");
                this.logger.debug("Browser started");
            }
            if (line.hasOption("port")) {
                port = Integer.parseInt(line.getOptionValue("port"));
            }
            if (line.hasOption("local")) {
                local = true;
                restricted = false;
                iface = "127.0.0.1";
            }
            if (line.hasOption("standalone")) {
                standalone = true;
            }
            if (line.hasOption("multianimation")) {
                multianimation = true;
            }
            if (line.hasOption("maxCacheSize")) {
                this.logger.debug("setting maximum cache size requested");
                String value = line.getOptionValue("maxCacheSize");
                this.logger.debug("retrieved maxSize");
                maxCacheSize = Integer.valueOf(value);
                this.logger.debug("Max size set successfully to {}", (Object)value);
            }
            this.runServer(url, iface, port);
            if (line.hasOption("shell")) {
                while (true) {
                    Thread.sleep(10L);
                }
            }
        }
        catch (ParseException exp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar probcli.jar", this.options);
        }
    }

    private void runServer(final String url, final String iface, final int port) {
        this.logger.debug("Shell");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebConsole.run(url, iface, port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public static String getProBDirectory() {
        String homedir = System.getProperty("prob.home");
        if (homedir != null) {
            return homedir + File.separator;
        }
        return System.getProperty("user.home") + File.separator + ".prob" + File.separator;
    }

    public static Map<String, String> getGlobalPreferences(Map<String, String> localPrefs) {
        FileHandler handler = new FileHandler();
        String preferenceFileName = Main.getProBDirectory() + PREFERENCE_FILE_NAME;
        Map prefs = handler.getMapOfStrings(preferenceFileName);
        if (prefs == null) {
            return localPrefs;
        }
        prefs.putAll(localPrefs);
        return prefs;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("PROB_LOG_CONFIG", LOG_CONFIG);
            Main main = (Main)Main.getInjector().getInstance(Main.class);
            main.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

