/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.upgrade;

import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.IResult;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.upgrade.AssignmentUpgrader;
import org.eventb.internal.core.upgrade.UpgradeResult;

public abstract class VersionUpgrader {
    public static boolean DEBUG;
    private final FormulaFactory sourceFactory;

    public VersionUpgrader(FormulaFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    public void upgradeAssignment(String input, UpgradeResult<Assignment> result) {
        IParseResult parseResult = this.sourceFactory.parseAssignment(input, null);
        if (parseResult.hasProblem()) {
            VersionUpgrader.copyProblems(parseResult, result);
            result.setUpgradeNeeded(true);
            return;
        }
        Assignment assign = parseResult.getParsedAssignment();
        this.checkUpgrade(input, assign, result);
        if (result.upgradeNeeded() && !result.hasProblem()) {
            assign.accept(new AssignmentUpgrader(this, result));
        }
    }

    public void upgradeExpression(String input, UpgradeResult<Expression> result) {
        IParseResult parseResult = this.sourceFactory.parseExpression(input, null);
        if (parseResult.hasProblem()) {
            VersionUpgrader.copyProblems(parseResult, result);
            result.setUpgradeNeeded(true);
            return;
        }
        Expression expr = parseResult.getParsedExpression();
        this.upgrade(input, expr, result);
    }

    public void upgradePredicate(String input, UpgradeResult<Predicate> result) {
        IParseResult parseResult = this.sourceFactory.parsePredicate(input, null);
        if (parseResult.hasProblem()) {
            VersionUpgrader.copyProblems(parseResult, result);
            result.setUpgradeNeeded(true);
            return;
        }
        Predicate pred = parseResult.getParsedPredicate();
        this.upgrade(input, pred, result);
    }

    static void copyProblems(IResult result, UpgradeResult<?> upgradeResult) {
        for (ASTProblem problem : result.getProblems()) {
            upgradeResult.addProblem(problem);
        }
    }

    <T extends Formula<T>> void upgrade(String input, T formula, UpgradeResult<T> result) {
        this.checkUpgrade(input, formula, result);
        if (result.upgradeNeeded() && !result.hasProblem()) {
            this.upgrade(formula, result);
        }
    }

    protected abstract <T extends Formula<T>> void checkUpgrade(String var1, Formula<T> var2, UpgradeResult<T> var3);

    protected abstract <T extends Formula<T>> void upgrade(T var1, UpgradeResult<T> var2);

    protected abstract List<String> getReservedKeywords();
}

