/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.typecheck;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IDatatypeTranslation;
import org.eventb.core.ast.IExtensionTranslation;
import org.eventb.core.ast.ISpecialization;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.Specialization;
import org.eventb.internal.core.ast.TypeRewriter;
import org.eventb.internal.core.ast.datatype.DatatypeTranslation;
import org.eventb.internal.core.ast.extension.ExtensionTranslation;
import org.eventb.internal.core.typecheck.TypeEnvironmentBuilder;

public abstract class TypeEnvironment
implements ITypeEnvironment {
    protected final FormulaFactory ff;
    protected final Map<String, Type> map;

    protected TypeEnvironment(FormulaFactory ff) {
        this.ff = ff;
        this.map = new HashMap<String, Type>();
    }

    protected TypeEnvironment(TypeEnvironment typenv) {
        this.ff = typenv.ff;
        this.map = new HashMap<String, Type>(typenv.map);
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean contains(FreeIdentifier ident) {
        Type type = ident.getType();
        if (type == null) {
            throw new IllegalArgumentException("Identifier " + ident + " has no type");
        }
        return type.equals(this.getType(ident.getName()));
    }

    @Override
    public boolean containsAll(ITypeEnvironment typenv) {
        if (this == typenv) {
            return true;
        }
        TypeEnvironment other = (TypeEnvironment)typenv;
        for (Map.Entry<String, Type> entry : other.map.entrySet()) {
            String name = entry.getKey();
            if (entry.getValue().equals(this.getType(name))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TypeEnvironment other = (TypeEnvironment)obj;
        return this.map.equals(other.map);
    }

    @Override
    public IDatatypeTranslation makeDatatypeTranslation() {
        return new DatatypeTranslation(this.makeSnapshot());
    }

    @Override
    public IExtensionTranslation makeExtensionTranslation() {
        return new ExtensionTranslation(this.makeSnapshot());
    }

    @Override
    public ITypeEnvironment.IIterator getIterator() {
        return new InternalIterator(this.map.entrySet().iterator());
    }

    @Override
    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Type getType(String name) {
        return this.map.get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public FormulaFactory getFormulaFactory() {
        return this.ff;
    }

    @Override
    public ITypeEnvironmentBuilder specialize(ISpecialization specialization) {
        return ((Specialization)specialization).specialize(this);
    }

    @Override
    public ITypeEnvironmentBuilder makeBuilder() {
        return new TypeEnvironmentBuilder(this);
    }

    @Override
    public boolean isTranslatable(FormulaFactory factory) {
        if (factory == this.ff) {
            return true;
        }
        ITypeEnvironment.IIterator iter = this.getIterator();
        while (iter.hasNext()) {
            iter.advance();
            if (!factory.isValidIdentifierName(iter.getName())) {
                return false;
            }
            if (iter.getType().isTranslatable(factory)) continue;
            return false;
        }
        return true;
    }

    protected ITypeEnvironmentBuilder doTranslate(FormulaFactory fac) {
        TypeRewriter rewriter = new TypeRewriter(fac);
        TypeEnvironmentBuilder result = new TypeEnvironmentBuilder(fac);
        ITypeEnvironment.IIterator iter = this.getIterator();
        while (iter.hasNext()) {
            iter.advance();
            result.addName(iter.getName(), rewriter.rewrite(iter.getType()));
        }
        return result;
    }

    final class InternalIterator
    implements ITypeEnvironment.IIterator {
        Iterator<Map.Entry<String, Type>> iterator;
        Map.Entry<String, Type> current;

        public InternalIterator(Iterator<Map.Entry<String, Type>> iterator) {
            this.iterator = iterator;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void advance() throws NoSuchElementException {
            this.current = this.iterator.next();
        }

        @Override
        public String getName() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current.getKey();
        }

        @Override
        public Type getType() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current.getValue();
        }

        @Override
        public boolean isGivenSet() throws NoSuchElementException {
            return GivenTypeHelper.isGivenSet(this.getName(), this.getType());
        }

        @Override
        public FreeIdentifier asFreeIdentifier() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return TypeEnvironment.this.ff.makeFreeIdentifier(this.getName(), null, this.getType());
        }
    }
}

