/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.extension.IOperator;
import org.eventb.core.ast.extension.IOperatorGroup;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;
import org.eventb.internal.core.parser.operators.Matrix;

public class OperatorGroupCompact {
    private final String id;
    private final int firstKind;
    private final int lastKind;
    private final Matrix compatibilityRelation;
    private final Matrix operatorPriority;
    private final BitSet associativeOperators;
    private final BitSet spacedOperators;

    public OperatorGroupCompact(String id, int firstKind, int lastKind, Matrix compatibilityRelation, Matrix operatorPriority, BitSet associativeOperators, BitSet spacedOperators) {
        this.id = id;
        this.firstKind = firstKind;
        this.lastKind = lastKind;
        this.compatibilityRelation = compatibilityRelation;
        this.operatorPriority = operatorPriority;
        this.associativeOperators = associativeOperators;
        this.spacedOperators = spacedOperators;
    }

    public String getId() {
        return this.id;
    }

    public int getFirstKind() {
        return this.firstKind;
    }

    public int getLastKind() {
        return this.lastKind;
    }

    private void checkKnown(int ... ops) {
        for (int op : ops) {
            if (op >= this.firstKind && op <= this.lastKind) continue;
            throw new IllegalArgumentException("unknown operator " + op + " in group " + this.id);
        }
    }

    public boolean hasLessPriority(int a, int b) {
        this.checkKnown(a, b);
        return this.operatorPriority.get(a, b);
    }

    public boolean isCompatible(int a, int b) {
        this.checkKnown(a, b);
        return this.compatibilityRelation.get(a, b) || this.operatorPriority.get(a, b) || this.operatorPriority.get(b, a);
    }

    public boolean isAssociative(int a) {
        this.checkKnown(a);
        return this.associativeOperators.get(a);
    }

    public boolean isSpaced(int kind) {
        this.checkKnown(kind);
        return this.spacedOperators.get(kind);
    }

    public IOperatorGroup asExternalView(ExternalViewUtils.Instantiator<Integer, IOperator> inst) {
        HashSet<IOperator> extOpers = new HashSet<IOperator>();
        for (int i = this.firstKind; i <= this.lastKind; ++i) {
            extOpers.add(inst.instantiate(i));
        }
        Map<IOperator, Set<IOperator>> extPrio = this.operatorPriority.toRelationMap(inst);
        Map<IOperator, Set<IOperator>> extCompat = this.compatibilityRelation.toRelationMap(inst);
        Set<IOperator> extAssoc = this.toSet(this.associativeOperators, inst);
        return new ExternalViewUtils.ExternalOpGroup(this.id, extOpers, extPrio, extCompat, extAssoc);
    }

    private Set<IOperator> toSet(BitSet bitSet, ExternalViewUtils.Instantiator<Integer, IOperator> inst) {
        HashSet<IOperator> set = new HashSet<IOperator>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            IOperator op = inst.instantiate(i);
            set.add(op);
            i = bitSet.nextSetBit(i + 1);
        }
        return set;
    }

    public String toString() {
        return this.id;
    }
}

