/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eventb.internal.core.parser.operators.AllInOnceMap;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;
import org.eventb.internal.core.parser.operators.Matrix;
import org.eventb.internal.core.parser.operators.OpGroupCompactor;
import org.eventb.internal.core.parser.operators.OperatorGroup;
import org.eventb.internal.core.parser.operators.OperatorGroupCompact;
import org.eventb.internal.core.parser.operators.OperatorRegistry;
import org.eventb.internal.core.parser.operators.OperatorRegistryCompact;

public class OpRegistryCompactor {
    private final OperatorRegistry initOpReg;

    public OpRegistryCompactor(OperatorRegistry initOpReg) {
        this.initOpReg = initOpReg;
    }

    public OperatorRegistryCompact compact(ExternalViewUtils.Instantiator<Integer, Integer> kindInst) {
        Collection<OperatorGroup> initOpGroups = this.initOpReg.getIdOpGroup().values();
        OperatorGroupCompact[] groups = new OperatorGroupCompact[initOpGroups.size()];
        int[] firstKinds = new int[initOpGroups.size() + 1];
        ExternalViewUtils.Instantiator<OperatorGroup, Integer> groupInst = new ExternalViewUtils.Instantiator<OperatorGroup, Integer>();
        this.makeGroupsAndKinds(initOpGroups, groups, firstKinds, kindInst, groupInst);
        AllInOnceMap<String, Integer> idKind = new AllInOnceMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.initOpReg.getIdKind().entrySet()) {
            Integer newKind = kindInst.instantiate(entry.getValue());
            idKind.put(entry.getKey(), newKind);
        }
        Map<OperatorGroup, Set<OperatorGroup>> priorityMap = this.initOpReg.getGroupPriority().getRelationMap();
        Matrix groupPriority = OpRegistryCompactor.convert(groups.length, groupInst, priorityMap);
        return new OperatorRegistryCompact(groups, firstKinds, idKind, groupPriority);
    }

    private static Matrix convert(int groupCount, ExternalViewUtils.Instantiator<OperatorGroup, Integer> groupInst, Map<OperatorGroup, Set<OperatorGroup>> priorityMap) {
        Matrix groupPriority = new Matrix(groupCount);
        for (Map.Entry<OperatorGroup, Set<OperatorGroup>> rel : priorityMap.entrySet()) {
            int left = groupInst.instantiate(rel.getKey());
            for (OperatorGroup groupRight : rel.getValue()) {
                int right = groupInst.instantiate(groupRight);
                groupPriority.set(left, right);
            }
        }
        return groupPriority;
    }

    private void makeGroupsAndKinds(Collection<OperatorGroup> initOpGroups, OperatorGroupCompact[] groups, int[] firstKinds, ExternalViewUtils.Instantiator<Integer, Integer> kindInst, ExternalViewUtils.Instantiator<OperatorGroup, Integer> groupInst) {
        OperatorGroup initGroup0 = this.initOpReg.getGroup0();
        int index = 0;
        firstKinds[index] = 0;
        OpGroupCompactor gr0Compactor = new OpGroupCompactor(initGroup0, firstKinds[index], kindInst);
        groups[index] = gr0Compactor.compact();
        firstKinds[index + 1] = groups[index].getLastKind() + 1;
        groupInst.setInst(initGroup0, index);
        ++index;
        for (OperatorGroup initOpGroup : initOpGroups) {
            if (initOpGroup == initGroup0) continue;
            OpGroupCompactor compactor = new OpGroupCompactor(initOpGroup, firstKinds[index], kindInst);
            groups[index] = compactor.compact();
            firstKinds[index + 1] = groups[index].getLastKind() + 1;
            groupInst.setInst(initOpGroup, index);
            ++index;
        }
    }
}

