/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.extension.IGrammar;
import org.eventb.core.ast.extension.IOperator;
import org.eventb.core.ast.extension.IOperatorGroup;

public class ExternalViewUtils {

    public static class Instantiator<S, T> {
        private final Map<S, T> instantiation = new HashMap<S, T>();

        public void setInst(S source, T target) {
            T old = this.instantiation.put(source, target);
            if (old != null) {
                throw new IllegalArgumentException("source " + source + " already is given several targets: " + old + " and " + target);
            }
        }

        public boolean hasInst(S source) {
            return this.instantiation.containsKey(source);
        }

        public Collection<T> values() {
            return this.instantiation.values();
        }

        public T instantiate(S source) {
            T target = this.instantiation.get(source);
            if (target == null) {
                throw new IllegalStateException("no target for source " + source);
            }
            return target;
        }
    }

    public static class ExternalGrammar
    implements IGrammar {
        private final Set<IOperatorGroup> groups;
        private Map<IOperatorGroup, Set<IOperatorGroup>> groupPrios;

        public ExternalGrammar(Set<IOperatorGroup> groups, Map<IOperatorGroup, Set<IOperatorGroup>> groupPrios) {
            this.groups = groups;
            this.groupPrios = groupPrios;
        }

        @Override
        public Set<IOperatorGroup> getGroups() {
            return this.groups;
        }

        @Override
        public Map<IOperatorGroup, Set<IOperatorGroup>> getGroupPriorities() {
            return this.groupPrios;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n===========  Grammar:  ===========\n");
            for (IOperatorGroup iOperatorGroup : this.groups) {
                sb.append(iOperatorGroup);
                sb.append("\n*********************\n");
            }
            sb.append("\n++++++++++  Priorities:  +++++++++\n");
            for (Map.Entry entry : this.groupPrios.entrySet()) {
                ArrayList<String> ids = new ArrayList<String>();
                for (IOperatorGroup group : (Set)entry.getValue()) {
                    ids.add(group.getId());
                }
                sb.append(((IOperatorGroup)entry.getKey()).getId());
                sb.append(" < ");
                sb.append(ids);
                sb.append('\n');
            }
            sb.append("\n==================================\n");
            return sb.toString();
        }
    }

    public static class ExternalOpGroup
    implements IOperatorGroup {
        private final String id;
        private final Set<IOperator> operators;
        private final Map<IOperator, Set<IOperator>> priorities;
        private final Map<IOperator, Set<IOperator>> compatibilities;
        private final Set<IOperator> associativeOperators;

        public ExternalOpGroup(String id, Set<IOperator> operators, Map<IOperator, Set<IOperator>> priorities, Map<IOperator, Set<IOperator>> compatibilities, Set<IOperator> associativeOperators) {
            this.id = id;
            this.operators = operators;
            this.priorities = priorities;
            this.compatibilities = compatibilities;
            this.associativeOperators = associativeOperators;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Set<IOperator> getOperators() {
            return this.operators;
        }

        @Override
        public Map<IOperator, Set<IOperator>> getPriorities() {
            return this.priorities;
        }

        @Override
        public Map<IOperator, Set<IOperator>> getCompatibilities() {
            return this.compatibilities;
        }

        @Override
        public Set<IOperator> getAssociativeOperators() {
            return this.associativeOperators;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("group id=");
            sb.append(this.id);
            sb.append("\nall operators=\n");
            sb.append(this.operators);
            sb.append("\npriorities=\n");
            sb.append(this.priorities);
            sb.append("\ncompatibilities=\n");
            sb.append(this.compatibilities);
            sb.append("\nassociative operators=\n");
            sb.append(this.associativeOperators);
            return sb.toString();
        }
    }

    public static class ExternalOperator
    implements IOperator {
        private final String id;
        private final String syntaxSymbol;

        public ExternalOperator(String id, String syntaxSymbol) {
            this.id = id;
            this.syntaxSymbol = syntaxSymbol;
        }

        @Override
        public String getSyntaxSymbol() {
            return this.syntaxSymbol;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.syntaxSymbol;
        }
    }
}

