/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TokenSet {
    public static final int FIRST_KIND = 0;
    public static final int UNKNOWN_KIND = -1;
    private final Map<String, Integer> lexTokens;
    private final Map<String, Integer> reserved;
    private final String[] images;
    private int nextKind = 0;

    public TokenSet() {
        this.lexTokens = new HashMap<String, Integer>();
        this.reserved = new HashMap<String, Integer>();
        this.images = null;
    }

    public TokenSet(Map<String, Integer> lexTokens, Map<String, Integer> reserved) {
        this.lexTokens = lexTokens;
        this.reserved = reserved;
        this.images = new String[lexTokens.size() + reserved.size()];
        this.initImages(lexTokens);
        this.initImages(reserved);
    }

    private void initImages(Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int kind = entry.getValue();
            String image = entry.getKey();
            if (this.images[kind] != null) {
                throw new IllegalStateException("token kind overriding: kind = " + kind + " images: \"" + this.images[kind] + "\" and \"" + image + "\"");
            }
            this.images[kind] = image;
        }
    }

    public int size() {
        return this.nextKind;
    }

    public int getOrAdd(String lexImage) {
        return this.getOrAdd(lexImage, this.lexTokens);
    }

    public int reserved(String reservedId) {
        return this.getOrAdd(reservedId, this.reserved);
    }

    private int getOrAdd(String key, Map<String, Integer> addTo) {
        Integer current = addTo.get(key);
        if (current != null) {
            return current;
        }
        int kind = this.nextKind++;
        addTo.put(key, kind);
        return kind;
    }

    public int getKind(String lexImage) {
        return TokenSet.getKind(lexImage, this.lexTokens);
    }

    public int getReserved(String reservedId) {
        return TokenSet.getKind(reservedId, this.reserved);
    }

    private static int getKind(String key, Map<String, Integer> map) {
        Integer kind = map.get(key);
        if (kind == null) {
            return -1;
        }
        return kind;
    }

    public String getImage(int kind) {
        if (this.images != null) {
            return this.images[kind];
        }
        return this.findImage(kind);
    }

    private String findImage(int kind) {
        String elem = TokenSet.getElem(kind, this.lexTokens);
        if (elem != null) {
            return elem;
        }
        return TokenSet.getElem(kind, this.reserved);
    }

    public boolean contains(String lexImage) {
        return this.getKind(lexImage) != -1;
    }

    private static String getElem(int kind, Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (!entry.getValue().equals(kind)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<Map.Entry<String, Integer>> entrySet() {
        return Collections.unmodifiableSet(this.lexTokens.entrySet());
    }

    public boolean isReserved(int kind) {
        return this.reserved.containsKey(this.getImage(kind));
    }
}

