/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IPredicateExtension;
import org.eventb.core.ast.extension.ITypeDistribution;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ILedParser;
import org.eventb.internal.core.parser.INudParser;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.MainParsers;
import org.eventb.internal.core.parser.ParseResult;
import org.eventb.internal.core.parser.ParserContext;
import org.eventb.internal.core.parser.Pattern;

public class SubParsers {
    static final String SPACE = " ";
    static final Predicate[] NO_PRED = new Predicate[0];
    static final String[] NO_DECL = new String[0];
    public static final INudParser<Identifier> IDENT_SUBPARSER = new ValuedNudParser<Identifier>(){

        @Override
        protected int getKind(AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.IDENT);
        }

        @Override
        protected Identifier makeValue(ParserContext pc, String tokenVal, SourceLocation loc) {
            if (pc.isParsingType()) {
                PowerSetType type = pc.factory.makePowerSetType(pc.factory.makeGivenType(tokenVal));
                return pc.factory.makeFreeIdentifier(tokenVal, loc, type);
            }
            int index = pc.getBoundIndex(tokenVal);
            if (index == -1) {
                return pc.factory.makeFreeIdentifier(tokenVal, loc);
            }
            return pc.factory.makeBoundIdentifier(index, loc);
        }

        @Override
        public void toString(IToStringMediator mediator, Identifier toPrint) {
            switch (toPrint.getTag()) {
                case 1: {
                    FREE_IDENT_SUBPARSER.toString(mediator, (FreeIdentifier)toPrint);
                    break;
                }
                case 3: {
                    BoundIdentifier boundIdent = (BoundIdentifier)toPrint;
                    mediator.appendBoundIdent(boundIdent.getBoundIndex());
                }
            }
        }
    };
    static final INudParser<FreeIdentifier> FREE_IDENT_SUBPARSER = new INudParser<FreeIdentifier>(){

        @Override
        public IParserPrinter.SubParseResult<FreeIdentifier> nud(ParserContext pc) throws GenParser.SyntaxError {
            Identifier ident = pc.subParse(IDENT_SUBPARSER, false);
            if (!(ident instanceof FreeIdentifier)) {
                throw pc.syntaxError(new ASTProblem(ident.getSourceLocation(), ProblemKind.FreeIdentifierExpected, 1, new Object[0]));
            }
            FreeIdentifier freeIdent = (FreeIdentifier)ident;
            return new IParserPrinter.SubParseResult<FreeIdentifier>(freeIdent, pc.getGrammar().getKind(AbstractGrammar.DefaultToken.IDENT), true);
        }

        @Override
        public void toString(IToStringMediator mediator, FreeIdentifier toPrint) {
            mediator.append(toPrint.getName());
        }
    };
    public static final BoundIdentDeclSubParser BOUND_IDENT_DECL_SUBPARSER = new BoundIdentDeclSubParser();
    public static final IntLitSubParser INTLIT_SUBPARSER = new IntLitSubParser();
    public static final INudParser<Predicate> PRED_VAR_SUBPARSER = new ValuedNudParser<Predicate>(){

        @Override
        protected int getKind(AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.PRED_VAR);
        }

        @Override
        protected Predicate makeValue(ParserContext pc, String tokenVal, SourceLocation loc) throws GenParser.SyntaxError {
            if (!pc.withPredVar) {
                pc.result.addProblem(new ASTProblem(loc, ProblemKind.PredicateVariableNotAllowed, 1, tokenVal));
                return pc.factory.makeLiteralPredicate(610, loc);
            }
            return pc.factory.makePredicateVariable(tokenVal, loc);
        }

        @Override
        public void toString(IToStringMediator mediator, Predicate toPrint) {
            String name = ((PredicateVariable)toPrint).getName();
            mediator.append(name);
        }
    };
    public static final ILedParser<Expression> OFTYPE_PARSER = new OftypeParser();
    static final ExtensionCheckMaker<ExtendedExpression> EXTENDED_EXPR = new ExtensionCheckMaker<ExtendedExpression>(){

        @Override
        protected ExtendedExpression make(FormulaFactory factory, IFormulaExtension extension, List<Expression> childExprs, List<Predicate> childPreds, SourceLocation loc) {
            return factory.makeExtendedExpression((IExpressionExtension)extension, childExprs, childPreds, loc);
        }
    };
    static final ExtensionCheckMaker<ExtendedPredicate> EXTENDED_PRED = new ExtensionCheckMaker<ExtendedPredicate>(){

        @Override
        protected ExtendedPredicate make(FormulaFactory factory, IFormulaExtension extension, List<Expression> childExprs, List<Predicate> childPreds, SourceLocation loc) {
            return factory.makeExtendedPredicate((IPredicateExtension)extension, childExprs, childPreds, loc);
        }
    };

    private static abstract class ExtensionCheckMaker<T extends IExtendedFormula> {
        public final void check(ParserContext pc, int tag, List<? extends Formula<?>> children) throws GenParser.SyntaxError {
            IFormulaExtension extension = pc.factory.getExtension(tag);
            ITypeDistribution childTypes = extension.getKind().getProperties().getChildTypes();
            if (!childTypes.check(children)) {
                SourceLocation loc = pc.getSourceLocation();
                throw pc.syntaxError(new ASTProblem(loc, ProblemKind.ExtensionPreconditionError, 1, new Object[0]));
            }
        }

        public final T make(FormulaFactory factory, int tag, List<? extends Formula<?>> children, SourceLocation loc) {
            IFormulaExtension extension = factory.getExtension(tag);
            ArrayList<Expression> childExprs = new ArrayList<Expression>();
            ArrayList<Predicate> childPreds = new ArrayList<Predicate>();
            ExtensionCheckMaker.splitExprPred(children, childExprs, childPreds);
            return this.make(factory, extension, childExprs, childPreds, loc);
        }

        private static void splitExprPred(List<? extends Formula<?>> children, List<Expression> childExprs, List<Predicate> childPreds) {
            for (Formula<?> child : children) {
                if (child instanceof Expression) {
                    childExprs.add((Expression)child);
                    continue;
                }
                childPreds.add((Predicate)child);
            }
        }

        protected abstract T make(FormulaFactory var1, IFormulaExtension var2, List<Expression> var3, List<Predicate> var4, SourceLocation var5);
    }

    public static class ExtendedPredParen
    extends AbstractExtendedParen<ExtendedPredicate> {
        public ExtendedPredParen(int kind, int tag) {
            super(kind, tag, EXTENDED_PRED);
        }
    }

    public static class ExtendedExprParen
    extends AbstractExtendedParen<ExtendedExpression> {
        public ExtendedExprParen(int kind, int tag) {
            super(kind, tag, EXTENDED_EXPR);
        }
    }

    private static class AbstractExtendedParen<R extends IExtendedFormula>
    extends ParenNudParser<R, List<Formula<?>>> {
        private final ExtensionCheckMaker<R> extCheckMaker;

        public AbstractExtendedParen(int kind, int tag, ExtensionCheckMaker<R> extCheckMaker) {
            super(kind, tag, MainParsers.FORMULA_LIST_PARSER);
            this.extCheckMaker = extCheckMaker;
        }

        @Override
        protected void checkValue(ParserContext pc, List<Formula<?>> children) throws GenParser.SyntaxError {
            this.extCheckMaker.check(pc, this.tag, children);
        }

        @Override
        protected R makeValue(FormulaFactory factory, List<Formula<?>> children, SourceLocation loc) throws GenParser.SyntaxError {
            return this.extCheckMaker.make(factory, this.tag, children, loc);
        }

        @Override
        protected List<Formula<?>> getChild(R parent) {
            ITypeDistribution childTypes = parent.getExtension().getKind().getProperties().getChildTypes();
            return childTypes.makeList(parent.getChildExpressions(), parent.getChildPredicates());
        }
    }

    public static class UnminusParser
    extends AbstractNudParser<Expression> {
        public UnminusParser(int kind) {
            super(kind, 764);
        }

        @Override
        public IParserPrinter.SubParseResult<Expression> nud(ParserContext pc) throws GenParser.SyntaxError {
            int minusPos = pc.t.pos;
            pc.accept(this.kind);
            Expression expr = pc.subParse(MainParsers.EXPR_PARSER, true);
            SourceLocation loc = pc.getSourceLocation();
            if (expr instanceof IntegerLiteral && expr.getSourceLocation().getStart() == minusPos + 1) {
                IntegerLiteral lit = (IntegerLiteral)expr;
                IntegerLiteral result = pc.factory.makeIntegerLiteral(lit.getValue().negate(), loc);
                return new IParserPrinter.SubParseResult<Expression>(result, pc.getGrammar().getKind(AbstractGrammar.DefaultToken.INT_LIT));
            }
            UnaryExpression result = pc.factory.makeUnaryExpression(764, expr, loc);
            return new IParserPrinter.SubParseResult<Expression>(result, this.kind);
        }

        @Override
        public void toString(IToStringMediator mediator, Expression toPrint) {
            boolean parenthesize;
            mediator.appendImage(this.kind, false);
            Expression child = ((UnaryExpression)toPrint).getChild();
            boolean bl = parenthesize = child.getTag() == 4;
            if (parenthesize) {
                mediator.subPrintWithPar(child);
            } else {
                mediator.subPrint(child, true);
            }
        }
    }

    public static class FiniteParser
    extends ParenNudFormulaChildParser<SimplePredicate, Expression> {
        public FiniteParser(int kind) {
            super(kind, 620, MainParsers.EXPR_PARSER);
        }

        @Override
        protected SimplePredicate makeValue(FormulaFactory factory, Expression child, SourceLocation loc) {
            return factory.makeSimplePredicate(this.tag, child, loc);
        }

        @Override
        protected Expression getChild(SimplePredicate parent) {
            return parent.getExpression();
        }
    }

    public static class MultiplePredicateParser
    extends ParenNudParser<MultiplePredicate, List<Expression>> {
        public MultiplePredicateParser(int kind) {
            super(kind, 901, MainParsers.EXPR_LIST_PARSER);
        }

        @Override
        protected MultiplePredicate makeValue(FormulaFactory factory, List<Expression> child, SourceLocation loc) {
            return factory.makeMultiplePredicate(this.tag, child, loc);
        }

        @Override
        protected List<Expression> getChild(MultiplePredicate parent) {
            return Arrays.asList(parent.getChildren());
        }
    }

    public static class CSetLambda
    extends QuantifiedParser<QuantifiedExpression> {
        public CSetLambda(int kind) {
            super(kind, 803, false);
        }

        @Override
        public QuantifiedExpression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            MainParsers.PatternParser pattParser = new MainParsers.PatternParser(pc.result);
            Pattern pattern = pc.subParseNoBindingNoCheck(pattParser);
            int dot = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.DOT);
            pc.accept(dot);
            List<BoundIdentDecl> boundDecls = pattern.getDecls();
            Predicate pred = pc.subParseNoParentNoCheck(MainParsers.PRED_PARSER, boundDecls);
            int mid = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.MID);
            pc.accept(mid);
            Expression expr = pc.subParseNoParentNoCheck(MainParsers.EXPR_PARSER, boundDecls);
            BinaryExpression pair = pc.factory.makeBinaryExpression(201, pattern.getPattern(), expr, null);
            return pc.factory.makeQuantifiedExpression(this.tag, boundDecls, pred, (Expression)pair, pc.getSourceLocation(), QuantifiedExpression.Form.Lambda);
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedExpression toPrint) {
            super.toString(mediator, toPrint);
            Expression child = toPrint.getExpression();
            assert (child.getTag() == 201);
            BinaryExpression pair = (BinaryExpression)child;
            Expression pattern = pair.getLeft();
            BoundIdentDecl[] bids = toPrint.getBoundIdentDecls();
            String[] localNames = this.getLocalNames();
            MainParsers.PatternParser.appendPattern(mediator, pattern, bids, localNames);
            mediator.append(AbstractGrammar.DefaultToken.DOT);
            mediator.subPrintNoPar(toPrint.getPredicate(), false, localNames);
            mediator.append(AbstractGrammar.DefaultToken.MID);
            mediator.subPrintNoPar(pair.getRight(), false, localNames);
        }
    }

    public static class CSetImplicit
    extends ImplicitQuantExpr {
        public CSetImplicit(int kind) {
            super(kind, 803, true);
        }

        @Override
        protected void acceptClose(ParserContext pc) throws GenParser.SyntaxError {
            int rbrace = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.RBRACE);
            pc.accept(rbrace);
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedExpression toPrint) {
            super.toString(mediator, toPrint);
            mediator.append(AbstractGrammar.DefaultToken.RBRACE);
        }
    }

    public static class ImplicitQuantExpr
    extends QuantifiedParser<QuantifiedExpression> {
        public ImplicitQuantExpr(int kind, int tag) {
            this(kind, tag, false);
        }

        protected ImplicitQuantExpr(int kind, int tag, boolean closed) {
            super(kind, tag, closed);
        }

        @Override
        protected final QuantifiedExpression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            Expression expr = pc.subParseNoBindingNoCheck(MainParsers.EXPR_PARSER);
            int mid = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.MID);
            pc.accept(mid);
            ArrayList<BoundIdentDecl> boundIdents = new ArrayList<BoundIdentDecl>();
            Expression boundExpr = (Expression)expr.bindAllFreeIdents(boundIdents);
            if (boundIdents.isEmpty()) {
                throw pc.syntaxError(new ASTProblem(expr.getSourceLocation(), ProblemKind.ExpressionNotBinding, 1, new Object[0]));
            }
            Predicate pred = pc.subParseNoParentNoCheck(MainParsers.PRED_PARSER, boundIdents);
            this.acceptClose(pc);
            return pc.factory.makeQuantifiedExpression(this.tag, boundIdents, pred, boundExpr, pc.getSourceLocation(), QuantifiedExpression.Form.Implicit);
        }

        protected void acceptClose(ParserContext pc) throws GenParser.SyntaxError {
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedExpression toPrint) {
            super.toString(mediator, toPrint);
            mediator.subPrintNoPar(toPrint.getExpression(), false, this.getLocalNames());
            mediator.append(AbstractGrammar.DefaultToken.MID);
            mediator.subPrintNoPar(toPrint.getPredicate(), false, this.getLocalNames());
        }
    }

    public static class CSetExplicit
    extends ExplicitQuantExpr {
        public CSetExplicit(int kind) {
            super(kind, 803, true);
        }

        @Override
        protected void acceptClose(ParserContext pc) throws GenParser.SyntaxError {
            int rbrace = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.RBRACE);
            pc.accept(rbrace);
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedExpression toPrint) {
            super.toString(mediator, toPrint);
            mediator.append(AbstractGrammar.DefaultToken.RBRACE);
        }
    }

    public static class ExplicitQuantExpr
    extends QuantifiedParser<QuantifiedExpression> {
        public ExplicitQuantExpr(int kind, int tag) {
            this(kind, tag, false);
        }

        protected ExplicitQuantExpr(int kind, int tag, boolean closed) {
            super(kind, tag, closed);
        }

        @Override
        protected QuantifiedExpression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            List<BoundIdentDecl> boundIdents = pc.subParseNoBindingNoCheck(MainParsers.BOUND_IDENT_DECL_LIST_PARSER);
            int dot = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.DOT);
            pc.accept(dot);
            Predicate pred = pc.subParseNoParentNoCheck(MainParsers.PRED_PARSER, boundIdents);
            int mid = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.MID);
            pc.accept(mid);
            Expression expr = pc.subParseNoParentNoCheck(MainParsers.EXPR_PARSER, boundIdents);
            this.acceptClose(pc);
            return pc.factory.makeQuantifiedExpression(this.tag, boundIdents, pred, expr, pc.getSourceLocation(), QuantifiedExpression.Form.Explicit);
        }

        protected void acceptClose(ParserContext pc) throws GenParser.SyntaxError {
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedExpression toPrint) {
            super.toString(mediator, toPrint);
            BoundIdentDecl[] boundDecls = toPrint.getBoundIdentDecls();
            this.printBoundIdentDecls(mediator, boundDecls);
            mediator.append(AbstractGrammar.DefaultToken.DOT);
            mediator.subPrintNoPar(toPrint.getPredicate(), false, this.getLocalNames());
            mediator.append(AbstractGrammar.DefaultToken.MID);
            mediator.subPrintNoPar(toPrint.getExpression(), false, this.getLocalNames());
        }
    }

    static abstract class QuantifiedParser<R>
    extends PrefixNudParser<R>
    implements IQuantifiedParser<R> {
        private String[] localNames = null;

        protected QuantifiedParser(int kind, int tag, boolean closed) {
            super(kind, tag, closed);
        }

        @Override
        public void setLocalNames(String[] localNames) {
            this.localNames = localNames;
        }

        protected String[] getLocalNames() {
            assert (this.localNames != null);
            return this.localNames;
        }

        protected void printBoundIdentDecls(IToStringMediator mediator, BoundIdentDecl[] boundDecls) {
            MainParsers.BoundIdentDeclListParser.toString(mediator, boundDecls, this.getLocalNames());
        }
    }

    public static interface IQuantifiedParser<R>
    extends INudParser<R> {
        public void setLocalNames(String[] var1);
    }

    public static final class SetExtParser
    extends PrefixNudParser<SetExtension> {
        public SetExtParser(int kind) {
            super(kind, 5, true);
        }

        @Override
        public SetExtension parseRight(ParserContext pc) throws GenParser.SyntaxError {
            int rbrace = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.RBRACE);
            List exprs = pc.t.kind == rbrace ? Collections.emptyList() : (List)((Object)pc.subParseNoCheck(MainParsers.EXPR_LIST_PARSER));
            pc.accept(rbrace);
            return pc.factory.makeSetExtension(exprs, pc.getSourceLocation());
        }

        @Override
        public void toString(IToStringMediator mediator, SetExtension toPrint) {
            super.toString(mediator, toPrint);
            Expression[] members = toPrint.getMembers();
            if (members.length > 0) {
                MainParsers.EXPR_LIST_PARSER.toString(mediator, Arrays.asList(members));
            }
            mediator.append(AbstractGrammar.DefaultToken.RBRACE);
        }
    }

    public static class KBoolParser
    extends ParenNudFormulaChildParser<BoolExpression, Predicate> {
        public KBoolParser(int kind) {
            super(kind, 601, MainParsers.PRED_PARSER);
        }

        @Override
        protected BoolExpression makeValue(FormulaFactory factory, Predicate child, SourceLocation loc) {
            return factory.makeBoolExpression(child, loc);
        }

        @Override
        protected Predicate getChild(BoolExpression parent) {
            return parent.getPredicate();
        }
    }

    public static class ConverseParser
    extends BinaryLedExprParser<UnaryExpression> {
        public ConverseParser(int kind) {
            super(kind, 763);
        }

        @Override
        protected UnaryExpression makeValue(FormulaFactory factory, Expression left, Expression right, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeUnaryExpression(this.tag, left, loc);
        }

        @Override
        protected Expression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            return null;
        }

        @Override
        protected Expression getLeft(UnaryExpression parent) {
            return parent.getChild();
        }

        @Override
        protected Expression getRight(UnaryExpression parent) {
            return null;
        }
    }

    public static class UnaryExpressionParser
    extends ParenNudFormulaChildParser<UnaryExpression, Expression> {
        public UnaryExpressionParser(int kind, int tag) {
            super(kind, tag, MainParsers.EXPR_PARSER);
        }

        @Override
        protected UnaryExpression makeValue(FormulaFactory factory, Expression child, SourceLocation loc) {
            return factory.makeUnaryExpression(this.tag, child, loc);
        }

        @Override
        protected Expression getChild(UnaryExpression parent) {
            return parent.getChild();
        }
    }

    public static class QuantifiedPredicateParser
    extends QuantifiedParser<QuantifiedPredicate> {
        public QuantifiedPredicateParser(int kind, int tag) {
            super(kind, tag, false);
        }

        @Override
        public QuantifiedPredicate parseRight(ParserContext pc) throws GenParser.SyntaxError {
            List<BoundIdentDecl> boundIdentifiers = pc.subParseNoBindingNoCheck(MainParsers.BOUND_IDENT_DECL_LIST_PARSER);
            int dot = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.DOT);
            pc.accept(dot);
            Predicate pred = pc.subParseNoParentNoCheck(MainParsers.PRED_PARSER, boundIdentifiers);
            return pc.factory.makeQuantifiedPredicate(this.tag, boundIdentifiers, pred, pc.getSourceLocation());
        }

        @Override
        public void toString(IToStringMediator mediator, QuantifiedPredicate toPrint) {
            super.toString(mediator, toPrint);
            BoundIdentDecl[] boundDecls = toPrint.getBoundIdentDecls();
            this.printBoundIdentDecls(mediator, boundDecls);
            mediator.append(AbstractGrammar.DefaultToken.DOT);
            mediator.subPrintNoPar(toPrint.getPredicate(), false, this.getLocalNames());
        }
    }

    public static class BinaryPredicateParser
    extends BinaryLedPredParser<BinaryPredicate> {
        public BinaryPredicateParser(int kind, int tag) {
            super(kind, tag);
        }

        @Override
        protected BinaryPredicate makeValue(FormulaFactory factory, Predicate left, Predicate right, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeBinaryPredicate(this.tag, left, right, loc);
        }

        @Override
        protected Predicate getLeft(BinaryPredicate parent) {
            return parent.getLeft();
        }

        @Override
        protected Predicate getRight(BinaryPredicate parent) {
            return parent.getRight();
        }
    }

    public static class UnaryPredicateParser
    extends PrefixNudParser<UnaryPredicate> {
        public UnaryPredicateParser(int kind, int tag, boolean closed) {
            super(kind, tag, closed);
        }

        @Override
        protected UnaryPredicate parseRight(ParserContext pc) throws GenParser.SyntaxError {
            Predicate pred = pc.subParse(MainParsers.PRED_PARSER, false);
            return pc.factory.makeUnaryPredicate(this.tag, pred, pc.getSourceLocation());
        }

        @Override
        public void toString(IToStringMediator mediator, UnaryPredicate toPrint) {
            super.toString(mediator, toPrint);
            Predicate child = toPrint.getChild();
            mediator.subPrint(child, false);
        }
    }

    public static class LiteralPredicateParser
    extends PrefixNudParser<LiteralPredicate> {
        public LiteralPredicateParser(int kind, int tag) {
            super(kind, tag, true);
        }

        @Override
        protected LiteralPredicate parseRight(ParserContext pc) throws GenParser.SyntaxError {
            return pc.factory.makeLiteralPredicate(this.tag, pc.getSourceLocation());
        }
    }

    public static abstract class LedImage
    extends BinaryLedExprParser<BinaryExpression> {
        public LedImage(int kind, int tag) {
            super(kind, tag);
        }

        protected abstract int getCloseKind(AbstractGrammar var1);

        @Override
        protected Expression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            Expression right = (Expression)pc.subParseNoCheck(this.childParser);
            int closeKind = this.getCloseKind(pc.getGrammar());
            pc.accept(closeKind);
            return right;
        }

        @Override
        protected BinaryExpression makeValue(FormulaFactory factory, Expression left, Expression right, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeBinaryExpression(this.tag, left, right, loc);
        }

        @Override
        protected Expression getRight(BinaryExpression parent) {
            return parent.getRight();
        }

        @Override
        protected Expression getLeft(BinaryExpression parent) {
            return parent.getLeft();
        }

        @Override
        protected void subPrintRight(IToStringMediator mediator, Expression right) {
            mediator.subPrintNoPar(right, false, NO_DECL);
        }

        @Override
        public void toString(IToStringMediator mediator, BinaryExpression toPrint) {
            super.toString(mediator, toPrint);
            int closeKind = this.getCloseKind(mediator.getGrammar());
            mediator.appendImage(closeKind);
        }
    }

    public static class RelationalPredicateInfix
    extends BinaryLedExprParser<RelationalPredicate> {
        public RelationalPredicateInfix(int kind, int tag) {
            super(kind, tag);
        }

        @Override
        protected RelationalPredicate makeValue(FormulaFactory factory, Expression left, Expression right, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeRelationalPredicate(this.tag, left, right, loc);
        }

        @Override
        protected Expression getLeft(RelationalPredicate parent) {
            return parent.getLeft();
        }

        @Override
        protected Expression getRight(RelationalPredicate parent) {
            return parent.getRight();
        }
    }

    public static class AssociativePredicateInfix
    extends AssociativeLedParser<AssociativePredicate, Predicate> {
        public AssociativePredicateInfix(int kind, int tag) {
            super(kind, tag, MainParsers.PRED_PARSER);
        }

        @Override
        protected Predicate asChildType(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            return MainParsers.asPredicate(left, pc);
        }

        @Override
        protected AssociativePredicate makeResult(FormulaFactory factory, List<Predicate> children, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeAssociativePredicate(this.tag, children, loc);
        }

        protected Predicate[] getChildren(AssociativePredicate parent) {
            return parent.getChildren();
        }
    }

    public static class ExtendedAssociativeExpressionInfix
    extends AssociativeLedParser<ExtendedExpression, Expression> {
        public ExtendedAssociativeExpressionInfix(int kind, int tag) {
            super(kind, tag, MainParsers.EXPR_PARSER);
        }

        @Override
        protected void checkResult(ParserContext pc, List<Expression> children) throws GenParser.SyntaxError {
            EXTENDED_EXPR.check(pc, this.tag, children);
        }

        @Override
        protected ExtendedExpression makeResult(FormulaFactory factory, List<Expression> children, SourceLocation loc) throws GenParser.SyntaxError {
            return EXTENDED_EXPR.make(factory, this.tag, children, loc);
        }

        @Override
        protected Expression asChildType(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            return MainParsers.asExpression(left, pc);
        }

        protected Expression[] getChildren(ExtendedExpression parent) {
            return parent.getChildExpressions();
        }
    }

    public static class AssociativeExpressionInfix
    extends AssociativeLedParser<AssociativeExpression, Expression> {
        public AssociativeExpressionInfix(int kind, int tag) {
            super(kind, tag, MainParsers.EXPR_PARSER);
        }

        @Override
        protected AssociativeExpression makeResult(FormulaFactory factory, List<Expression> children, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeAssociativeExpression(this.tag, children, loc);
        }

        @Override
        protected Expression asChildType(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            return MainParsers.asExpression(left, pc);
        }

        protected Expression[] getChildren(AssociativeExpression parent) {
            return parent.getChildren();
        }
    }

    public static class ExtendedBinaryExpressionInfix
    extends BinaryLedExprParser<ExtendedExpression> {
        public ExtendedBinaryExpressionInfix(int kind, int tag) {
            super(kind, tag);
        }

        @Override
        protected void checkValue(ParserContext pc, Expression left, Expression right) throws GenParser.SyntaxError {
            EXTENDED_EXPR.check(pc, this.tag, Arrays.asList(left, right));
        }

        @Override
        protected ExtendedExpression makeValue(FormulaFactory factory, Expression left, Expression right, SourceLocation loc) throws GenParser.SyntaxError {
            return EXTENDED_EXPR.make(factory, this.tag, Arrays.asList(left, right), loc);
        }

        @Override
        protected Expression getLeft(ExtendedExpression parent) {
            return parent.getChildExpressions()[0];
        }

        @Override
        protected Expression getRight(ExtendedExpression parent) {
            return parent.getChildExpressions()[1];
        }
    }

    public static class BinaryExpressionInfix
    extends BinaryLedExprParser<BinaryExpression> {
        public BinaryExpressionInfix(int kind, int tag) {
            super(kind, tag);
        }

        @Override
        protected BinaryExpression makeValue(FormulaFactory factory, Expression left, Expression right, SourceLocation loc) throws GenParser.SyntaxError {
            return factory.makeBinaryExpression(this.tag, left, right, loc);
        }

        @Override
        protected Expression getLeft(BinaryExpression parent) {
            return parent.getLeft();
        }

        @Override
        protected Expression getRight(BinaryExpression parent) {
            return parent.getRight();
        }
    }

    public static class ExtendedAtomicExpressionParser
    extends PrefixNudParser<ExtendedExpression> {
        public ExtendedAtomicExpressionParser(int kind, int tag) {
            super(kind, tag, true);
        }

        @Override
        protected ExtendedExpression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            EXTENDED_EXPR.check(pc, this.tag, Collections.emptyList());
            return EXTENDED_EXPR.make(pc.factory, this.tag, Collections.emptyList(), pc.getSourceLocation());
        }
    }

    public static class AtomicExpressionParser
    extends PrefixNudParser<AtomicExpression> {
        public AtomicExpressionParser(int kind, int tag) {
            super(kind, tag, true);
        }

        @Override
        protected AtomicExpression parseRight(ParserContext pc) throws GenParser.SyntaxError {
            return pc.factory.makeAtomicExpression(this.tag, pc.getSourceLocation());
        }
    }

    public static class OftypeParser
    implements ILedParser<Expression> {
        private static final String POW_ALPHA = "\u2119(alpha)";
        private static final String POW_ALPHA_ALPHA = "\u2119(alpha \u00d7 alpha)";
        private static final String POW_ALPHA_BETA_ALPHA = "\u2119(alpha \u00d7 beta \u00d7 alpha)";
        private static final String POW_ALPHA_BETA_BETA = "\u2119(alpha \u00d7 beta \u00d7 beta)";
        private static final String EXTENSION_TYPE = "[see operator definition]";

        @Override
        public IParserPrinter.SubParseResult<Expression> led(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            Expression result;
            if (!OftypeParser.isTypedGeneric(left)) {
                throw pc.syntaxError(this.newUnexpectedOftype(pc));
            }
            int oftype = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.OFTYPE);
            pc.accept(oftype);
            Type type = pc.subParse(MainParsers.TYPE_PARSER, true);
            SourceLocation typeLoc = pc.getSourceLocation();
            if (!OftypeParser.checkValidTypedGeneric(left, type, typeLoc, pc.result)) {
                type = null;
            }
            SourceLocation sourceLoc = pc.getEnclosingSourceLocation();
            if (left instanceof ExtendedExpression) {
                ExtendedExpression extExpr = (ExtendedExpression)left;
                result = pc.factory.makeExtendedExpression(extExpr.getExtension(), extExpr.getChildExpressions(), extExpr.getChildPredicates(), sourceLoc, type);
            } else {
                result = pc.factory.makeAtomicExpression(left.getTag(), sourceLoc, type);
            }
            return new IParserPrinter.SubParseResult<Expression>(result, oftype);
        }

        private static boolean isTypedGeneric(Formula<?> formula) {
            switch (formula.getTag()) {
                case 407: 
                case 410: 
                case 411: 
                case 412: {
                    return true;
                }
            }
            if (formula instanceof ExtendedExpression) {
                return ((ExtendedExpression)formula).isAtomic();
            }
            return false;
        }

        private ASTProblem newUnexpectedOftype(ParserContext pc) {
            return new ASTProblem(pc.makeSourceLocation(pc.t), ProblemKind.UnexpectedOftype, 1, new Object[0]);
        }

        private static boolean checkValidTypedGeneric(Formula<?> formula, Type type, SourceLocation typeLoc, ParseResult result) throws GenParser.SyntaxError {
            ExtendedExpression extExpr;
            switch (formula.getTag()) {
                case 407: {
                    if (type instanceof PowerSetType) break;
                    result.addProblem(OftypeParser.newInvalidGenType(typeLoc, POW_ALPHA));
                    return false;
                }
                case 412: {
                    Type source = type.getSource();
                    if (source != null && source.equals(type.getTarget())) break;
                    result.addProblem(OftypeParser.newInvalidGenType(typeLoc, POW_ALPHA_ALPHA));
                    return false;
                }
                case 410: {
                    if (OftypeParser.isValidPrjType(type, true)) break;
                    result.addProblem(OftypeParser.newInvalidGenType(typeLoc, POW_ALPHA_BETA_ALPHA));
                    return false;
                }
                case 411: {
                    if (OftypeParser.isValidPrjType(type, false)) break;
                    result.addProblem(OftypeParser.newInvalidGenType(typeLoc, POW_ALPHA_BETA_BETA));
                    return false;
                }
            }
            if (formula instanceof ExtendedExpression && !(extExpr = (ExtendedExpression)formula).isValidType(type)) {
                result.addProblem(OftypeParser.newInvalidGenType(typeLoc, EXTENSION_TYPE));
                return false;
            }
            return true;
        }

        private static ASTProblem newInvalidGenType(SourceLocation loc, String expected) {
            return new ASTProblem(loc, ProblemKind.InvalidGenericType, 1, expected);
        }

        private static boolean isValidPrjType(Type type, boolean left) {
            Type source = type.getSource();
            Type target = type.getTarget();
            if (!(source instanceof ProductType)) {
                return false;
            }
            ProductType prodSource = (ProductType)source;
            Type child = left ? prodSource.getLeft() : prodSource.getRight();
            return target.equals(child);
        }

        @Override
        public void toString(IToStringMediator mediator, Expression toPrint) {
            mediator.subPrint(toPrint, false, NO_DECL, false);
            OftypeParser.appendOftype(mediator, toPrint.getType(), true);
        }

        public static void appendOftype(IToStringMediator mediator, Type type, boolean withSpaces) {
            int oftype = mediator.getGrammar().getKind(AbstractGrammar.DefaultToken.OFTYPE);
            mediator.appendImage(oftype, withSpaces);
            mediator.append(type.toString());
        }
    }

    public static class IntLitSubParser
    extends ValuedNudParser<IntegerLiteral> {
        @Override
        protected int getKind(AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.INT_LIT);
        }

        @Override
        protected IntegerLiteral makeValue(ParserContext pc, String tokenVal, SourceLocation loc) throws GenParser.SyntaxError {
            try {
                BigInteger value = new BigInteger(tokenVal);
                return pc.factory.makeIntegerLiteral(value, loc);
            }
            catch (NumberFormatException e) {
                throw pc.syntaxError(new ASTProblem(loc, ProblemKind.IntegerLiteralExpected, 1, new Object[0]));
            }
        }

        @Override
        public void toString(IToStringMediator mediator, IntegerLiteral toPrint) {
            BigInteger literal = toPrint.getValue();
            this.toStringInternal(mediator, literal);
        }

        private void toStringInternal(IToStringMediator mediator, BigInteger literal) {
            String image = literal.toString();
            if (image.charAt(0) == '-') {
                mediator.append("\u2212");
                mediator.append(image.substring(1));
            } else {
                mediator.append(image);
            }
        }
    }

    public static class BoundIdentDeclSubParser
    extends ValuedNudParser<BoundIdentDecl> {
        @Override
        protected int getKind(AbstractGrammar grammar) {
            return grammar.getKind(AbstractGrammar.DefaultToken.IDENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected BoundIdentDecl makeValue(ParserContext pc, String tokenVal, SourceLocation loc) throws GenParser.SyntaxError {
            Type type = null;
            int oftype = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.OFTYPE);
            if (pc.t.kind == oftype) {
                pc.pushParentKind();
                pc.accept(oftype);
                try {
                    type = pc.subParse(MainParsers.TYPE_PARSER, true);
                }
                finally {
                    pc.popParentKind();
                }
            }
            return pc.factory.makeBoundIdentDecl(tokenVal, pc.getSourceLocation(), type);
        }

        @Override
        public void toString(IToStringMediator mediator, BoundIdentDecl toPrint) {
            mediator.append(toPrint.getName());
            if (mediator.isWithTypes() && toPrint.isTypeChecked()) {
                OftypeParser.appendOftype(mediator, toPrint.getType(), false);
            }
        }

        public static void printIdent(IToStringMediator mediator, BoundIdentDecl[] decls, String[] resolvedIdents, int index) {
            mediator.append(resolvedIdents[index]);
            if (mediator.isWithTypes() && decls[index].isTypeChecked()) {
                OftypeParser.appendOftype(mediator, decls[index].getType(), false);
            }
        }
    }

    private static abstract class AssociativeLedParser<R, C extends Formula<?>>
    extends AbstractLedParser<R> {
        private final INudParser<C> childParser;

        protected AssociativeLedParser(int kind, int tag, INudParser<C> childParser) {
            super(kind, tag);
            this.childParser = childParser;
        }

        @Override
        public IParserPrinter.SubParseResult<R> led(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            C typedLeft = this.asChildType(left, pc);
            ArrayList<Object> children = new ArrayList<Object>();
            children.add(typedLeft);
            do {
                pc.accept(this.kind);
                Formula next = (Formula)pc.subParse(this.childParser, true);
                children.add(next);
            } while (pc.t.kind == this.kind);
            return this.checkAndMakeResult(pc, children);
        }

        private IParserPrinter.SubParseResult<R> checkAndMakeResult(ParserContext pc, List<C> children) throws GenParser.SyntaxError {
            this.checkResult(pc, children);
            R result = this.makeResult(pc.factory, children, pc.getSourceLocation());
            return new IParserPrinter.SubParseResult<R>(result, this.kind);
        }

        protected void checkResult(ParserContext pc, List<C> children) throws GenParser.SyntaxError {
        }

        protected abstract C[] getChildren(R var1);

        @Override
        public void toString(IToStringMediator mediator, R toPrint) {
            Formula[] children = this.getChildren(toPrint);
            mediator.subPrint(children[0], false);
            for (int i = 1; i < children.length; ++i) {
                mediator.appendImage(this.kind);
                mediator.subPrint(children[i], true);
            }
        }

        protected abstract C asChildType(Formula<?> var1, ParserContext var2) throws GenParser.SyntaxError;

        protected abstract R makeResult(FormulaFactory var1, List<C> var2, SourceLocation var3) throws GenParser.SyntaxError;
    }

    private static abstract class BinaryLedPredParser<R>
    extends BinaryLedParser<R, Predicate> {
        protected BinaryLedPredParser(int kind, int tag) {
            super(kind, tag, MainParsers.PRED_PARSER);
        }

        @Override
        protected Predicate asLeftType(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            return MainParsers.asPredicate(left, pc);
        }
    }

    private static abstract class BinaryLedExprParser<R>
    extends BinaryLedParser<R, Expression> {
        protected BinaryLedExprParser(int kind, int tag) {
            super(kind, tag, MainParsers.EXPR_PARSER);
        }

        @Override
        protected final Expression asLeftType(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            return MainParsers.asExpression(left, pc);
        }
    }

    private static abstract class BinaryLedParser<R, C extends Formula<?>>
    extends AbstractLedParser<R> {
        protected final INudParser<C> childParser;

        protected BinaryLedParser(int kind, int tag, INudParser<C> rightParser) {
            super(kind, tag);
            this.childParser = rightParser;
        }

        protected C parseRight(ParserContext pc) throws GenParser.SyntaxError {
            return (C)((Formula)pc.subParse(this.childParser, true));
        }

        protected abstract C getLeft(R var1);

        protected abstract C getRight(R var1);

        @Override
        public final IParserPrinter.SubParseResult<R> led(Formula<?> left, ParserContext pc) throws GenParser.SyntaxError {
            pc.accept(this.kind);
            C typedLeft = this.asLeftType(left, pc);
            C right = this.parseRight(pc);
            return this.checkAndMakeResult(pc, typedLeft, right);
        }

        private IParserPrinter.SubParseResult<R> checkAndMakeResult(ParserContext pc, C typedLeft, C right) throws GenParser.SyntaxError {
            this.checkValue(pc, typedLeft, right);
            R value = this.makeValue(pc.factory, typedLeft, right, pc.getSourceLocation());
            return new IParserPrinter.SubParseResult<R>(value, this.kind);
        }

        @Override
        public void toString(IToStringMediator mediator, R toPrint) {
            C left = this.getLeft(toPrint);
            mediator.subPrint((Formula<?>)left, false);
            mediator.appendImage(this.kind);
            C right = this.getRight(toPrint);
            if (right != null) {
                this.subPrintRight(mediator, right);
            }
        }

        protected void subPrintRight(IToStringMediator mediator, C right) {
            mediator.subPrint((Formula<?>)right, true);
        }

        protected abstract C asLeftType(Formula<?> var1, ParserContext var2) throws GenParser.SyntaxError;

        protected void checkValue(ParserContext pc, C left, C right) throws GenParser.SyntaxError {
        }

        protected abstract R makeValue(FormulaFactory var1, C var2, C var3, SourceLocation var4) throws GenParser.SyntaxError;
    }

    private static abstract class ValuedNudParser<R>
    implements INudParser<R> {
        @Override
        public final IParserPrinter.SubParseResult<R> nud(ParserContext pc) throws GenParser.SyntaxError {
            String tokenVal = pc.t.val;
            int kind = this.getKind(pc.getGrammar());
            pc.accept(kind);
            SourceLocation loc = pc.getSourceLocation();
            R value = this.makeValue(pc, tokenVal, loc);
            return new IParserPrinter.SubParseResult<R>(value, kind, true);
        }

        protected abstract int getKind(AbstractGrammar var1);

        protected abstract R makeValue(ParserContext var1, String var2, SourceLocation var3) throws GenParser.SyntaxError;
    }

    private static abstract class ParenNudFormulaChildParser<R, C extends Formula<?>>
    extends ParenNudParser<R, C> {
        protected ParenNudFormulaChildParser(int kind, int tag, INudParser<C> childParser) {
            super(kind, tag, childParser);
        }

        @Override
        protected void printChild(IToStringMediator mediator, C child) {
            mediator.subPrintNoPar((Formula<?>)child, true, NO_DECL);
        }
    }

    private static abstract class ParenNudParser<R, C>
    extends PrefixNudParser<R> {
        private final INudParser<C> childParser;

        protected ParenNudParser(int kind, int tag, INudParser<C> childParser) {
            super(kind, tag, true);
            this.childParser = childParser;
        }

        @Override
        protected final R parseRight(ParserContext pc) throws GenParser.SyntaxError {
            pc.acceptOpenParen();
            C child = pc.subParseNoCheck(this.childParser);
            pc.acceptCloseParen();
            return this.checkAndMakeValue(pc, child);
        }

        private R checkAndMakeValue(ParserContext pc, C child) throws GenParser.SyntaxError {
            this.checkValue(pc, child);
            return this.makeValue(pc.factory, child, pc.getSourceLocation());
        }

        protected abstract C getChild(R var1);

        @Override
        public void toString(IToStringMediator mediator, R toPrint) {
            super.toString(mediator, toPrint);
            mediator.append("(");
            C child = this.getChild(toPrint);
            this.printChild(mediator, child);
            mediator.append(")");
        }

        protected void printChild(IToStringMediator mediator, C child) {
            this.childParser.toString(mediator, child);
        }

        protected void checkValue(ParserContext pc, C child) throws GenParser.SyntaxError {
        }

        protected abstract R makeValue(FormulaFactory var1, C var2, SourceLocation var3) throws GenParser.SyntaxError;
    }

    private static abstract class PrefixNudParser<R>
    extends AbstractNudParser<R> {
        private final boolean closed;

        protected PrefixNudParser(int kind, int tag, boolean closed) {
            super(kind, tag);
            this.closed = closed;
        }

        @Override
        public final IParserPrinter.SubParseResult<R> nud(ParserContext pc) throws GenParser.SyntaxError {
            pc.accept(this.kind);
            R right = this.parseRight(pc);
            return new IParserPrinter.SubParseResult<R>(right, this.kind, this.closed);
        }

        protected abstract R parseRight(ParserContext var1) throws GenParser.SyntaxError;

        @Override
        public void toString(IToStringMediator mediator, R toPrint) {
            mediator.appendImage(this.kind);
        }
    }

    private static abstract class AbstractLedParser<R>
    extends AbstractSubParser
    implements ILedParser<R> {
        protected AbstractLedParser(int kind, int tag) {
            super(kind, tag);
        }
    }

    static abstract class AbstractNudParser<R>
    extends AbstractSubParser
    implements INudParser<R> {
        protected AbstractNudParser(int kind, int tag) {
            super(kind, tag);
        }
    }

    static abstract class AbstractSubParser {
        protected final int kind;
        protected final int tag;

        protected AbstractSubParser(int kind, int tag) {
            this.kind = kind;
            this.tag = tag;
        }

        public final int getKind() {
            return this.kind;
        }
    }
}

