/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.parser.ParseResult;

public class Pattern {
    private final ParseResult result;
    private final FormulaFactory ff;
    private final Set<String> names;
    private final List<BoundIdentDecl> decls;
    private final Stack<Expression> stack;
    private final List<FreeIdentifier> idents;

    public Pattern(ParseResult result) {
        this.result = result;
        this.ff = result.factory;
        this.names = new HashSet<String>();
        this.decls = new ArrayList<BoundIdentDecl>();
        this.stack = new Stack();
        this.idents = new ArrayList<FreeIdentifier>();
    }

    public void declParsed(BoundIdentDecl decl) {
        if (!this.names.add(decl.getName())) {
            this.result.addProblem(this.duplicateNameInPattern(decl));
            this.stack.push(this.ff.makeIntegerLiteral(BigInteger.ZERO, null));
            return;
        }
        this.decls.add(decl);
        FreeIdentifier ident = this.asFreeIdentifier(decl);
        this.idents.add(ident);
        this.stack.push(ident);
    }

    private FreeIdentifier asFreeIdentifier(BoundIdentDecl decl) {
        String name = decl.getName();
        Type type = decl.getType();
        SourceLocation loc = decl.getSourceLocation();
        return this.ff.makeFreeIdentifier(name, loc, type);
    }

    public void mapletParsed(SourceLocation loc) {
        Expression right = this.stack.pop();
        Expression left = this.stack.pop();
        this.stack.push(this.ff.makeBinaryExpression(201, left, right, loc));
    }

    public List<BoundIdentDecl> getDecls() {
        return this.decls;
    }

    public Expression getPattern() {
        assert (this.stack.size() == 1);
        Expression pattern = (Expression)this.stack.firstElement();
        return (Expression)pattern.bindTheseIdents(this.idents);
    }

    private ASTProblem duplicateNameInPattern(BoundIdentDecl decl) {
        return new ASTProblem(decl.getSourceLocation(), ProblemKind.DuplicateIdentifierInPattern, 1, decl.getName());
    }
}

