/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.AbstractResult;

public class ParseResult
extends AbstractResult
implements IParseResult {
    protected final FormulaFactory factory;
    private final Object origin;
    private Assignment assignment = null;
    private Expression expression = null;
    private Predicate predicate = null;
    private Type type = null;

    public ParseResult(FormulaFactory factory, Object origin) {
        this.factory = factory;
        this.origin = origin;
    }

    @Override
    public Assignment getParsedAssignment() {
        if (!this.isSuccess()) {
            return null;
        }
        return this.assignment;
    }

    @Override
    public Expression getParsedExpression() {
        if (!this.isSuccess()) {
            return null;
        }
        return this.expression;
    }

    @Override
    public Predicate getParsedPredicate() {
        if (!this.isSuccess()) {
            return null;
        }
        return this.predicate;
    }

    @Override
    public Type getParsedType() {
        if (!this.isSuccess()) {
            return null;
        }
        return this.type;
    }

    @Override
    public FormulaFactory getFormulaFactory() {
        return this.factory;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public void resetParsedFormula() {
        this.predicate = null;
        this.expression = null;
        this.assignment = null;
        this.type = null;
    }

    public void setParsedAssignment(Assignment formula) {
        this.assignment = formula;
    }

    public void setParsedExpression(Expression formula) {
        this.expression = formula;
    }

    public void setParsedPredicate(Predicate formula) {
        this.predicate = formula;
    }

    public void setParsedType(Type type) {
        this.type = type;
    }
}

