/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ILedParser;
import org.eventb.internal.core.parser.INudParser;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.ParseResult;
import org.eventb.internal.core.parser.ParserContext;
import org.eventb.internal.core.parser.Pattern;
import org.eventb.internal.core.parser.SubParsers;

public class MainParsers {
    private static final String AN_EXPRESSION = "an expression";
    private static final String A_PREDICATE = "a predicate";
    static final ParserApplier<List<INudParser<? extends Formula<?>>>> NUD_APPLIER = new ParserApplier<List<INudParser<? extends Formula<?>>>>(){

        @Override
        protected List<INudParser<? extends Formula<?>>> getParser(ParserContext pc) throws GenParser.SyntaxError {
            List<INudParser<Formula<?>>> subParsers = pc.getNudParsers();
            if (subParsers.isEmpty()) {
                ILedParser<? extends Formula<?>> ledParser = pc.getLedParser();
                if (ledParser == null) {
                    throw pc.syntaxError(1.newOperatorError(pc, ProblemKind.UnknownOperator));
                }
                throw pc.syntaxError(1.newOperatorError(pc, ProblemKind.MisplacedLedOperator));
            }
            return subParsers;
        }

        @Override
        protected IParserPrinter.SubParseResult<Formula<?>> apply(ParserContext pc, List<INudParser<? extends Formula<?>>> nudParsers, Formula<?> left) throws GenParser.SyntaxError {
            LinkedHashSet<ASTProblem> errors = new LinkedHashSet<ASTProblem>();
            Iterator<INudParser<Formula<?>>> iter = nudParsers.iterator();
            ParserContext.SavedContext savedContext = pc.save();
            while (iter.hasNext()) {
                INudParser<Formula<?>> nudParser = iter.next();
                try {
                    IParserPrinter.SubParseResult<Formula<?>> nudResult = nudParser.nud(pc);
                    return new IParserPrinter.SubParseResult(nudResult.getParsed(), nudResult.getKind(), nudResult.isClosed());
                }
                catch (GenParser.SyntaxError e) {
                    errors.add(pc.takeProblem());
                    pc.restore(savedContext);
                }
            }
            if (errors.size() == 1) {
                throw pc.syntaxError((ASTProblem)errors.iterator().next());
            }
            throw pc.syntaxError(1.newCompoundError(pc.makeSourceLocation(pc.t), errors));
        }
    };
    static final ParserApplier<ILedParser<? extends Formula<?>>> LED_APPLIER = new ParserApplier<ILedParser<? extends Formula<?>>>(){

        @Override
        protected ILedParser<? extends Formula<?>> getParser(ParserContext pc) throws GenParser.SyntaxError {
            ILedParser<? extends Formula<?>> subParser = pc.getLedParser();
            if (subParser == null) {
                List<INudParser<Formula<?>>> nudParsers = pc.getNudParsers();
                if (nudParsers.isEmpty()) {
                    throw pc.syntaxError(2.newOperatorError(pc, ProblemKind.UnknownOperator));
                }
                throw pc.syntaxError(2.newOperatorError(pc, ProblemKind.MisplacedNudOperator));
            }
            return subParser;
        }

        @Override
        protected IParserPrinter.SubParseResult<Formula<?>> apply(ParserContext pc, ILedParser<? extends Formula<?>> parser, Formula<?> left) throws GenParser.SyntaxError {
            IParserPrinter.SubParseResult<Formula<?>> ledResult = parser.led(left, pc);
            return new IParserPrinter.SubParseResult(ledResult.getParsed(), ledResult.getKind(), ledResult.isClosed());
        }
    };
    static final int[] NO_TAGS = new int[0];
    static final INudParser<? extends Formula<?>> FORMULA_PARSER = new INudParser<Formula<?>>(){

        @Override
        public IParserPrinter.SubParseResult<Formula<?>> nud(ParserContext pc) throws GenParser.SyntaxError {
            IParserPrinter.SubParseResult<Formula<?>> left = NUD_APPLIER.apply(pc, null);
            while (pc.giveProgressDirection() == GenParser.ProgressDirection.RIGHT) {
                left = LED_APPLIER.apply(pc, left.getParsed());
            }
            return left;
        }

        @Override
        public void toString(IToStringMediator mediator, Formula<?> toPrint) {
            mediator.forward(toPrint);
        }
    };
    static final INudParser<Type> TYPE_PARSER = new INudParser<Type>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IParserPrinter.SubParseResult<Type> nud(ParserContext pc) throws GenParser.SyntaxError {
            pc.startParsingType();
            try {
                IParserPrinter.SubParseResult<Expression> exprResult = pc.subParseRes(EXPR_PARSER, false);
                Expression expression = exprResult.getParsed();
                if (!expression.isATypeExpression()) {
                    throw pc.syntaxError(this.newInvalidTypeExpr(pc));
                }
                Type type = expression.toType();
                IParserPrinter.SubParseResult<Type> subParseResult = new IParserPrinter.SubParseResult<Type>(type, exprResult.getKind(), exprResult.isClosed());
                return subParseResult;
            }
            finally {
                pc.stopParsingType();
            }
        }

        private ASTProblem newInvalidTypeExpr(ParserContext pc) {
            return new ASTProblem(pc.getSourceLocation(), ProblemKind.InvalidTypeExpression, 1, new Object[0]);
        }

        @Override
        public void toString(IToStringMediator mediator, Type toPrint) {
            Expression expression = toPrint.toExpression();
            mediator.forward(expression);
        }
    };
    static final INudParser<Predicate> PRED_PARSER = new INudParser<Predicate>(){

        @Override
        public IParserPrinter.SubParseResult<Predicate> nud(ParserContext pc) throws GenParser.SyntaxError {
            IParserPrinter.SubParseResult<Formula<?>> formulaResult = FORMULA_PARSER.nud(pc);
            Predicate predicate = MainParsers.asPredicate(formulaResult.getParsed(), pc);
            return new IParserPrinter.SubParseResult<Predicate>(predicate, formulaResult.getKind(), formulaResult.isClosed());
        }

        @Override
        public void toString(IToStringMediator mediator, Predicate toPrint) {
            mediator.forward(toPrint);
        }
    };
    static final INudParser<Expression> EXPR_PARSER = new INudParser<Expression>(){

        @Override
        public IParserPrinter.SubParseResult<Expression> nud(ParserContext pc) throws GenParser.SyntaxError {
            IParserPrinter.SubParseResult<Formula<?>> formulaResult = FORMULA_PARSER.nud(pc);
            Expression expression = MainParsers.asExpression(formulaResult.getParsed(), pc);
            return new IParserPrinter.SubParseResult<Expression>(expression, formulaResult.getKind(), formulaResult.isClosed());
        }

        @Override
        public void toString(IToStringMediator mediator, Expression toPrint) {
            mediator.forward(toPrint);
        }
    };
    static final INudParser<Formula<?>> CLOSED_SUGAR = new INudParser<Formula<?>>(){

        @Override
        public IParserPrinter.SubParseResult<Formula<?>> nud(ParserContext pc) throws GenParser.SyntaxError {
            pc.acceptOpenParen();
            IParserPrinter.SubParseResult<Formula<?>> formula = pc.subParseNoCheckRes(FORMULA_PARSER);
            pc.acceptCloseParen();
            return new IParserPrinter.SubParseResult(formula.getParsed(), formula.getKind(), true);
        }

        @Override
        public void toString(IToStringMediator mediator, Formula<?> toPrint) {
            assert (false);
        }
    };
    public static final AbstListParser<Formula<?>> FORMULA_LIST_PARSER = new AbstListParser(FORMULA_PARSER);
    public static final AbstListParser<Expression> EXPR_LIST_PARSER = new AbstListParser<Expression>(EXPR_PARSER);
    public static final AbstListParser<Expression> SPACED_EXPR_LIST_PARSER = new AbstListParser<Expression>(EXPR_PARSER){

        @Override
        protected void appendSeparator(IToStringMediator mediator) {
            super.appendSeparator(mediator);
            mediator.append(" ");
        }
    };
    public static final AbstListParser<FreeIdentifier> FREE_IDENT_LIST_PARSER = new AbstListParser<FreeIdentifier>(SubParsers.FREE_IDENT_SUBPARSER);
    static final BoundIdentDeclListParser BOUND_IDENT_DECL_LIST_PARSER = new BoundIdentDeclListParser();
    public static final INudParser<Assignment> ASSIGNMENT_PARSER = new INudParser<Assignment>(){

        @Override
        public IParserPrinter.SubParseResult<Assignment> nud(ParserContext pc) throws GenParser.SyntaxError {
            INudParser<? extends Assignment> parser = this.getAssignmentParser(pc);
            IParserPrinter.SubParseResult<? extends Assignment> assignResult = pc.subParseRes(parser, false);
            return new IParserPrinter.SubParseResult<Assignment>(assignResult.getParsed(), assignResult.getKind());
        }

        private INudParser<? extends Assignment> getAssignmentParser(ParserContext pc) throws GenParser.SyntaxError {
            int becEqKind = pc.getKind(BecomesEqualTo.OP_BECEQ.getImage());
            if (pc.lookAheadFor(becEqKind)) {
                return new BecomesEqualToParser(becEqKind);
            }
            int becMoKind = pc.getKind(BecomesMemberOf.OP_BECMO.getImage());
            if (pc.lookAheadFor(becMoKind)) {
                return new BecomesMemberOfParser(becMoKind);
            }
            int becStKind = pc.getKind(BecomesSuchThat.OP_BECST.getImage());
            if (pc.lookAheadFor(becStKind)) {
                return new BecomesSuchThatParser(becStKind);
            }
            pc.scanUntilEOF();
            throw pc.syntaxError(new ASTProblem(pc.getEnclosingSourceLocation(), ProblemKind.UnknownOperator, 1, " (expected to find an assignment operator)"));
        }

        @Override
        public void toString(IToStringMediator mediator, Assignment toPrint) {
            mediator.forward(toPrint);
        }
    };

    private static ASTProblem makeUnexpectedKindProblem(Formula<?> formula, String expectedKind, String actualKind) {
        return new ASTProblem(formula.getSourceLocation(), ProblemKind.UnexpectedSubFormulaKind, 1, expectedKind, actualKind);
    }

    public static Predicate asPredicate(Formula<?> formula, ParserContext pc) throws GenParser.SyntaxError {
        if (!(formula instanceof Predicate)) {
            throw pc.syntaxError(MainParsers.makeUnexpectedKindProblem(formula, A_PREDICATE, AN_EXPRESSION));
        }
        return (Predicate)formula;
    }

    public static Expression asExpression(Formula<?> formula, ParserContext pc) throws GenParser.SyntaxError {
        if (!(formula instanceof Expression)) {
            throw pc.syntaxError(MainParsers.makeUnexpectedKindProblem(formula, AN_EXPRESSION, A_PREDICATE));
        }
        return (Expression)formula;
    }

    static List<BoundIdentDecl> makePrimedDecl(List<FreeIdentifier> lhsList, FormulaFactory factory) {
        ArrayList<BoundIdentDecl> decls = new ArrayList<BoundIdentDecl>(lhsList.size());
        for (FreeIdentifier ident : lhsList) {
            if (ident.isPrimed()) {
                decls.add(ident.asDecl());
                continue;
            }
            decls.add(ident.asPrimedDecl());
        }
        return decls;
    }

    static Expression makeFunctionOverriding(FreeIdentifier ident, Expression index, Expression value, FormulaFactory factory) {
        BinaryExpression pair = factory.makeBinaryExpression(201, index, value, null);
        SetExtension singletonSet = factory.makeSetExtension(pair, null);
        return factory.makeAssociativeExpression(305, new Expression[]{ident, singletonSet}, null);
    }

    public static class BecomesSuchThatParser
    extends SubParsers.AbstractNudParser<BecomesSuchThat> {
        public BecomesSuchThatParser(int kind) {
            super(kind, 8);
        }

        @Override
        public IParserPrinter.SubParseResult<BecomesSuchThat> nud(ParserContext pc) throws GenParser.SyntaxError {
            List idents = (List)((Object)pc.subParseNoCheck(FREE_IDENT_LIST_PARSER));
            assert (!idents.isEmpty());
            pc.accept(this.kind);
            List<BoundIdentDecl> primed = MainParsers.makePrimedDecl(idents, pc.factory);
            Predicate condition = pc.subParse(PRED_PARSER, primed, true);
            BecomesSuchThat bst = pc.factory.makeBecomesSuchThat(idents, primed, condition, pc.getSourceLocation());
            return new IParserPrinter.SubParseResult<BecomesSuchThat>(bst, this.kind);
        }

        @Override
        public void toString(IToStringMediator mediator, BecomesSuchThat toPrint) {
            FreeIdentifier[] idents = toPrint.getAssignedIdentifiers();
            FREE_IDENT_LIST_PARSER.toString(mediator, Arrays.asList(idents));
            mediator.appendImage(this.kind);
            Predicate condition = toPrint.getCondition();
            BoundIdentDecl[] primedIdents = toPrint.getPrimedIdents();
            mediator.subPrintNoPar(condition, true, BecomesSuchThatParser.toNames(primedIdents));
        }

        private static String[] toNames(BoundIdentDecl[] idents) {
            String[] names = new String[idents.length];
            for (int i = 0; i < idents.length; ++i) {
                names[i] = idents[i].getName();
            }
            return names;
        }
    }

    public static class BecomesMemberOfParser
    extends SubParsers.AbstractNudParser<BecomesMemberOf> {
        public BecomesMemberOfParser(int kind) {
            super(kind, 7);
        }

        @Override
        public IParserPrinter.SubParseResult<BecomesMemberOf> nud(ParserContext pc) throws GenParser.SyntaxError {
            FreeIdentifier ident = pc.subParse(SubParsers.FREE_IDENT_SUBPARSER, false);
            if (pc.t.kind == pc.getGrammar().getKind(AbstractGrammar.DefaultToken.COMMA)) {
                throw pc.syntaxError(new ASTProblem(pc.makeSourceLocation(pc.t), ProblemKind.BECMOAppliesToOneIdent, 1, new Object[0]));
            }
            pc.accept(this.kind);
            Expression expr = pc.subParseNoParentNoCheck(EXPR_PARSER, Collections.emptyList());
            BecomesMemberOf bmo = pc.factory.makeBecomesMemberOf(ident, expr, pc.getSourceLocation());
            return new IParserPrinter.SubParseResult<BecomesMemberOf>(bmo, this.kind);
        }

        @Override
        public void toString(IToStringMediator mediator, BecomesMemberOf toPrint) {
            FreeIdentifier[] idents = toPrint.getAssignedIdentifiers();
            FREE_IDENT_LIST_PARSER.toString(mediator, Arrays.asList(idents));
            mediator.appendImage(this.kind);
            Expression set = toPrint.getSet();
            EXPR_PARSER.toString(mediator, set);
        }
    }

    public static class BecomesEqualToParser
    extends SubParsers.AbstractNudParser<BecomesEqualTo> {
        public BecomesEqualToParser(int kind) {
            super(kind, 6);
        }

        @Override
        public IParserPrinter.SubParseResult<BecomesEqualTo> nud(ParserContext pc) throws GenParser.SyntaxError {
            List idents = (List)((Object)pc.subParseNoCheck(FREE_IDENT_LIST_PARSER));
            assert (!idents.isEmpty());
            Token tokenAfterIdents = pc.t;
            int tokenKind = tokenAfterIdents.kind;
            pc.accept(tokenKind);
            if (tokenKind == pc.getGrammar().getKind(AbstractGrammar.DefaultToken.LPAR)) {
                if (idents.size() != 1) {
                    throw pc.syntaxError(new ASTProblem(pc.getSourceLocation(), ProblemKind.InvalidAssignmentToImage, 1, new Object[0]));
                }
                FreeIdentifier ident = (FreeIdentifier)idents.get(0);
                Expression index = pc.subParse(EXPR_PARSER, false);
                pc.acceptCloseParen();
                pc.accept(this.kind);
                Expression value = pc.subParse(EXPR_PARSER, true);
                Expression overriding = MainParsers.makeFunctionOverriding(ident, index, value, pc.factory);
                BecomesEqualTo bet = pc.factory.makeBecomesEqualTo(ident, overriding, pc.getSourceLocation());
                return new IParserPrinter.SubParseResult<BecomesEqualTo>(bet, this.kind);
            }
            if (tokenKind == this.kind) {
                List values = (List)((Object)pc.subParseNoCheck(EXPR_LIST_PARSER));
                if (idents.size() != values.size()) {
                    throw pc.syntaxError(new ASTProblem(pc.makeSourceLocation(tokenAfterIdents), ProblemKind.IncompatibleIdentExprNumbers, 1, idents.size(), values.size()));
                }
                BecomesEqualTo bet = pc.factory.makeBecomesEqualTo(idents, values, pc.getSourceLocation());
                return new IParserPrinter.SubParseResult<BecomesEqualTo>(bet, this.kind);
            }
            throw pc.syntaxError(new ASTProblem(pc.makeSourceLocation(tokenAfterIdents), ProblemKind.UnknownOperator, 1, tokenAfterIdents + " (as assignment operator)"));
        }

        @Override
        public void toString(IToStringMediator mediator, BecomesEqualTo toPrint) {
            FreeIdentifier[] idents = toPrint.getAssignedIdentifiers();
            FREE_IDENT_LIST_PARSER.toString(mediator, Arrays.asList(idents));
            mediator.appendImage(this.kind);
            Expression[] expressions = toPrint.getExpressions();
            SPACED_EXPR_LIST_PARSER.toString(mediator, Arrays.asList(expressions));
        }
    }

    public static class BoundIdentDeclListParser
    extends AbstListParser<BoundIdentDecl> {
        public BoundIdentDeclListParser() {
            super(SubParsers.BOUND_IDENT_DECL_SUBPARSER);
        }

        public static void toString(IToStringMediator mediator, BoundIdentDecl[] decls, String[] localNames) {
            assert (decls.length == localNames.length);
            SubParsers.BoundIdentDeclSubParser.printIdent(mediator, decls, localNames, 0);
            for (int i = 1; i < decls.length; ++i) {
                mediator.append(AbstractGrammar.DefaultToken.COMMA);
                SubParsers.BoundIdentDeclSubParser.printIdent(mediator, decls, localNames, i);
            }
        }
    }

    static class AbstListParser<T extends Formula<?>>
    implements INudParser<List<T>> {
        private final INudParser<? extends T> parser;

        public AbstListParser(INudParser<? extends T> parser) {
            this.parser = parser;
        }

        @Override
        public IParserPrinter.SubParseResult<List<T>> nud(ParserContext pc) throws GenParser.SyntaxError {
            ArrayList<Formula> list = new ArrayList<Formula>();
            Formula first = (Formula)pc.subParseNoCheck(this.parser);
            list.add(first);
            int comma = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.COMMA);
            while (pc.t.kind == comma) {
                pc.accept(comma);
                Formula next = (Formula)pc.subParseNoCheck(this.parser);
                list.add(next);
            }
            return new IParserPrinter.SubParseResult<List<T>>(list, pc.getGrammar().getKind(AbstractGrammar.DefaultToken.NOOP));
        }

        @Override
        public void toString(IToStringMediator mediator, List<T> toPrint) {
            Iterator<T> iter = toPrint.iterator();
            Formula first = (Formula)iter.next();
            mediator.subPrintNoPar(first, false, SubParsers.NO_DECL);
            while (iter.hasNext()) {
                this.appendSeparator(mediator);
                Formula next = (Formula)iter.next();
                mediator.subPrintNoPar(next, false, SubParsers.NO_DECL);
            }
        }

        protected void appendSeparator(IToStringMediator mediator) {
            mediator.append(AbstractGrammar.DefaultToken.COMMA);
        }
    }

    static class PatternParser
    implements INudParser<Pattern> {
        final Pattern pattern;

        public PatternParser(ParseResult result) {
            this.pattern = new Pattern(result);
        }

        @Override
        public IParserPrinter.SubParseResult<Pattern> nud(ParserContext pc) throws GenParser.SyntaxError {
            PatternAtomParser atomParser = new PatternAtomParser(this.pattern, this);
            pc.subParseNoCheck(atomParser);
            int mapsto = pc.getGrammar().getKind(AbstractGrammar.DefaultToken.MAPS_TO);
            while (pc.t.kind == mapsto) {
                pc.accept(mapsto);
                pc.subParseNoCheck(atomParser);
                this.pattern.mapletParsed(pc.getSourceLocation());
            }
            return new IParserPrinter.SubParseResult<Pattern>(this.pattern, mapsto);
        }

        public static void appendPattern(IToStringMediator mediator, Expression pattern, BoundIdentDecl[] identDecls, String[] boundNames) {
            switch (pattern.getTag()) {
                case 201: {
                    boolean needsParen;
                    BinaryExpression maplet = (BinaryExpression)pattern;
                    Expression left = maplet.getLeft();
                    Expression right = maplet.getRight();
                    PatternParser.appendPattern(mediator, left, identDecls, boundNames);
                    mediator.append(AbstractGrammar.DefaultToken.MAPS_TO);
                    boolean bl = needsParen = right.getTag() == 201;
                    if (needsParen) {
                        mediator.append(AbstractGrammar.DefaultToken.LPAR);
                    }
                    PatternParser.appendPattern(mediator, right, identDecls, boundNames);
                    if (!needsParen) break;
                    mediator.append(AbstractGrammar.DefaultToken.RPAR);
                    break;
                }
                case 3: {
                    BoundIdentifier ident = (BoundIdentifier)pattern;
                    int length = identDecls.length;
                    int idx = length - ident.getBoundIndex() - 1;
                    SubParsers.BoundIdentDeclSubParser.printIdent(mediator, identDecls, boundNames, idx);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public void toString(IToStringMediator mediator, Pattern toPrint) {
            assert (false);
        }

        private static class PatternAtomParser
        implements INudParser<Object> {
            private final Pattern pattern;
            private final PatternParser parser;

            public PatternAtomParser(Pattern pattern, PatternParser parser) {
                this.pattern = pattern;
                this.parser = parser;
            }

            @Override
            public IParserPrinter.SubParseResult<Object> nud(ParserContext pc) throws GenParser.SyntaxError {
                if (pc.t.kind == pc.getGrammar().getKind(AbstractGrammar.DefaultToken.LPAR)) {
                    pc.acceptOpenParen();
                    pc.subParse(this.parser, false);
                    pc.acceptCloseParen();
                } else {
                    BoundIdentDecl boundIdent = pc.subParse(SubParsers.BOUND_IDENT_DECL_SUBPARSER, false);
                    this.pattern.declParsed(boundIdent);
                }
                return new IParserPrinter.SubParseResult<Object>(null, pc.getGrammar().getKind(AbstractGrammar.DefaultToken.NOOP));
            }

            @Override
            public void toString(IToStringMediator mediator, Object toPrint) {
                assert (false);
            }
        }
    }

    private static abstract class ParserApplier<P> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IParserPrinter.SubParseResult<Formula<?>> apply(ParserContext pc, Formula<?> left) throws GenParser.SyntaxError {
            P parser = this.getParser(pc);
            pc.pushParentKind();
            try {
                IParserPrinter.SubParseResult<Formula<?>> subParseResult = this.apply(pc, parser, left);
                return subParseResult;
            }
            finally {
                pc.popParentKind();
            }
        }

        protected abstract P getParser(ParserContext var1) throws GenParser.SyntaxError;

        protected abstract IParserPrinter.SubParseResult<Formula<?>> apply(ParserContext var1, P var2, Formula<?> var3) throws GenParser.SyntaxError;

        protected static ASTProblem newOperatorError(ParserContext pc, ProblemKind problemKind) throws GenParser.SyntaxError {
            SourceLocation srcLoc = pc.makeSourceLocation(pc.t);
            if (pc.t.kind == pc.getGrammar().getKind(AbstractGrammar.DefaultToken.EOF)) {
                return new ASTProblem(srcLoc, ProblemKind.PrematureEOF, 1, new Object[0]);
            }
            return new ASTProblem(srcLoc, problemKind, 1, pc.t.val);
        }

        protected static ASTProblem newCompoundError(SourceLocation loc, Set<ASTProblem> errors) {
            ArrayList<String> messages = new ArrayList<String>(errors.size());
            for (ASTProblem astProblem : errors) {
                messages.add(astProblem.toString());
            }
            return new ASTProblem(loc, ProblemKind.VariousPossibleErrors, 1, ProblemKind.makeCompoundMessage(errors));
        }
    }
}

