/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.util.Iterator;
import java.util.Set;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.wd.Node;

public class Lemma {
    final Set<Predicate> antecedents;
    final Predicate consequent;
    private final Node origin;

    public Lemma(Set<Predicate> antecedents, Predicate consequent, Node origin) {
        this.antecedents = antecedents;
        this.consequent = consequent;
        this.origin = origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lemma other = (Lemma)obj;
        if (!this.antecedents.equals(other.antecedents)) {
            return false;
        }
        return this.consequent.equals(other.consequent);
    }

    public int hashCode() {
        int result = 1;
        int prime = 37;
        result = 37 * result + this.antecedents.hashCode();
        result = 37 * result + this.consequent.hashCode();
        return result;
    }

    public boolean subsumes(Lemma other) {
        return this.consequent.equals(other.consequent) && other.antecedents.containsAll(this.antecedents);
    }

    public void setSubsumed() {
        this.origin.setNodeSubsumed();
    }

    public String toString() {
        return this.antecedents + " => " + this.consequent;
    }

    public void addToSet(Set<Lemma> set) {
        Iterator<Lemma> iter = set.iterator();
        while (iter.hasNext()) {
            Lemma other = iter.next();
            if (other.subsumes(this)) {
                this.setSubsumed();
                return;
            }
            if (!this.subsumes(other)) continue;
            iter.remove();
            other.setSubsumed();
        }
        set.add(this);
    }
}

