/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.wd;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;

public class FormulaBuilder {
    public final FormulaFactory ff;
    public final Predicate btrue;
    private Expression zero_cache;
    private Type Z_cache;

    public FormulaBuilder(FormulaFactory ff) {
        this.ff = ff;
        this.btrue = ff.makeLiteralPredicate(610, null);
    }

    public Predicate bounded(Expression set, boolean lower) {
        BoundIdentifier b0 = this.ff.makeBoundIdentifier(0, null, this.Z());
        BoundIdentifier b1 = this.ff.makeBoundIdentifier(1, null, this.Z());
        int tag = lower ? 104 : 106;
        RelationalPredicate rel = this.ff.makeRelationalPredicate(tag, b1, b0, null);
        RelationalPredicate xInSet = this.ff.makeRelationalPredicate(107, b0, (Expression)set.shiftBoundIdentifiers(2), null);
        BinaryPredicate impl = this.ff.makeBinaryPredicate(251, xInSet, rel, null);
        BoundIdentDecl[] b = new BoundIdentDecl[]{this.ff.makeBoundIdentDecl("b", null, this.Z())};
        BoundIdentDecl[] x = new BoundIdentDecl[]{this.ff.makeBoundIdentDecl("x", null, this.Z())};
        QuantifiedPredicate conj2 = this.ff.makeQuantifiedPredicate(852, b, (Predicate)this.ff.makeQuantifiedPredicate(851, x, (Predicate)impl, null), null);
        return conj2;
    }

    public Predicate exists(BoundIdentDecl[] decls, Predicate pred) {
        if (pred.getTag() == 610) {
            return pred;
        }
        return this.ff.makeQuantifiedPredicate(852, decls, pred, null);
    }

    public Predicate finite(Expression expr) {
        return this.ff.makeSimplePredicate(620, expr, null);
    }

    public Predicate forall(BoundIdentDecl[] decls, Predicate pred) {
        if (pred.getTag() == 610) {
            return pred;
        }
        return this.ff.makeQuantifiedPredicate(851, decls, pred, null);
    }

    public Predicate inDomain(Expression fun, Expression expr) {
        UnaryExpression dom = this.ff.makeUnaryExpression(756, fun, null);
        return this.ff.makeRelationalPredicate(107, expr, dom, null);
    }

    public Predicate land(Predicate left, Predicate right) {
        if (left.getTag() == 610) {
            return right;
        }
        if (right.getTag() == 610) {
            return left;
        }
        Predicate[] children = new Predicate[]{left, right};
        return this.ff.makeAssociativePredicate(351, children, null);
    }

    public Predicate land(Predicate ... children) {
        LinkedList<Predicate> conjuncts = new LinkedList<Predicate>();
        for (Predicate child : children) {
            if (child.getTag() == 610) continue;
            conjuncts.add(child);
        }
        switch (conjuncts.size()) {
            case 0: {
                return this.btrue;
            }
            case 1: {
                return (Predicate)conjuncts.getFirst();
            }
        }
        return this.ff.makeAssociativePredicate(351, conjuncts, null);
    }

    public Predicate limp(Predicate left, Predicate right) {
        if (left.getTag() == 610 || right.getTag() == 610) {
            return right;
        }
        if (right.getTag() == 251) {
            Predicate rightLeft = ((BinaryPredicate)right).getLeft();
            Predicate newRight = ((BinaryPredicate)right).getRight();
            Predicate newLeft = this.land(left, rightLeft);
            return this.limp(newLeft, newRight);
        }
        if (left.equals(right)) {
            return this.btrue;
        }
        return this.ff.makeBinaryPredicate(251, left, right, null);
    }

    public Predicate lor(Predicate left, Predicate right) {
        if (left.getTag() == 610) {
            return left;
        }
        if (right.getTag() == 610) {
            return right;
        }
        Predicate[] children = new Predicate[]{left, right};
        return this.ff.makeAssociativePredicate(352, children, null);
    }

    public Predicate nonNegative(Expression expr) {
        return this.ff.makeRelationalPredicate(104, this.zero(), expr, null);
    }

    public Predicate notEmpty(Expression expr) {
        AtomicExpression emptyset = this.ff.makeEmptySet(expr.getType(), null);
        return this.ff.makeRelationalPredicate(102, expr, emptyset, null);
    }

    public RelationalPredicate notZero(Expression expr) {
        return this.ff.makeRelationalPredicate(102, expr, this.zero(), null);
    }

    public Predicate partial(Expression fun) {
        Type funType = fun.getType();
        Expression src = funType.getSource().toExpression();
        Expression trg = funType.getTarget().toExpression();
        BinaryExpression pfun = this.ff.makeBinaryExpression(206, src, trg, null);
        return this.ff.makeRelationalPredicate(107, fun, pfun, null);
    }

    public RelationalPredicate positive(Expression expr) {
        return this.ff.makeRelationalPredicate(103, this.zero(), expr, null);
    }

    public Type Z() {
        if (this.Z_cache == null) {
            this.Z_cache = this.ff.makeIntegerType();
        }
        return this.Z_cache;
    }

    public Expression zero() {
        if (this.zero_cache == null) {
            this.zero_cache = this.ff.makeIntegerLiteral(BigInteger.ZERO, null);
        }
        return this.zero_cache;
    }
}

