/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.extension.ExtensionFactory;
import org.eventb.core.ast.extension.IArity;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.ITypeDistribution;

public class TypeDistribs {

    public static class MixedTypes
    implements ITypeDistribution {
        private final IOperatorProperties.FormulaType[] types;
        private final IArity exprArity;
        private final IArity predArity;

        public MixedTypes(IOperatorProperties.FormulaType[] types) {
            this.types = types;
            int nbExprs = 0;
            int nbPreds = 0;
            block4: for (IOperatorProperties.FormulaType type : types) {
                switch (type) {
                    case EXPRESSION: {
                        ++nbExprs;
                        continue block4;
                    }
                    case PREDICATE: {
                        ++nbPreds;
                    }
                }
            }
            this.exprArity = ExtensionFactory.makeFixedArity(nbExprs);
            this.predArity = ExtensionFactory.makeFixedArity(nbPreds);
        }

        @Override
        public IArity getExprArity() {
            return this.exprArity;
        }

        @Override
        public IArity getPredArity() {
            return this.predArity;
        }

        @Override
        public boolean check(List<? extends Formula<?>> proposedChildren) {
            if (proposedChildren.size() != this.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                Formula<?> proposedChild = proposedChildren.get(i);
                if (this.types[i].check(proposedChild)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Formula<?>> makeList(Expression[] childExprs, Predicate[] childPreds) {
            assert (this.exprArity.check(childExprs.length));
            assert (this.predArity.check(childPreds.length));
            ArrayList children = new ArrayList();
            int exprIndex = 0;
            int predIndex = 0;
            block4: for (IOperatorProperties.FormulaType type : this.types) {
                switch (type) {
                    case EXPRESSION: {
                        children.add(childExprs[exprIndex]);
                        ++exprIndex;
                        continue block4;
                    }
                    case PREDICATE: {
                        children.add(childPreds[predIndex]);
                        ++predIndex;
                    }
                }
            }
            return children;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exprArity == null ? 0 : this.exprArity.hashCode());
            result = 31 * result + (this.predArity == null ? 0 : this.predArity.hashCode());
            result = 31 * result + Arrays.hashCode((Object[])this.types);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MixedTypes)) {
                return false;
            }
            MixedTypes other = (MixedTypes)obj;
            if (this.exprArity == null ? other.exprArity != null : !this.exprArity.equals(other.exprArity)) {
                return false;
            }
            if (this.predArity == null ? other.predArity != null : !this.predArity.equals(other.predArity)) {
                return false;
            }
            return Arrays.equals((Object[])this.types, (Object[])other.types);
        }
    }

    public static class AllSameType
    implements ITypeDistribution {
        private final IOperatorProperties.FormulaType type;
        private final IArity arity;

        public AllSameType(IOperatorProperties.FormulaType type, IArity arity) {
            this.type = type;
            this.arity = arity;
        }

        @Override
        public IArity getExprArity() {
            switch (this.type) {
                case EXPRESSION: {
                    return this.arity;
                }
                case PREDICATE: {
                    return IOperatorProperties.NULLARY;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public IArity getPredArity() {
            switch (this.type) {
                case EXPRESSION: {
                    return IOperatorProperties.NULLARY;
                }
                case PREDICATE: {
                    return this.arity;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean check(List<? extends Formula<?>> proposedChildren) {
            if (!this.arity.check(proposedChildren.size())) {
                return false;
            }
            for (Formula<?> proposedChild : proposedChildren) {
                if (this.type.check(proposedChild)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Formula<?>> makeList(Expression[] childExprs, Predicate[] childPreds) {
            List<Formula> list = this.type == IOperatorProperties.FormulaType.EXPRESSION ? Arrays.asList(childExprs) : Arrays.asList(childPreds);
            assert (this.arity.check(list.size()));
            return new ArrayList(list);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.arity == null ? 0 : this.arity.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AllSameType)) {
                return false;
            }
            AllSameType other = (AllSameType)obj;
            if (this.arity == null ? other.arity != null : !this.arity.equals(other.arity)) {
                return false;
            }
            return this.type == other.type;
        }
    }
}

