/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.RelationalPredicate;

public abstract class ExtensionTranslator {
    protected final FreeIdentifier function;
    protected final FormulaFactory factory;

    public ExtensionTranslator(FreeIdentifier function) {
        this.function = function;
        this.factory = function.getFactory();
    }

    protected Expression makeFunApp(Expression[] newChildExprs, Predicate[] newChildPreds) {
        Expression param = null;
        for (Expression expression : newChildExprs) {
            param = this.join(param, expression);
        }
        for (Formula formula : newChildPreds) {
            param = this.join(param, this.makeExprOfPred((Predicate)formula));
        }
        if (param == null) {
            return this.function;
        }
        return this.factory.makeBinaryExpression(226, this.function, param, null);
    }

    private Expression makeExprOfPred(Predicate pred) {
        RelationalPredicate relPred;
        if (pred.getTag() == 101 && (relPred = (RelationalPredicate)pred).getRight().getTag() == 405) {
            return relPred.getLeft();
        }
        return this.factory.makeBoolExpression(pred, null);
    }

    private Expression join(Expression left, Expression right) {
        if (left == null) {
            return right;
        }
        return this.factory.makeBinaryExpression(201, left, right, null);
    }

    public static class ExpressionExtTranslator
    extends ExtensionTranslator {
        public ExpressionExtTranslator(FreeIdentifier function) {
            super(function);
        }

        public Expression translate(Expression[] newChildExprs, Predicate[] newChildPreds) {
            return this.makeFunApp(newChildExprs, newChildPreds);
        }
    }

    public static class PredicateExtTranslator
    extends ExtensionTranslator {
        private final Expression btrue;

        public PredicateExtTranslator(FreeIdentifier function) {
            super(function);
            this.btrue = this.factory.makeAtomicExpression(405, null);
        }

        public Predicate translate(Expression[] newChildExprs, Predicate[] newChildPreds) {
            return this.makePredOfExpr(this.makeFunApp(newChildExprs, newChildPreds));
        }

        private Predicate makePredOfExpr(Expression expr) {
            return this.factory.makeRelationalPredicate(101, expr, this.btrue, null);
        }
    }
}

