/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.ISetInstantiation;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.TypeConstructorExtension;

public class SetSubstitution
implements ISetInstantiation,
ITypeVisitor {
    private static final Predicate[] NO_PREDS = new Predicate[0];
    private final Datatype datatype;
    private final ExtendedExpression set;
    private final FormulaFactory factory;
    private final Map<String, Expression> map = new HashMap<String, Expression>();
    private Expression result;

    public static SetSubstitution makeSubstitution(Datatype datatype, Expression proposedSet) {
        if (!(proposedSet instanceof ExtendedExpression)) {
            throw new IllegalArgumentException("Not an extended expression: " + proposedSet);
        }
        ExtendedExpression instance = (ExtendedExpression)proposedSet;
        IExpressionExtension ext = instance.getExtension();
        if (!(ext instanceof TypeConstructorExtension)) {
            throw new IllegalArgumentException("Not built with a type constructor: " + proposedSet);
        }
        if (!datatype.equals(ext.getOrigin())) {
            throw new IllegalArgumentException("Built with a type constructor of another datatype: " + proposedSet);
        }
        return new SetSubstitution(instance);
    }

    public SetSubstitution(ExtendedExpression set) {
        this.set = set;
        this.factory = set.getFactory();
        TypeConstructorExtension tcons = (TypeConstructorExtension)set.getExtension();
        this.datatype = tcons.getOrigin();
        this.map.put(tcons.getName(), set);
        String[] formalNames = tcons.getFormalNames();
        int nbParams = formalNames.length;
        Expression[] actuals = set.getChildExpressions();
        assert (actuals.length == nbParams);
        for (int i = 0; i < nbParams; ++i) {
            this.map.put(formalNames[i], actuals[i]);
        }
    }

    @Override
    public Datatype getOrigin() {
        return this.datatype;
    }

    @Override
    public ExtendedExpression getInstanceSet() {
        return this.set;
    }

    public Expression substitute(Type argType) {
        argType.accept(this);
        return this.result;
    }

    public Expression[] substitute(Type[] argTypes) {
        int length = argTypes.length;
        Expression[] exprs = new Expression[length];
        for (int i = 0; i < length; ++i) {
            exprs[i] = this.substitute(argTypes[i]);
        }
        return exprs;
    }

    private Expression defaultTranslate(Type type) {
        return (Expression)type.toExpression().translate(this.factory);
    }

    @Override
    public void visit(BooleanType type) {
        this.result = this.defaultTranslate(type);
    }

    @Override
    public void visit(GivenType type) {
        String name = type.getName();
        Expression repl = this.map.get(name);
        this.result = repl == null ? this.defaultTranslate(type) : repl;
    }

    @Override
    public void visit(IntegerType type) {
        this.result = this.defaultTranslate(type);
    }

    @Override
    public void visit(ParametricType type) {
        IExpressionExtension ext = type.getExprExtension();
        Type[] tparams = type.getTypeParameters();
        Expression[] eparams = this.substitute(tparams);
        this.result = this.factory.makeExtendedExpression(ext, eparams, NO_PREDS, null);
    }

    @Override
    public void visit(PowerSetType type) {
        Expression expr = this.substitute(type.getBaseType());
        this.result = this.factory.makeUnaryExpression(752, expr, null);
    }

    @Override
    public void visit(ProductType type) {
        Expression left = this.substitute(type.getLeft());
        Expression right = this.substitute(type.getRight());
        this.result = this.factory.makeBinaryExpression(214, left, right, null);
    }
}

