/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorArgument;
import org.eventb.core.ast.datatype.IConstructorExtension;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.ISetInstantiation;
import org.eventb.core.ast.datatype.ITypeInstantiation;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.datatype.DatatypeTranslation;

public class DatatypeTranslator {
    private static final Predicate[] NO_PREDICATES = new Predicate[0];
    private static final String TYPE_SUFFIX = "_Type";
    private final DatatypeTranslation translation;
    private final FormulaFactory srcFactory;
    private final FormulaFactory trgFactory;
    private final ParametricType srcTypeInstance;
    private final ITypeInstantiation srcInstantiation;
    private final Type[] srcTypeParameters;
    private final IExpressionExtension srcTypeConstructor;
    private final IDatatype datatype;
    private final IConstructorExtension[] srcConstructors;
    private final boolean hasDestructors;
    private final boolean hasNoSetConstructor;
    private final boolean hasSingleConstructor;
    private final Type[] trgTypeParameters;
    private final FreeIdentifier trgSetCons;
    private final GivenType trgDatatype;
    private final Expression trgDatatypeExpr;
    private final Map<Object, FreeIdentifier> replacements = new HashMap<Object, FreeIdentifier>();

    public DatatypeTranslator(ParametricType typeInstance, DatatypeTranslation translation) {
        this.translation = translation;
        this.srcFactory = translation.getSourceFormulaFactory();
        this.trgFactory = translation.getTargetFormulaFactory();
        this.srcTypeInstance = typeInstance;
        this.srcTypeConstructor = typeInstance.getExprExtension();
        this.srcTypeParameters = typeInstance.getTypeParameters();
        this.datatype = (IDatatype)this.srcTypeConstructor.getOrigin();
        this.srcInstantiation = this.datatype.getTypeInstantiation(this.srcTypeInstance);
        this.srcConstructors = this.datatype.getConstructors();
        assert (this.srcConstructors.length != 0);
        this.hasDestructors = this.hasDestructors();
        this.hasNoSetConstructor = !this.hasDestructors || this.srcTypeParameters.length == 0;
        this.hasSingleConstructor = this.srcConstructors.length == 1;
        this.trgTypeParameters = this.translateTypeParameters();
        String srcSymbol = this.srcTypeConstructor.getSyntaxSymbol();
        this.trgDatatype = this.getTrgDatatype(srcSymbol);
        this.trgDatatypeExpr = this.toTrgExpr(this.trgDatatype);
        this.trgSetCons = this.getTrgSetConstructor(srcSymbol);
        this.computeReplacements();
    }

    private boolean hasDestructors() {
        for (IConstructorExtension cons : this.datatype.getConstructors()) {
            if (!cons.hasArguments()) continue;
            return true;
        }
        return false;
    }

    private Expression toTrgExpr(Type trgType) {
        return trgType.toExpression();
    }

    private Type[] translateTypeParameters() {
        int length = this.srcTypeParameters.length;
        Type[] trgResult = new Type[length];
        for (int i = 0; i < length; ++i) {
            trgResult[i] = this.translateType(this.srcTypeParameters[i]);
        }
        return trgResult;
    }

    private GivenType getTrgDatatype(String srcSymbol) {
        String symbol = this.hasNoSetConstructor ? srcSymbol : srcSymbol + TYPE_SUFFIX;
        return this.translation.solveGivenType(symbol);
    }

    private FreeIdentifier getTrgSetConstructor(String srcSymbol) {
        if (this.hasNoSetConstructor) {
            return null;
        }
        Type trgType = this.makeTrgConsType(this.trgTypeParameters);
        return this.translation.solveIdentifier(srcSymbol, trgType);
    }

    private void computeReplacements() {
        for (IConstructorExtension srcCons : this.srcConstructors) {
            Type[] trgArgTypes = this.computeDestructorReplacements(srcCons);
            this.addReplacement(srcCons, srcCons.getSyntaxSymbol(), this.makeTrgConsType(trgArgTypes));
        }
    }

    private Type[] computeDestructorReplacements(IConstructorExtension cons) {
        IConstructorArgument[] args = cons.getArguments();
        int nbArgs = args.length;
        Type[] trgResult = new Type[nbArgs];
        for (int i = 0; i < nbArgs; ++i) {
            IConstructorArgument arg = args[i];
            Type trgAlpha = this.translateType(arg.getType(this.srcInstantiation));
            String symbol = arg.isDestructor() ? arg.asDestructor().getSyntaxSymbol() : "d";
            this.addReplacement(arg, symbol, this.mTrgRelType(this.trgDatatype, trgAlpha));
            trgResult[i] = trgAlpha;
        }
        return trgResult;
    }

    private void addReplacement(Object ext, String symbol, Type trgType) {
        FreeIdentifier ident = this.translation.solveIdentifier(symbol, trgType);
        this.replacements.put(ext, ident);
    }

    private Type makeTrgConsType(Type[] trgArgTypes) {
        if (trgArgTypes.length == 0) {
            return this.trgDatatype;
        }
        Type trgProdType = this.makeTrgProdType(trgArgTypes);
        return this.mTrgRelType(trgProdType, this.trgDatatype);
    }

    private Type makeTrgProdType(Type[] trgTypes) {
        Type trgProdType = trgTypes[0];
        for (int i = 1; i < trgTypes.length; ++i) {
            trgProdType = this.mTrgProdType(trgProdType, trgTypes[i]);
        }
        return trgProdType;
    }

    private Expression combineTrgExpr(int tag, Expression[] trgExprs) {
        int length = trgExprs.length;
        assert (length != 0);
        Expression trgResult = trgExprs[0];
        for (int i = 1; i < length; ++i) {
            trgResult = this.mTrgBinExpr(tag, trgResult, trgExprs[i]);
        }
        return trgResult;
    }

    private Type translateType(Type srcType) {
        if (this.srcTypeInstance.equals(srcType)) {
            return this.trgDatatype;
        }
        return this.translation.translate(srcType);
    }

    public Type getTranslatedType() {
        return this.trgDatatype;
    }

    public Expression rewrite(ExtendedExpression src, Expression[] trgChildExprs) {
        IExpressionExtension ext = src.getExtension();
        if (ext.isATypeConstructor()) {
            if (this.hasNoSetConstructor || src.isATypeExpression()) {
                return this.trgDatatypeExpr;
            }
            return this.mTrgRelImage(this.trgSetCons, trgChildExprs);
        }
        Expression trgExpr = this.replacements.get(ext);
        if (trgChildExprs.length == 0) {
            return trgExpr;
        }
        Expression trgMaplets = this.combineTrgExpr(201, trgChildExprs);
        return this.mTrgBinExpr(226, trgExpr, trgMaplets);
    }

    private Expression mTrgRelImage(Expression trgRel, Expression[] trgSets) {
        Expression trgExpr = this.combineTrgExpr(214, trgSets);
        return this.mTrgBinExpr(227, trgRel, trgExpr);
    }

    public List<Predicate> getAxioms() {
        ArrayList<Predicate> axioms = new ArrayList<Predicate>();
        this.addSetConstructorDefinitionAxiom(axioms);
        for (IConstructorExtension cons : this.srcConstructors) {
            this.addAxioms(axioms, cons);
        }
        this.addPartitionAxiom(axioms);
        this.addSetConstructorAxiom(axioms);
        return axioms;
    }

    private void addSetConstructorDefinitionAxiom(List<Predicate> axioms) {
        if (this.hasNoSetConstructor) {
            return;
        }
        Type trgSetConsType = this.trgSetCons.getType();
        Expression trgProd = this.toTrgExpr(trgSetConsType.getSource());
        Expression trgRange = this.toTrgExpr(trgSetConsType.getTarget());
        axioms.add(this.mTrgInRelationalSet(this.trgSetCons, 205, trgProd, trgRange));
    }

    private void addSetConstructorAxiom(List<Predicate> axioms) {
        if (this.hasNoSetConstructor) {
            return;
        }
        ArrayList<Expression> trgParts = new ArrayList<Expression>();
        Expression[] srcBoundIdents = this.makeSrcBoundIdentifiers();
        trgParts.add(this.mTrgRelImage(this.trgSetCons, this.translate(srcBoundIdents)));
        ExtendedExpression srcSet = this.makeSrcSet(srcBoundIdents);
        ISetInstantiation setInst = this.datatype.getSetInstantiation(srcSet);
        for (IConstructorExtension cons : this.srcConstructors) {
            trgParts.add(this.makeTrgSetPartitionPart(cons, setInst));
        }
        Predicate trgPartition = this.mTrgPartition(trgParts);
        BoundIdentDecl[] trgDecls = this.makeTrgBoundIdentDecls();
        axioms.add(this.mTrgForall(trgDecls, trgPartition));
    }

    private Expression[] makeSrcBoundIdentifiers() {
        int nbIdents = this.srcTypeParameters.length;
        Expression[] idents = new Expression[nbIdents];
        int boundIndex = nbIdents - 1;
        for (int i = 0; i < nbIdents; ++i) {
            Type srcType = this.srcTypeParameters[i];
            Type srcBoundType = this.mSrcPowerSetType(srcType);
            idents[i] = this.mSrcBoundIdent(boundIndex, srcBoundType);
            --boundIndex;
        }
        return idents;
    }

    private Expression[] translate(Expression[] srcExprs) {
        int length = srcExprs.length;
        Expression[] trgResult = new Expression[length];
        for (int i = 0; i < length; ++i) {
            trgResult[i] = (Expression)srcExprs[i].translateDatatype(this.translation);
        }
        return trgResult;
    }

    private Expression makeTrgSetPartitionPart(IConstructorExtension cons, ISetInstantiation setInst) {
        Expression trgCons = this.replacements.get(cons);
        if (this.hasArguments(cons)) {
            Expression[] trgArgSets = this.mTrgArgSets(cons, setInst);
            return this.mTrgRelImage(trgCons, trgArgSets);
        }
        return this.mTrgSingleton(trgCons);
    }

    private Expression[] mTrgArgSets(IConstructorExtension cons, ISetInstantiation setInst) {
        IConstructorArgument[] args = cons.getArguments();
        Expression[] trgSets = new Expression[args.length];
        for (int i = 0; i < trgSets.length; ++i) {
            Expression srcSet = args[i].getSet(setInst);
            trgSets[i] = (Expression)srcSet.translateDatatype(this.translation);
        }
        return trgSets;
    }

    private ExtendedExpression makeSrcSet(Expression[] srcExprs) {
        return this.srcFactory.makeExtendedExpression(this.srcTypeConstructor, srcExprs, NO_PREDICATES, null, null);
    }

    private BoundIdentDecl[] makeTrgBoundIdentDecls() {
        int nbTypeParams = this.trgTypeParameters.length;
        BoundIdentDecl[] trgResult = new BoundIdentDecl[nbTypeParams];
        String[] typeParamsNames = this.datatype.getTypeConstructor().getFormalNames();
        for (int i = 0; i < nbTypeParams; ++i) {
            Type trgType = this.mTrgPowerSetType(this.trgTypeParameters[i]);
            String declName = typeParamsNames[i];
            trgResult[i] = this.mTrgBoundIdentDecl(declName, trgType);
        }
        return trgResult;
    }

    private void addAxioms(List<Predicate> axioms, IConstructorExtension cons) {
        if (!this.hasArguments(cons)) {
            return;
        }
        Expression trgCons = this.replacements.get(cons);
        Expression trgDomain = this.toTrgExpr(trgCons.getType().getSource());
        Expression trgRange = this.trgDatatypeExpr;
        int tag = this.hasSingleConstructor ? 212 : 209;
        axioms.add(this.mTrgInRelationalSet(trgCons, tag, trgDomain, trgRange));
        Expression[] trgDest = this.getTrgDestructors(cons);
        this.addDestructorAxioms(axioms, cons, trgDest);
        this.addConstructorInverseAxiom(axioms, cons, trgDest);
    }

    private Expression[] getTrgDestructors(IConstructorExtension cons) {
        IConstructorArgument[] args = cons.getArguments();
        int nbArgs = args.length;
        Expression[] trgResult = new Expression[nbArgs];
        for (int i = 0; i < nbArgs; ++i) {
            trgResult[i] = this.replacements.get(args[i]);
        }
        return trgResult;
    }

    private void addDestructorAxioms(List<Predicate> axioms, IConstructorExtension constructor, Expression[] trgDests) {
        Expression trgPart = this.makeTrgPartitionPart(constructor);
        for (Expression trgDest : trgDests) {
            Type trgType = trgDest.getType().getTarget();
            axioms.add(this.mTrgInRelationalSet(trgDest, 211, trgPart, this.toTrgExpr(trgType)));
        }
    }

    private Expression makeTrgPartitionPart(IConstructorExtension cons) {
        Expression trgGamma = this.replacements.get(cons);
        if (this.hasArguments(cons)) {
            return this.mTrgUnaryExpr(757, trgGamma);
        }
        return this.mTrgSingleton(trgGamma);
    }

    private void addConstructorInverseAxiom(List<Predicate> axioms, IExpressionExtension constructor, Expression[] trgDests) {
        Expression trgDProd = this.combineTrgExpr(215, trgDests);
        Expression trgCons = this.replacements.get(constructor);
        Expression trgConv = this.mTrgUnaryExpr(763, trgCons);
        axioms.add(this.mTrgEquals(trgDProd, trgConv));
    }

    private void addPartitionAxiom(List<Predicate> axioms) {
        if (this.hasSingleConstructorWithArguments()) {
            return;
        }
        ArrayList<Expression> trgParts = new ArrayList<Expression>();
        trgParts.add(this.trgDatatypeExpr);
        for (IConstructorExtension cons : this.srcConstructors) {
            trgParts.add(this.makeTrgPartitionPart(cons));
        }
        axioms.add(this.mTrgPartition(trgParts));
    }

    private boolean hasSingleConstructorWithArguments() {
        return this.hasSingleConstructor && this.hasArguments(this.srcConstructors[0]);
    }

    private boolean hasArguments(IConstructorExtension constructor) {
        return constructor.getArguments().length != 0;
    }

    private Expression mSrcBoundIdent(int i, Type srcType) {
        return this.srcFactory.makeBoundIdentifier(i, null, srcType);
    }

    private Type mSrcPowerSetType(Type srcType) {
        return this.srcFactory.makePowerSetType(srcType);
    }

    private Type mTrgPowerSetType(Type trgType) {
        return this.trgFactory.makePowerSetType(trgType);
    }

    private BoundIdentDecl mTrgBoundIdentDecl(String name, Type trgType) {
        return this.trgFactory.makeBoundIdentDecl(name, null, trgType);
    }

    private Expression mTrgBinExpr(int tag, Expression e1, Expression e2) {
        return this.trgFactory.makeBinaryExpression(tag, e1, e2, null);
    }

    private Predicate mTrgPartition(List<Expression> parts) {
        return this.trgFactory.makeMultiplePredicate(901, parts, null);
    }

    private Type mTrgProdType(Type t1, Type t2) {
        return this.trgFactory.makeProductType(t1, t2);
    }

    private Type mTrgRelType(Type t1, Type t2) {
        return this.trgFactory.makeRelationalType(t1, t2);
    }

    private Predicate mTrgForall(BoundIdentDecl[] trgDecls, Predicate trgPred) {
        return this.trgFactory.makeQuantifiedPredicate(851, trgDecls, trgPred, null);
    }

    private Predicate mTrgEquals(Expression trgLeft, Expression trgRight) {
        return this.trgFactory.makeRelationalPredicate(101, trgLeft, trgRight, null);
    }

    private Predicate mTrgInRelationalSet(Expression trgRel, int tag, Expression trgDomain, Expression trgRange) {
        Expression trgSet = this.mTrgBinExpr(tag, trgDomain, trgRange);
        return this.trgFactory.makeRelationalPredicate(107, trgRel, trgSet, null);
    }

    private Expression mTrgSingleton(Expression expression) {
        return this.trgFactory.makeSetExtension(expression, null);
    }

    private Expression mTrgUnaryExpr(int tag, Expression constructor) {
        return this.trgFactory.makeUnaryExpression(tag, constructor, null);
    }
}

