/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IDatatypeTranslation;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorExtension;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDestructorExtension;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.AbstractTranslation;
import org.eventb.internal.core.ast.FreshNameSolver;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.TypeRewriter;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeRewriter;
import org.eventb.internal.core.ast.datatype.DatatypeTranslator;

public class DatatypeTranslation
extends AbstractTranslation
implements IDatatypeTranslation {
    private final FormulaFactory sourceFactory;
    private final FormulaFactory targetFactory;
    private final FreshNameSolver nameSolver;
    private final Map<ParametricType, DatatypeTranslator> translators = new LinkedHashMap<ParametricType, DatatypeTranslator>();
    private final TypeRewriter typeRewriter;
    private final ITypeCheckingRewriter formulaRewriter;

    public DatatypeTranslation(ISealedTypeEnvironment typenv) {
        super(typenv);
        this.sourceFactory = typenv.getFormulaFactory();
        this.targetFactory = this.computeTargetFactory();
        HashSet<String> usedNames = new HashSet<String>(typenv.getNames());
        this.nameSolver = new FreshNameSolver(usedNames, this.targetFactory);
        this.typeRewriter = new TypeRewriter(this.targetFactory){

            @Override
            public void visit(ParametricType type) {
                this.result = DatatypeTranslation.this.translateParametricType(type);
            }
        };
        this.formulaRewriter = new DatatypeRewriter(this);
    }

    private FormulaFactory computeTargetFactory() {
        Set<IFormulaExtension> extensions = this.sourceFactory.getExtensions();
        LinkedHashSet<IFormulaExtension> keptExtensions = new LinkedHashSet<IFormulaExtension>();
        for (IFormulaExtension extension : extensions) {
            if (extension.getOrigin() instanceof IDatatype) continue;
            keptExtensions.add(extension);
        }
        return FormulaFactory.getInstance(keptExtensions);
    }

    public ParametricType getDatatypeInstance(ExtendedExpression src) {
        IExpressionExtension extension = src.getExtension();
        if (extension.isATypeConstructor()) {
            return (ParametricType)src.getType().getBaseType();
        }
        if (extension instanceof IConstructorExtension) {
            return (ParametricType)src.getType();
        }
        if (extension instanceof IDestructorExtension) {
            return (ParametricType)src.getChildExpressions()[0].getType();
        }
        assert (false);
        return null;
    }

    public FormulaFactory getSourceFormulaFactory() {
        return this.sourceFactory;
    }

    @Override
    public FormulaFactory getTargetFormulaFactory() {
        return this.targetFactory;
    }

    @Override
    public ITypeCheckingRewriter getFormulaRewriter() {
        return this.formulaRewriter;
    }

    public final GivenType solveGivenType(String typeSymbol) {
        String solvedTypeName = this.nameSolver.solveAndAdd(typeSymbol);
        return this.targetFactory.makeGivenType(solvedTypeName);
    }

    public final FreeIdentifier solveIdentifier(String symbol, Type type) {
        String solvedIdentName = this.nameSolver.solveAndAdd(symbol);
        return this.targetFactory.makeFreeIdentifier(solvedIdentName, null, type);
    }

    public Type translate(Type type) {
        return this.typeRewriter.rewrite(type);
    }

    public Type translateParametricType(ParametricType type) {
        assert (type.getExprExtension().getOrigin() instanceof Datatype);
        return this.getTranslatorFor(type).getTranslatedType();
    }

    public Expression translate(ExtendedExpression src, Expression[] newChildExprs) {
        assert (src.getExtension().getOrigin() instanceof Datatype);
        ParametricType type = this.getDatatypeInstance(src);
        DatatypeTranslator translator = this.getTranslatorFor(type);
        return translator.rewrite(src, newChildExprs);
    }

    private DatatypeTranslator getTranslatorFor(ParametricType type) {
        DatatypeTranslator translator = this.translators.get(type);
        if (translator == null) {
            translator = this.createTranslatorFor(type);
            this.translators.put(type, translator);
        }
        return translator;
    }

    @Override
    public List<Predicate> getAxioms() {
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        for (DatatypeTranslator translator : this.translators.values()) {
            result.addAll(translator.getAxioms());
        }
        return result;
    }

    private DatatypeTranslator createTranslatorFor(ParametricType type) {
        return new DatatypeTranslator(type, this);
    }

    public String toString() {
        return "Datatype Translation for factory: " + this.sourceFactory + " in type environment: " + this.srcTypenv;
    }
}

