/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.Type;

public class TypeTranslatabilityChecker
implements ITypeVisitor {
    private final FormulaFactory target;
    private boolean isTranslatable = true;

    public static boolean isTranslatable(Type type, FormulaFactory target) {
        TypeTranslatabilityChecker checker = new TypeTranslatabilityChecker(target);
        type.accept(checker);
        return checker.isTranslatable();
    }

    public TypeTranslatabilityChecker(FormulaFactory target) {
        this.target = target;
    }

    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void visit(BooleanType type) {
    }

    @Override
    public void visit(GivenType type) {
        this.isTranslatable &= this.target.isValidIdentifierName(type.getName());
    }

    @Override
    public void visit(IntegerType type) {
    }

    @Override
    public void visit(ParametricType type) {
        this.isTranslatable &= this.target.hasExtension(type.getExprExtension());
        for (Type child : type.getTypeParameters()) {
            child.accept(this);
        }
    }

    @Override
    public void visit(PowerSetType type) {
        type.getBaseType().accept(this);
    }

    @Override
    public void visit(ProductType type) {
        type.getLeft().accept(this);
        type.getRight().accept(this);
    }
}

