/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.IdentListMerger;

public final class MergingStream
extends IdentListMerger {
    private IdentListMerger s1;
    private Identifier id1;
    private String name1;
    private int idx1;
    private IdentListMerger s2;
    private Identifier id2;
    private String name2;
    private int idx2;

    protected MergingStream(IdentListMerger s1, IdentListMerger s2) {
        super(s1.itemClass);
        assert (s1.itemClass == s2.itemClass);
        this.s1 = s1;
        this.s2 = s2;
        this.id1 = s1.getNext();
        this.name1 = this.getName(this.id1);
        this.idx1 = this.getIndex(this.id1);
        this.id2 = s2.getNext();
        this.name2 = this.getName(this.id2);
        this.idx2 = this.getIndex(this.id2);
    }

    @Override
    public boolean containsError() {
        if (!this.errorFound) {
            this.errorFound = this.s1.containsError() || this.s2.containsError();
        }
        return this.errorFound;
    }

    private final String getName(Identifier id) {
        if (this.itemClass != FreeIdentifier.class) {
            return null;
        }
        if (id == null) {
            return "\uffff";
        }
        if (id instanceof FreeIdentifier) {
            return ((FreeIdentifier)id).getName();
        }
        return null;
    }

    private final int getIndex(Identifier id) {
        if (this.itemClass != BoundIdentifier.class) {
            return -1;
        }
        if (id == null) {
            return Integer.MAX_VALUE;
        }
        if (id instanceof BoundIdentifier) {
            return ((BoundIdentifier)id).getBoundIndex();
        }
        return -1;
    }

    @Override
    protected int getPotentialLength() {
        return this.s1.getPotentialLength() + this.s2.getPotentialLength();
    }

    @Override
    protected Identifier[] getMaximalArray() {
        Identifier[] array2;
        Identifier[] array1 = this.s1.getMaximalArray();
        if (array1.length <= (array2 = this.s2.getMaximalArray()).length) {
            return array2;
        }
        return array1;
    }

    @Override
    protected Identifier getNext() {
        Identifier result = null;
        int comparison = this.itemClass == FreeIdentifier.class ? this.name1.compareTo(this.name2) : this.idx1 - this.idx2;
        if (comparison == 0 && !this.errorFound && this.id1 != null) {
            Type type1 = this.id1.getType();
            Type type2 = this.id2.getType();
            boolean bl = this.errorFound = type1 == null || !type1.equals(type2);
        }
        if (comparison <= 0) {
            result = this.id1;
            this.id1 = this.s1.getNext();
            this.name1 = this.getName(this.id1);
            this.idx1 = this.getIndex(this.id1);
        }
        if (comparison >= 0) {
            result = this.id2;
            this.id2 = this.s2.getNext();
            this.name2 = this.getName(this.id2);
            this.idx2 = this.getIndex(this.id2);
        }
        return result;
    }
}

