/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.Type;

public class GivenTypeHelper {
    private static final Comparator<FreeIdentifier> comparator = new Comparator<FreeIdentifier>(){

        @Override
        public int compare(FreeIdentifier o1, FreeIdentifier o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static boolean isGivenSet(String name, Type type) {
        Type baseType = type.getBaseType();
        if (baseType instanceof GivenType) {
            GivenType givenType = (GivenType)baseType;
            return givenType.getName().equals(name);
        }
        return false;
    }

    public static FreeIdentifier[] getGivenTypeIdentifiers(Type type) {
        Set<GivenType> givenTypes = type.getGivenTypes();
        FreeIdentifier[] result = new FreeIdentifier[givenTypes.size()];
        int idx = 0;
        for (GivenType givenType : givenTypes) {
            result[idx++] = givenType.toExpression();
        }
        Arrays.sort(result, comparator);
        return result;
    }
}

