/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.List;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.DefaultInspector;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IAccumulator;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IFormulaExtension;

public class FormulaTranslatabilityChecker
extends DefaultInspector<String> {
    private final FormulaFactory factory;

    public static boolean isTranslatable(Formula<?> formula, FormulaFactory factory, FreeIdentifier[] idents) {
        for (FreeIdentifier ident : idents) {
            if (factory.isValidIdentifierName(ident.getName())) continue;
            return false;
        }
        FormulaTranslatabilityChecker checker = new FormulaTranslatabilityChecker(factory);
        List<String> result = formula.inspect(checker);
        return result.isEmpty();
    }

    private FormulaTranslatabilityChecker(FormulaFactory factory) {
        this.factory = factory;
    }

    private void checkTypeTranslatable(Expression expr, IAccumulator<String> acc) {
        this.checkTypeTranslatable(expr.getType(), acc);
    }

    private void checkTypeTranslatable(Type type, IAccumulator<String> acc) {
        if (type != null && !type.isTranslatable(this.factory)) {
            acc.add("Incompatible type: " + type);
        }
    }

    private void checkExtensionTranslatable(IExtendedFormula extForm, IAccumulator<String> acc) {
        IFormulaExtension extension = extForm.getExtension();
        if (!this.factory.hasExtension(extension)) {
            acc.add("Incompatible extension: " + extension);
        }
    }

    @Override
    public void inspect(AtomicExpression expr, IAccumulator<String> accumulator) {
        this.checkTypeTranslatable(expr, accumulator);
    }

    @Override
    public void inspect(BoundIdentDecl decl, IAccumulator<String> accumulator) {
        this.checkTypeTranslatable(decl.getType(), accumulator);
    }

    @Override
    public void inspect(BoundIdentifier ident, IAccumulator<String> accumulator) {
        this.checkTypeTranslatable(ident, accumulator);
    }

    @Override
    public void inspect(ExtendedExpression expr, IAccumulator<String> accumulator) {
        this.checkExtensionTranslatable(expr, accumulator);
        this.checkTypeTranslatable(expr, accumulator);
    }

    @Override
    public void inspect(ExtendedPredicate pred, IAccumulator<String> accumulator) {
        this.checkExtensionTranslatable(pred, accumulator);
    }

    @Override
    public void inspect(FreeIdentifier ident, IAccumulator<String> accumulator) {
        this.checkTypeTranslatable(ident, accumulator);
    }

    @Override
    public void inspect(SetExtension expr, IAccumulator<String> accumulator) {
        this.checkTypeTranslatable(expr, accumulator);
    }
}

