/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Collection;
import java.util.HashMap;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.internal.core.ast.SimpleSubstitution;
import org.eventb.internal.core.ast.Substitute;

public class BindingSubstitution
extends SimpleSubstitution {
    final int offset;

    public BindingSubstitution(Collection<FreeIdentifier> identsToBind, FormulaFactory ff) {
        super(ff);
        this.offset = identsToBind.size();
        this.map = new HashMap(this.offset * 4 / 3 + 1);
        int index = this.offset - 1;
        for (FreeIdentifier ident : identsToBind) {
            this.map.put(ident, Substitute.makeSubstitute(index--));
        }
    }

    @Override
    public Expression rewrite(BoundIdentifier ident) {
        assert (this.ff == ident.getFactory());
        int index = ident.getBoundIndex();
        if (index < this.getBindingDepth() || this.offset == 0) {
            return super.rewrite(ident);
        }
        return this.ff.makeBoundIdentifier(index + this.offset, ident.getSourceLocation(), ident.getType());
    }
}

