/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast.extension;

import org.eventb.core.ast.extension.IArity;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.ITypeDistribution;
import org.eventb.internal.core.ast.extension.Arity;
import org.eventb.internal.core.ast.extension.ExtensionKind;
import org.eventb.internal.core.ast.extension.TypeDistribs;

public class ExtensionFactory {
    public static final ITypeDistribution NO_CHILD = ExtensionFactory.makeChildTypes(new IOperatorProperties.FormulaType[0]);
    public static final ITypeDistribution ONE_EXPR = ExtensionFactory.makeAllExpr(IOperatorProperties.UNARY);
    public static final ITypeDistribution TWO_EXPRS = ExtensionFactory.makeAllExpr(IOperatorProperties.BINARY);
    public static final ITypeDistribution TWO_OR_MORE_EXPRS = ExtensionFactory.makeAllExpr(IOperatorProperties.MULTARY_2);

    private ExtensionFactory() {
    }

    public static ITypeDistribution makeAllExpr(IArity arity) {
        return new TypeDistribs.AllSameType(IOperatorProperties.FormulaType.EXPRESSION, arity);
    }

    public static ITypeDistribution makeAllPred(IArity arity) {
        return new TypeDistribs.AllSameType(IOperatorProperties.FormulaType.PREDICATE, arity);
    }

    public static ITypeDistribution makeChildTypes(IOperatorProperties.FormulaType ... types) {
        return new TypeDistribs.MixedTypes(types);
    }

    public static IExtensionKind makePrefixKind(IOperatorProperties.FormulaType formulaType, ITypeDistribution childTypes) {
        return new ExtensionKind(IOperatorProperties.Notation.PREFIX, formulaType, childTypes, false);
    }

    public static IArity makeArity(int min, int max) {
        return new Arity(min, max);
    }

    public static IArity makeFixedArity(int arity) {
        return new Arity(arity, arity);
    }
}

