/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class UnaryPredicate
extends Predicate {
    private static final int FIRST_TAG = 701;
    public static final String NOT_ID = "Not";
    public static final int TAGS_LENGTH = Operators.values().length;
    protected final Predicate child;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected UnaryPredicate(Predicate child, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, child.hashCode());
        this.child = child;
        FormulaChecks.ensureTagInRange(tag, 701, TAGS_LENGTH);
        this.ensureSameFactory(this.child);
        this.setPredicateVariableCache(this.child);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        this.freeIdents = this.child.freeIdents;
        this.boundIdents = this.child.boundIdents;
        if (!this.child.isTypeChecked()) {
            return;
        }
        this.typeChecked = true;
    }

    public Predicate getChild() {
        return this.child;
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 701];
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        UnaryPredicate other = (UnaryPredicate)formula;
        return this.child.equals(other.child);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.child.typeCheck(result, quantifiedIdentifiers);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.child.solveType(unifier);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]\n" + this.child.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.child.isLegible(result);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.child.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.child.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 701: {
                goOn = visitor.enterNOT(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.child.accept(visitor);
        }
        switch (this.getTag()) {
            case 701: {
                return visitor.exitNOT(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitUnaryPredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        Predicate newChild = (Predicate)this.child.rewrite(rewriter);
        UnaryPredicate before = newChild == this.child ? this : rewriter.getFactory().makeUnaryPredicate(this.getTag(), newChild, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.child.inspect(acc);
        acc.leaveChildren();
    }

    public Predicate getChild(int index) {
        if (index == 0) {
            return this.child;
        }
        throw UnaryPredicate.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.child.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        if (index != 0) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Predicate newChild = rewriter.rewrite(this.child);
        return this.getFactory().makeUnaryPredicate(this.getTag(), newChild, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<UnaryPredicate>
    {
        OP_NOT("\u00ac", "Not", StandardGroup.NOT_PRED, 701);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<UnaryPredicate> makeParser(int kind) {
            return new SubParsers.UnaryPredicateParser(kind, this.tag, false);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

