/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.ISimpleVisitor2;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.IVisitor2;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class PredicateVariable
extends Predicate {
    public static final int tag = 9;
    public static final String LEADING_SYMBOL = "$";
    private final String name;

    public static void init(BMath grammar) {
        try {
            grammar.addOperator(AbstractGrammar.DefaultToken.PRED_VAR, AbstractGrammar.DefaultToken.PRED_VAR.getImage(), StandardGroup.GROUP_0.getId(), SubParsers.PRED_VAR_SUBPARSER, false);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected PredicateVariable(String name, SourceLocation location, FormulaFactory ff) {
        super(9, ff, location, name.hashCode());
        FormulaChecks.ensureValidPredicateName(name, ff);
        this.name = name;
        this.setPredicateVariableCache(this);
        this.synthesizeType();
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void synthesizeType() {
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = NO_BOUND_IDENT;
        this.typeChecked = true;
    }

    @Override
    protected void isLegible(LegibilityResult result) {
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        PredicateVariable other = (PredicateVariable)formula;
        return this.name.equals(other.name);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        SubParsers.PRED_VAR_SUBPARSER.toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getPREDVAR();
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.name + "]" + "\n";
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public Formula<?> getChild(int index) {
        throw PredicateVariable.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        throw new IllegalArgumentException("Position is outside the formula");
    }

    @Override
    public boolean accept(IVisitor visitor) {
        if (!(visitor instanceof IVisitor2)) {
            throw new IllegalArgumentException("The given visitor shall support predicate variables");
        }
        return ((IVisitor2)visitor).visitPREDICATE_VARIABLE(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        if (!(visitor instanceof ISimpleVisitor2)) {
            throw new IllegalArgumentException("The given visitor shall support predicate variables");
        }
        ((ISimpleVisitor2)visitor).visitPredicateVariable(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

