/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.Type;

public class PowerSetType
extends Type {
    private final Type base;

    protected PowerSetType(FormulaFactory ff, Type base) {
        super(ff, base.isSolved());
        this.base = base;
        this.ensureSameFactory(this.base);
    }

    @Override
    protected void addGivenTypes(Set<GivenType> set) {
        this.base.addGivenTypes(set);
    }

    @Override
    protected Expression buildExpression(FormulaFactory factory) {
        Expression baseExpr = this.base.toExpression();
        return factory.makeUnaryExpression(752, baseExpr, null);
    }

    @Override
    protected void buildString(StringBuilder buffer) {
        buffer.append("\u2119(");
        this.base.buildString(buffer);
        buffer.append(')');
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PowerSetType)) {
            return false;
        }
        PowerSetType other = (PowerSetType)o;
        return this.base.equals(other.base);
    }

    @Override
    public Type getBaseType() {
        return this.base;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() << 1;
    }

    @Override
    public void accept(ITypeVisitor visitor) {
        visitor.visit(this);
    }
}

