/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class MultiplePredicate
extends Predicate {
    protected final Expression[] children;
    private static final int FIRST_TAG = 901;
    public static final int TAGS_LENGTH = Operators.values().length;
    private static final String KPARTITION_ID = "Partition";

    public static void initV2(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected MultiplePredicate(Expression[] children, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, MultiplePredicate.combineHashCodes(children));
        this.children = children;
        FormulaChecks.ensureTagInRange(tag, 901, TAGS_LENGTH);
        FormulaChecks.ensureMinLength(children, 1);
        this.ensureSameFactory(this.children);
        this.setPredicateVariableCache(this.children);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        IdentListMerger freeIdentMerger = MultiplePredicate.mergeFreeIdentifiers((Formula[])this.children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = MultiplePredicate.mergeBoundIdentifiers((Formula[])this.children);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        Type childType = this.children[0].getType();
        if (!(childType instanceof PowerSetType)) {
            return;
        }
        for (int i = 1; i < this.children.length; ++i) {
            if (childType.equals(this.children[i].getType())) continue;
            return;
        }
        this.typeChecked = true;
    }

    public Expression[] getChildren() {
        return (Expression[])this.children.clone();
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 901];
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return AssociativeHelper.getSyntaxTreeHelper(boundNames, tabs, this.children, this.getOperatorImage(), "", this.getClass().getSimpleName());
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        AssociativeHelper.isLegibleList((Formula[])this.children, (LegibilityResult)result);
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        MultiplePredicate other = (MultiplePredicate)formula;
        return Arrays.equals(this.children, other.children);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        TypeVariable alpha = result.newFreshVariable(null);
        PowerSetType childType = result.makePowerSetType(alpha);
        for (Expression child : this.children) {
            child.typeCheck(result, quantifiedIdentifiers);
            result.unify(child.getType(), childType, this);
        }
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (Expression child : this.children) {
            child.solveType(unifier);
        }
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (Expression child : this.children) {
            child.collectFreeIdentifiers(freeIdentSet);
        }
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (Expression child : this.children) {
            child.collectNamesAbove(names, boundNames, offset);
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = visitor.enterKPARTITION(this);
        for (int i = 0; goOn && i < this.children.length; ++i) {
            if (i != 0) {
                goOn = visitor.continueKPARTITION(this);
            }
            if (!goOn) continue;
            goOn = this.children[i].accept(visitor);
        }
        return visitor.exitKPARTITION(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitMultiplePredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        int length = this.children.length;
        FormulaFactory ff = rewriter.getFactory();
        SourceLocation sloc = this.getSourceLocation();
        Expression[] newChildren = new Expression[length];
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            Expression newChild;
            Expression child = this.children[i];
            newChildren[i] = newChild = (Expression)child.rewrite(rewriter);
            changed |= newChild != child;
        }
        MultiplePredicate before = !changed ? this : ff.makeMultiplePredicate(this.getTag(), newChildren, sloc);
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (Expression child : this.children) {
            child.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        this.checkChildIndex(index);
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        for (Expression child : this.children) {
            IPosition pos = child.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        if (index < 0 || this.children.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Expression[] newChildren = (Expression[])this.children.clone();
        newChildren[index] = rewriter.rewrite(this.children[index]);
        return this.getFactory().makeMultiplePredicate(this.getTag(), newChildren, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<MultiplePredicate>
    {
        OP_KPARTITION("partition", "Partition", StandardGroup.ATOMIC_PRED);

        private final String image;
        private final String id;
        private final String groupId;

        private Operators(String image, String id, StandardGroup group) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<MultiplePredicate> makeParser(int kind) {
            return new SubParsers.MultiplePredicateParser(kind);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

