/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISpecialization;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.IUpgradeResult;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.VersionUpgraderV1V2;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDatatypeBuilder;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IGrammar;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.IPredicateExtension;
import org.eventb.internal.core.ast.FactoryHelper;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.Specialization;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.ast.extension.Cond;
import org.eventb.internal.core.ast.extension.ExtnUnicityChecker;
import org.eventb.internal.core.lexer.GenLexer;
import org.eventb.internal.core.lexer.Scanner;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.BMathV1;
import org.eventb.internal.core.parser.BMathV2;
import org.eventb.internal.core.parser.ExtendedGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.ParseResult;
import org.eventb.internal.core.typecheck.TypeEnvironmentBuilder;
import org.eventb.internal.core.upgrade.UpgradeResult;

public class FormulaFactory {
    private static final Expression[] NO_EXPRESSIONS = new Expression[0];
    private static final Map<IFormulaExtension, Integer> ALL_EXTENSIONS = Collections.synchronizedMap(new HashMap());
    private static final Map<Set<IFormulaExtension>, FormulaFactory> INSTANCE_CACHE = new HashMap<Set<IFormulaExtension>, FormulaFactory>();
    private static final ExtnUnicityChecker EXTN_UNICITY_CHECKER = new ExtnUnicityChecker(BMathV2.B_MATH_V2);
    private static final FormulaFactory DEFAULT_INSTANCE = FormulaFactory.getInstance(Collections.emptySet());
    private static final FormulaFactory V1_INSTANCE = new FormulaFactory(BMathV1.B_MATH_V1);
    private static volatile int nextExtensionTag = 1000;
    private final Map<Integer, IFormulaExtension> extensions;
    private final BMath grammar;

    public static FormulaFactory getDefault() {
        return DEFAULT_INSTANCE;
    }

    public static FormulaFactory getV1Default() {
        return V1_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormulaFactory getInstance(Set<IFormulaExtension> extensions) {
        LinkedHashSet<IFormulaExtension> actualExtns = new LinkedHashSet<IFormulaExtension>(extensions);
        Map<IFormulaExtension, Integer> map = ALL_EXTENSIONS;
        synchronized (map) {
            FormulaFactory cached = INSTANCE_CACHE.get(actualExtns);
            if (cached != null) {
                return cached;
            }
            FormulaFactory.checkSymbols(actualExtns);
            FormulaFactory.checkDatatypeComplete(actualExtns);
            FormulaFactory.checkTypeConstructorArity(actualExtns);
            EXTN_UNICITY_CHECKER.checkUnicity(actualExtns);
            LinkedHashMap<Integer, IFormulaExtension> extMap = new LinkedHashMap<Integer, IFormulaExtension>();
            for (IFormulaExtension extension : actualExtns) {
                Integer tag = ALL_EXTENSIONS.get(extension);
                if (tag == null) {
                    tag = nextExtensionTag;
                    ++nextExtensionTag;
                    ALL_EXTENSIONS.put(extension, tag);
                }
                extMap.put(tag, extension);
            }
            FormulaFactory factory = new FormulaFactory(extMap);
            INSTANCE_CACHE.put(actualExtns, factory);
            return factory;
        }
    }

    public static FormulaFactory getInstance(IFormulaExtension ... extensions) {
        return FormulaFactory.getInstance(new LinkedHashSet<IFormulaExtension>(Arrays.asList(extensions)));
    }

    private static void checkDatatypeComplete(Set<IFormulaExtension> extns) {
        Set<IDatatype> datatypes = FormulaFactory.getDatatypes(extns);
        for (IDatatype datatype : datatypes) {
            if (!extns.containsAll(datatype.getExtensions())) {
                throw new IllegalArgumentException("Incomplete datatype " + datatype);
            }
            if (extns.containsAll(datatype.getBaseFactory().getExtensions())) continue;
            throw new IllegalArgumentException("Missing dependencies for datatype " + datatype);
        }
    }

    private static Set<IDatatype> getDatatypes(Set<IFormulaExtension> extns) {
        HashSet<IDatatype> result = new HashSet<IDatatype>();
        for (IFormulaExtension extn : extns) {
            Object origin = extn.getOrigin();
            if (!(origin instanceof IDatatype)) continue;
            result.add((IDatatype)origin);
        }
        return result;
    }

    private static void checkTypeConstructorArity(Set<IFormulaExtension> extns) {
        for (IFormulaExtension extn : extns) {
            IExtensionKind kind;
            IOperatorProperties props;
            IExpressionExtension exprExtn;
            if (!(extn instanceof IExpressionExtension) || !(exprExtn = (IExpressionExtension)extn).isATypeConstructor() || (props = (kind = exprExtn.getKind()).getProperties()).getChildTypes().getPredArity().getMax() == 0) continue;
            throw new IllegalArgumentException("Type constructor takes predicate parameters " + exprExtn.getId());
        }
    }

    private static void checkSymbols(Set<IFormulaExtension> actualExtns) {
        for (IFormulaExtension extn : actualExtns) {
            String symbol = extn.getSyntaxSymbol();
            if (FormulaFactory.checkSymbol(symbol)) continue;
            throw new IllegalArgumentException("Invalid symbol '" + symbol + "' in extension " + extn.getId());
        }
    }

    public static boolean checkSymbol(String symbol) {
        if (GenLexer.isIdent(symbol)) {
            return true;
        }
        return !symbol.isEmpty() && GenLexer.isSymbol(symbol);
    }

    public FormulaFactory withExtensions(Set<IFormulaExtension> addedExtns) {
        LinkedHashSet<IFormulaExtension> newExtns = new LinkedHashSet<IFormulaExtension>(this.extensions.values());
        newExtns.addAll(addedExtns);
        return FormulaFactory.getInstance(newExtns);
    }

    public IDatatypeBuilder makeDatatypeBuilder(String name, List<GivenType> parameters) {
        return new DatatypeBuilder(this, name, parameters, null);
    }

    public IDatatypeBuilder makeDatatypeBuilder(String name, GivenType ... parameters) {
        return new DatatypeBuilder(this, name, Arrays.asList(parameters), null);
    }

    public IDatatypeBuilder makeDatatypeBuilder(String name, List<GivenType> parameters, Object origin) {
        return new DatatypeBuilder(this, name, parameters, origin);
    }

    private boolean isV1Specific(int tag) {
        return tag == 758 || tag == 759 || tag == 760;
    }

    private boolean isV2Specific(int tag) {
        return tag == 901 || tag == 410 || tag == 411 || tag == 412;
    }

    private FormulaFactory(BMath grammar) {
        this.extensions = Collections.emptyMap();
        this.grammar = grammar;
    }

    private FormulaFactory(Map<Integer, IFormulaExtension> extMap) {
        this.extensions = extMap;
        this.grammar = new ExtendedGrammar(new LinkedHashSet<IFormulaExtension>(extMap.values()));
        this.grammar.init();
    }

    public AbstractGrammar getGrammar() {
        return this.grammar;
    }

    public IGrammar getGrammarView() {
        return this.grammar.asExternalView();
    }

    private int getCheckedExtensionTag(IFormulaExtension extension) {
        int tag = FormulaFactory.getTag(extension);
        if (tag == 0) {
            throw new IllegalArgumentException("Unknown formula extension " + extension.getId());
        }
        if (!this.hasExtension(tag)) {
            throw new IllegalArgumentException("Formula extension " + extension.getId() + " is not supported by this factory");
        }
        return tag;
    }

    public ExtendedExpression makeExtendedExpression(IExpressionExtension extension, Expression[] expressions, Predicate[] predicates, SourceLocation location, Type type) {
        int tag = this.getCheckedExtensionTag(extension);
        return new ExtendedExpression(tag, (Expression[])expressions.clone(), (Predicate[])predicates.clone(), location, this, extension, type);
    }

    public ExtendedExpression makeExtendedExpression(IExpressionExtension extension, Expression[] expressions, Predicate[] predicates, SourceLocation location) {
        return this.makeExtendedExpression(extension, expressions, predicates, location, null);
    }

    public ExtendedExpression makeExtendedExpression(IExpressionExtension extension, Collection<Expression> expressions, Collection<Predicate> predicates, SourceLocation location, Type type) {
        int tag = this.getCheckedExtensionTag(extension);
        return new ExtendedExpression(tag, FactoryHelper.toExprArray(expressions), FactoryHelper.toPredArray(predicates), location, this, extension, type);
    }

    public ExtendedExpression makeExtendedExpression(IExpressionExtension extension, Collection<Expression> expressions, Collection<Predicate> predicates, SourceLocation location) {
        return this.makeExtendedExpression(extension, expressions, predicates, location, null);
    }

    public ExtendedPredicate makeExtendedPredicate(IPredicateExtension extension, Expression[] expressions, Predicate[] predicates, SourceLocation location) {
        int tag = this.getCheckedExtensionTag(extension);
        return new ExtendedPredicate(tag, (Expression[])expressions.clone(), (Predicate[])predicates.clone(), location, this, extension);
    }

    public ExtendedPredicate makeExtendedPredicate(IPredicateExtension extension, Collection<Expression> expressions, Collection<Predicate> predicates, SourceLocation location) {
        int tag = this.getCheckedExtensionTag(extension);
        return new ExtendedPredicate(tag, FactoryHelper.toExprArray(expressions), FactoryHelper.toPredArray(predicates), location, this, extension);
    }

    public static IExpressionExtension getCond() {
        return Cond.getCond();
    }

    public static int getTag(IFormulaExtension extension) {
        Integer tag = ALL_EXTENSIONS.get(extension);
        return tag == null ? 0 : tag;
    }

    public IFormulaExtension getExtension(int tag) {
        return this.extensions.get(tag);
    }

    public boolean hasExtension(int tag) {
        return this.getExtension(tag) != null;
    }

    public boolean hasExtension(IFormulaExtension extension) {
        int tag = FormulaFactory.getTag(extension);
        return this.hasExtension(tag);
    }

    public Set<IFormulaExtension> getExtensions() {
        return new LinkedHashSet<IFormulaExtension>(this.extensions.values());
    }

    public AssociativeExpression makeAssociativeExpression(int tag, Expression[] children, SourceLocation location) {
        return new AssociativeExpression((Expression[])children.clone(), tag, location, this);
    }

    public AssociativeExpression makeAssociativeExpression(int tag, Collection<Expression> children, SourceLocation location) {
        return new AssociativeExpression(FactoryHelper.toExprArray(children), tag, location, this);
    }

    public AssociativePredicate makeAssociativePredicate(int tag, Collection<Predicate> predicates, SourceLocation location) {
        return new AssociativePredicate(FactoryHelper.toPredArray(predicates), tag, location, this);
    }

    public AssociativePredicate makeAssociativePredicate(int tag, Predicate[] predicates, SourceLocation location) {
        return new AssociativePredicate((Predicate[])predicates.clone(), tag, location, this);
    }

    public AtomicExpression makeAtomicExpression(int tag, SourceLocation location) {
        if (this == V1_INSTANCE && this.isV2Specific(tag)) {
            throw new IllegalArgumentException("Unsupported tag in V1: " + tag);
        }
        return new AtomicExpression(tag, location, null, this);
    }

    public AtomicExpression makeAtomicExpression(int tag, SourceLocation location, Type type) {
        if (this == V1_INSTANCE && this.isV2Specific(tag)) {
            throw new IllegalArgumentException("Unsupported tag in V1: " + tag);
        }
        return new AtomicExpression(tag, location, type, this);
    }

    public AtomicExpression makeEmptySet(Type type, SourceLocation location) {
        return new AtomicExpression(407, location, type, this);
    }

    public BecomesEqualTo makeBecomesEqualTo(FreeIdentifier ident, Expression value, SourceLocation location) {
        return new BecomesEqualTo(new FreeIdentifier[]{ident}, new Expression[]{value}, location, this);
    }

    public BecomesEqualTo makeBecomesEqualTo(FreeIdentifier[] idents, Expression[] values, SourceLocation location) {
        return new BecomesEqualTo((FreeIdentifier[])idents.clone(), (Expression[])values.clone(), location, this);
    }

    public BecomesEqualTo makeBecomesEqualTo(Collection<FreeIdentifier> idents, Collection<Expression> values, SourceLocation location) {
        return new BecomesEqualTo(FactoryHelper.toIdentArray(idents), FactoryHelper.toExprArray(values), location, this);
    }

    public BecomesMemberOf makeBecomesMemberOf(FreeIdentifier ident, Expression setExpr, SourceLocation location) {
        return new BecomesMemberOf(ident, setExpr, location, this);
    }

    public BecomesSuchThat makeBecomesSuchThat(FreeIdentifier ident, BoundIdentDecl primedIdent, Predicate condition, SourceLocation location) {
        return new BecomesSuchThat(new FreeIdentifier[]{ident}, new BoundIdentDecl[]{primedIdent}, condition, location, this);
    }

    public BecomesSuchThat makeBecomesSuchThat(FreeIdentifier[] idents, BoundIdentDecl[] primedIdents, Predicate condition, SourceLocation location) {
        return new BecomesSuchThat((FreeIdentifier[])idents.clone(), (BoundIdentDecl[])primedIdents.clone(), condition, location, this);
    }

    public BecomesSuchThat makeBecomesSuchThat(Collection<FreeIdentifier> idents, Collection<BoundIdentDecl> primedIdents, Predicate condition, SourceLocation location) {
        return new BecomesSuchThat(FactoryHelper.toIdentArray(idents), FactoryHelper.toBIDArray(primedIdents), condition, location, this);
    }

    public BinaryExpression makeBinaryExpression(int tag, Expression left, Expression right, SourceLocation location) {
        return new BinaryExpression(left, right, tag, location, this);
    }

    public BinaryPredicate makeBinaryPredicate(int tag, Predicate left, Predicate right, SourceLocation location) {
        return new BinaryPredicate(left, right, tag, location, this);
    }

    public BoolExpression makeBoolExpression(Predicate child, SourceLocation location) {
        return new BoolExpression(child, location, this);
    }

    public BoundIdentDecl makeBoundIdentDecl(String name, SourceLocation location) {
        return new BoundIdentDecl(name, location, null, this);
    }

    public BoundIdentDecl makeBoundIdentDecl(String name, SourceLocation location, Type type) {
        return new BoundIdentDecl(name, location, type, this);
    }

    public BoundIdentifier makeBoundIdentifier(int index, SourceLocation location) {
        return new BoundIdentifier(index, location, null, this);
    }

    public BoundIdentifier makeBoundIdentifier(int index, SourceLocation location, Type type) {
        return new BoundIdentifier(index, location, type, this);
    }

    public FreeIdentifier makeFreeIdentifier(String name, SourceLocation location) {
        return new FreeIdentifier(name, location, null, this);
    }

    public FreeIdentifier makeFreeIdentifier(String name, SourceLocation location, Type type) {
        return new FreeIdentifier(name, location, type, this);
    }

    public IntegerLiteral makeIntegerLiteral(BigInteger literal, SourceLocation location) {
        return new IntegerLiteral(literal, location, this);
    }

    public LiteralPredicate makeLiteralPredicate(int tag, SourceLocation location) {
        return new LiteralPredicate(tag, location, this);
    }

    public PredicateVariable makePredicateVariable(String name, SourceLocation location) {
        return new PredicateVariable(name, location, this);
    }

    public QuantifiedExpression makeQuantifiedExpression(int tag, BoundIdentDecl[] boundIdentifiers, Predicate pred, Expression expr, SourceLocation location, QuantifiedExpression.Form form) {
        return new QuantifiedExpression(expr, pred, (BoundIdentDecl[])boundIdentifiers.clone(), tag, location, form, this);
    }

    public QuantifiedExpression makeQuantifiedExpression(int tag, Collection<BoundIdentDecl> boundIdentifiers, Predicate pred, Expression expr, SourceLocation location, QuantifiedExpression.Form form) {
        return new QuantifiedExpression(expr, pred, FactoryHelper.toBIDArray(boundIdentifiers), tag, location, form, this);
    }

    public QuantifiedPredicate makeQuantifiedPredicate(int tag, BoundIdentDecl[] boundIdentifiers, Predicate pred, SourceLocation location) {
        return new QuantifiedPredicate(pred, (BoundIdentDecl[])boundIdentifiers.clone(), tag, location, this);
    }

    public QuantifiedPredicate makeQuantifiedPredicate(int tag, Collection<BoundIdentDecl> boundIdentifiers, Predicate pred, SourceLocation location) {
        return new QuantifiedPredicate(pred, FactoryHelper.toBIDArray(boundIdentifiers), tag, location, this);
    }

    public RelationalPredicate makeRelationalPredicate(int tag, Expression left, Expression right, SourceLocation location) {
        return new RelationalPredicate(left, right, tag, location, this);
    }

    public SetExtension makeSetExtension(Expression expression, SourceLocation location) {
        return new SetExtension(new Expression[]{expression}, location, this, null);
    }

    public SetExtension makeSetExtension(Expression[] members, SourceLocation location) {
        return new SetExtension((Expression[])members.clone(), location, this, null);
    }

    public SetExtension makeEmptySetExtension(Type type, SourceLocation location) {
        return new SetExtension(NO_EXPRESSIONS, location, this, type);
    }

    public SetExtension makeSetExtension(Collection<Expression> members, SourceLocation location) {
        return new SetExtension(FactoryHelper.toExprArray(members), location, this, null);
    }

    public SimplePredicate makeSimplePredicate(int tag, Expression child, SourceLocation location) {
        return new SimplePredicate(child, tag, location, this);
    }

    public ITypeEnvironmentBuilder makeTypeEnvironment() {
        return new TypeEnvironmentBuilder(this);
    }

    public UnaryExpression makeUnaryExpression(int tag, Expression child, SourceLocation location) {
        if (this != V1_INSTANCE && this.isV1Specific(tag)) {
            throw new IllegalArgumentException("Unsupported V1 tag: " + tag);
        }
        return new UnaryExpression(child, tag, location, this);
    }

    public UnaryPredicate makeUnaryPredicate(int tag, Predicate child, SourceLocation location) {
        return new UnaryPredicate(child, tag, location, this);
    }

    public MultiplePredicate makeMultiplePredicate(int tag, Expression[] children, SourceLocation location) {
        if (this == V1_INSTANCE) {
            throw new IllegalArgumentException("Unsupported in V1");
        }
        return new MultiplePredicate((Expression[])children.clone(), tag, location, this);
    }

    public MultiplePredicate makeMultiplePredicate(int tag, Collection<Expression> children, SourceLocation location) {
        if (this == V1_INSTANCE) {
            throw new IllegalArgumentException("Unsupported in V1");
        }
        return new MultiplePredicate(FactoryHelper.toExprArray(children), tag, location, this);
    }

    public IParseResult parseAssignment(String formula, Object origin) {
        return this.parseGeneric(formula, origin, Assignment.class, false);
    }

    public IParseResult parseExpression(String formula, Object origin) {
        return this.parseGeneric(formula, origin, Expression.class, false);
    }

    public IParseResult parseExpressionPattern(String formula, Object origin) {
        return this.parseGeneric(formula, origin, Expression.class, true);
    }

    public IParseResult parsePredicate(String formula, Object origin) {
        return this.parseGeneric(formula, origin, Predicate.class, false);
    }

    public IParseResult parsePredicatePattern(String formula, Object origin) {
        return this.parseGeneric(formula, origin, Predicate.class, true);
    }

    public IParseResult parseType(String formula) {
        return this.parseGeneric(formula, null, Type.class, false);
    }

    private final <T> IParseResult parseGeneric(String formula, Object origin, Class<T> clazz, boolean withPredVars) {
        ParseResult result = new ParseResult(this, origin);
        Scanner scanner = new Scanner(formula, result, this.grammar);
        GenParser parser = new GenParser(clazz, scanner, result, withPredVars);
        parser.parse();
        return parser.getResult();
    }

    public BooleanType makeBooleanType() {
        return new BooleanType(this);
    }

    public ParametricType makeParametricType(IExpressionExtension typeConstructor, List<Type> typePrms) {
        this.getCheckedExtensionTag(typeConstructor);
        return new ParametricType(this, typeConstructor, FactoryHelper.toTypeArray(typePrms));
    }

    public ParametricType makeParametricType(IExpressionExtension typeConstructor, Type ... typePrms) {
        this.getCheckedExtensionTag(typeConstructor);
        return new ParametricType(this, typeConstructor, (Type[])typePrms.clone());
    }

    public GivenType makeGivenType(String name) {
        return new GivenType(this, name);
    }

    public GivenType makeGivenType(FreeIdentifier freeIdentifier) {
        return new GivenType(this, freeIdentifier);
    }

    public IntegerType makeIntegerType() {
        return new IntegerType(this);
    }

    public static IPosition makePosition(String image) {
        return new Position(image);
    }

    public PowerSetType makePowerSetType(Type base) {
        return new PowerSetType(this, base);
    }

    public ProductType makeProductType(Type left, Type right) {
        return new ProductType(this, left, right);
    }

    public PowerSetType makeRelationalType(Type left, Type right) {
        return this.makePowerSetType(this.makeProductType(left, right));
    }

    public ISpecialization makeSpecialization() {
        return new Specialization(this);
    }

    public boolean isValidIdentifierName(String name) {
        return Scanner.isToken(this, name, AbstractGrammar.DefaultToken.IDENT);
    }

    public boolean isValidPredicateName(String name) {
        return Scanner.isToken(this, name, AbstractGrammar.DefaultToken.PRED_VAR);
    }

    public static boolean isEventBWhiteSpace(char c) {
        return FormulaFactory.isEventBWhiteSpace((int)c);
    }

    public static boolean isEventBWhiteSpace(int codePoint) {
        return Character.isSpaceChar(codePoint) || 9 <= codePoint && codePoint <= 13 || 28 <= codePoint && codePoint <= 31;
    }

    private void ensuresFactoryV2() {
        if (this == V1_INSTANCE) {
            throw new IllegalArgumentException("The current factory with version V1 cannot be used to upgrade assignment from V1 to V2");
        }
    }

    public IUpgradeResult<Assignment> upgradeAssignment(String input) {
        this.ensuresFactoryV2();
        UpgradeResult<Assignment> result = new UpgradeResult<Assignment>(this);
        VersionUpgraderV1V2 upgrader = new VersionUpgraderV1V2();
        upgrader.upgradeAssignment(input, result);
        return result;
    }

    public IUpgradeResult<Expression> upgradeExpression(String input) {
        this.ensuresFactoryV2();
        UpgradeResult<Expression> result = new UpgradeResult<Expression>(this);
        VersionUpgraderV1V2 upgrader = new VersionUpgraderV1V2();
        upgrader.upgradeExpression(input, result);
        return result;
    }

    public IUpgradeResult<Predicate> upgradePredicate(String input) {
        UpgradeResult<Predicate> result = new UpgradeResult<Predicate>(this);
        VersionUpgraderV1V2 upgrader = new VersionUpgraderV1V2();
        upgrader.upgradePredicate(input, result);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int sep = 123;
        sb.append("FFactory(");
        sb.append(this.grammar);
        sb.append(")");
        for (IFormulaExtension extension : this.extensions.values()) {
            sb.append((char)sep);
            sep = 59;
            sb.append(extension.getId());
        }
        if (sep != 123) {
            sb.append('}');
        }
        return sb.toString();
    }
}

