/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IFormulaRewriter;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.QuantifiedHelper;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BoundIdentDecl
extends Formula<BoundIdentDecl> {
    private final String name;
    private Type type;

    protected BoundIdentDecl(String name, SourceLocation location, Type givenType, FormulaFactory ff) {
        super(2, ff, location, name.hashCode());
        BoundIdentDecl.ensureValidName(name, ff);
        this.name = name;
        this.ensureSameFactory(givenType);
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType(givenType);
        assert (givenType == null || givenType == this.type);
    }

    private static void ensureValidName(String name, FormulaFactory ff) {
        FormulaFactory checkFactory = ff == FormulaFactory.getV1Default() ? ff : FormulaFactory.getDefault();
        FormulaChecks.ensureValidIdentifierName(name, checkFactory);
    }

    private void synthesizeType(Type givenType) {
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = NO_BOUND_IDENT;
        if (givenType == null) {
            return;
        }
        assert (givenType.isSolved());
        this.freeIdents = GivenTypeHelper.getGivenTypeIdentifiers(givenType);
        this.type = givenType;
        this.typeChecked = true;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        SubParsers.BOUND_IDENT_DECL_SUBPARSER.toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getIDENT();
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        return tabs + this.getClass().getSimpleName() + " [name: " + this.name + "]" + typeName + "\n";
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        BoundIdentDecl other = (BoundIdentDecl)formula;
        return this.name.equals(other.name) && this.equalsWithAlphaConversion(other);
    }

    boolean equalsWithAlphaConversion(BoundIdentDecl other) {
        return QuantifiedHelper.sameType(this.type, other.type);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        if (result.hasFreeIdent(this.name)) {
            result.addProblem(new ASTProblem(this.getSourceLocation(), ProblemKind.BoundIdentifierHasFreeOccurences, 1, this.name));
            FreeIdentifier other = result.getExistingFreeIdentifier(this.name);
            result.addProblem(new ASTProblem(other.getSourceLocation(), ProblemKind.FreeIdentifierHasBoundOccurences, 1, this.name));
        } else if (result.hasBoundIdentDecl(this.name)) {
            result.addProblem(new ASTProblem(this.getSourceLocation(), ProblemKind.BoundIdentifierIsAlreadyBound, 1, this.name));
            BoundIdentDecl other = result.getExistingBoundIdentDecl(this.name);
            result.addProblem(new ASTProblem(other.getSourceLocation(), ProblemKind.BoundIdentifierIsAlreadyBound, 1, this.name));
        } else {
            result.addBoundIdentDecl(this);
        }
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        if (this.type == null) {
            this.type = result.newFreshVariable(this.getSourceLocation());
        }
        result.analyzeType(this.type, this);
    }

    @Override
    protected void solveType(TypeUnifier unifier) {
        if (this.isTypeChecked() || this.type == null) {
            return;
        }
        Type inferredType = unifier.solve(this.type);
        this.type = null;
        if (inferredType != null && inferredType.isSolved()) {
            this.synthesizeType(inferredType);
        } else {
            this.synthesizeType(null);
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        names.add(this.name);
    }

    @Override
    protected BoundIdentDecl getTypedThis() {
        return this;
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visitBOUND_IDENT_DECL(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBoundIdentDecl(this);
    }

    @Override
    public BoundIdentDecl rewrite(IFormulaRewriter rewriter) {
        throw new UnsupportedOperationException("Bound identifier declarations cannot be rewritten");
    }

    @Override
    protected BoundIdentDecl rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public Formula<?> getChild(int index) {
        throw BoundIdentDecl.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return new Position(indexes);
    }

    @Override
    protected BoundIdentDecl rewriteChild(int index, SingleRewriter rewriter) {
        throw new IllegalArgumentException("Position is outside the formula");
    }

    @Override
    protected BoundIdentDecl getCheckedReplacement(SingleRewriter rewriter) {
        return rewriter.getBoundIdentDecl(this);
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }
}

