/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class BoolExpression
extends Expression {
    private static final String KBOOL_ID = "To Bool";
    private final Predicate child;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected BoolExpression(Predicate child, SourceLocation location, FormulaFactory ff) {
        super(601, ff, location, child.hashCode());
        this.child = child;
        this.ensureSameFactory(this.child);
        this.setPredicateVariableCache(this.child);
        this.synthesizeType(null);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        this.freeIdents = this.child.freeIdents;
        this.boundIdents = this.child.boundIdents;
        if (!this.child.isTypeChecked()) {
            return;
        }
        this.setFinalType(this.getFactory().makeBooleanType(), givenType);
    }

    public Predicate getPredicate() {
        return this.child;
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.child.isLegible(result);
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        BoolExpression other = (BoolExpression)expr;
        return this.child.equals(other.child);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.child.typeCheck(result, quantifiedIdentifiers);
        this.setTemporaryType(result.makeBooleanType(), result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.child.solveType(unifier);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = Operators.OP_KBOOL;
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    private String getOperatorImage() {
        return Operators.OP_KBOOL.getImage();
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]" + typeName + "\n" + this.child.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.child.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.child.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 601: {
                goOn = visitor.enterKBOOL(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.child.accept(visitor);
        }
        switch (this.getTag()) {
            case 601: {
                return visitor.exitKBOOL(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitBoolExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        Predicate newChild = (Predicate)this.child.rewrite(rewriter);
        BoolExpression before = newChild == this.child ? this : rewriter.getFactory().makeBoolExpression(newChild, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.child.inspect(acc);
        acc.leaveChildren();
    }

    public Predicate getChild(int index) {
        if (index == 0) {
            return this.child;
        }
        throw BoolExpression.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.child.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        if (index != 0) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Predicate newChild = rewriter.rewrite(this.child);
        return this.getFactory().makeBoolExpression(newChild, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<BoolExpression>
    {
        OP_KBOOL("bool", "To Bool", StandardGroup.BOOL_EXPR);

        private final String image;
        private final String id;
        private final String groupId;

        private Operators(String image, String id, StandardGroup group) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<BoolExpression> makeParser(int kind) {
            return new SubParsers.KBoolParser(kind);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

