/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class AssociativeExpression
extends Expression {
    private static final int FIRST_TAG = 301;
    public static final String BINTER_ID = "Binary Intersection";
    public static final String BUNION_ID = "Binary Union";
    public static final String BCOMP_ID = "Backward Composition";
    public static final String FCOMP_ID = "Forward Composition";
    public static final String OVR_ID = "Overload";
    public static final String MUL_ID = "mul";
    public static final String PLUS_ID = "plus";
    public static final int TAGS_LENGTH = Operators.values().length;
    private final Expression[] children;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected AssociativeExpression(Expression[] children, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, AssociativeExpression.combineHashCodes(children));
        this.children = children;
        FormulaChecks.ensureTagInRange(tag, 301, TAGS_LENGTH);
        FormulaChecks.ensureMinLength(children, 2);
        this.ensureSameFactory(this.children);
        this.setPredicateVariableCache(this.children);
        this.synthesizeType(null);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        IdentListMerger freeIdentMerger = AssociativeExpression.mergeFreeIdentifiers((Formula[])this.children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = AssociativeExpression.mergeBoundIdentifiers((Formula[])this.children);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!this.children[0].isTypeChecked()) {
            return;
        }
        int last = this.children.length - 1;
        FormulaFactory ff = this.getFactory();
        switch (this.getTag()) {
            case 301: 
            case 302: {
                resultType = this.children[0].getType();
                if (!(resultType instanceof PowerSetType)) {
                    return;
                }
                for (int i = 1; i <= last; ++i) {
                    if (resultType.equals(this.children[i].getType())) continue;
                    return;
                }
                break;
            }
            case 303: {
                Type partType = this.children[0].getType().getSource();
                if (partType == null) {
                    return;
                }
                for (int i = 1; i <= last; ++i) {
                    Type childType = this.children[i].getType();
                    if (childType == null) {
                        return;
                    }
                    if (!partType.equals(childType.getTarget())) {
                        return;
                    }
                    partType = childType.getSource();
                }
                Type sourceType = this.children[last].getType().getSource();
                Type targetType = this.children[0].getType().getTarget();
                resultType = ff.makeRelationalType(sourceType, targetType);
                break;
            }
            case 304: {
                Type partType = this.children[0].getType().getTarget();
                if (partType == null) {
                    return;
                }
                for (int i = 1; i <= last; ++i) {
                    Type childType = this.children[i].getType();
                    if (childType == null) {
                        return;
                    }
                    if (!partType.equals(childType.getSource())) {
                        return;
                    }
                    partType = childType.getTarget();
                }
                Type sourceType = this.children[0].getType().getSource();
                Type targetType = this.children[last].getType().getTarget();
                resultType = ff.makeRelationalType(sourceType, targetType);
                break;
            }
            case 305: {
                resultType = this.children[0].getType();
                if (!resultType.isRelational()) {
                    return;
                }
                for (int i = 1; i <= last; ++i) {
                    if (resultType.equals(this.children[i].getType())) continue;
                    return;
                }
                break;
            }
            case 306: 
            case 307: {
                resultType = this.children[0].getType();
                for (Expression child : this.children) {
                    Type childType = child.getType();
                    if (childType instanceof IntegerType) continue;
                    return;
                }
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setFinalType(resultType, givenType);
    }

    public Expression[] getChildren() {
        return (Expression[])this.children.clone();
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 301];
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        AssociativeExpression other = (AssociativeExpression)expr;
        return Arrays.equals(this.children, other.children);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        Type resultType;
        switch (this.getTag()) {
            case 301: 
            case 302: {
                TypeVariable alpha = result.newFreshVariable(null);
                resultType = result.makePowerSetType(alpha);
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].typeCheck(result, quantifiedIdentifiers);
                    result.unify(this.children[i].getType(), resultType, this);
                }
                break;
            }
            case 303: {
                TypeVariable[] tv = new TypeVariable[this.children.length + 1];
                tv[0] = result.newFreshVariable(null);
                for (int i = 0; i < this.children.length; ++i) {
                    tv[i + 1] = result.newFreshVariable(null);
                    this.children[i].typeCheck(result, quantifiedIdentifiers);
                    result.unify(this.children[i].getType(), result.makeRelationalType(tv[i + 1], tv[i]), this);
                }
                resultType = result.makeRelationalType(tv[this.children.length], tv[0]);
                break;
            }
            case 304: {
                TypeVariable[] tv = new TypeVariable[this.children.length + 1];
                tv[0] = result.newFreshVariable(null);
                for (int i = 0; i < this.children.length; ++i) {
                    tv[i + 1] = result.newFreshVariable(null);
                    this.children[i].typeCheck(result, quantifiedIdentifiers);
                    result.unify(this.children[i].getType(), result.makeRelationalType(tv[i], tv[i + 1]), this);
                }
                resultType = result.makeRelationalType(tv[0], tv[this.children.length]);
                break;
            }
            case 305: {
                TypeVariable alpha = result.newFreshVariable(null);
                TypeVariable beta = result.newFreshVariable(null);
                resultType = result.makeRelationalType(alpha, beta);
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].typeCheck(result, quantifiedIdentifiers);
                    result.unify(this.children[i].getType(), resultType, this);
                }
                break;
            }
            case 306: 
            case 307: {
                resultType = result.makeIntegerType();
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].typeCheck(result, quantifiedIdentifiers);
                    result.unify(this.children[i].getType(), resultType, this);
                }
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setTemporaryType(resultType, result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (Expression child : this.children) {
            child.solveType(unifier);
        }
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        AssociativeHelper.isLegibleList((Formula[])this.children, (LegibilityResult)result);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return AssociativeHelper.getSyntaxTreeHelper(boundNames, tabs, this.children, this.getOperatorImage(), this.getTypeName(), this.getClass().getSimpleName());
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        for (Expression child : this.children) {
            child.collectFreeIdentifiers(freeIdentSet);
        }
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        for (Expression child : this.children) {
            child.collectNamesAbove(names, boundNames, offset);
        }
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 301: {
                goOn = visitor.enterBUNION(this);
                break;
            }
            case 302: {
                goOn = visitor.enterBINTER(this);
                break;
            }
            case 303: {
                goOn = visitor.enterBCOMP(this);
                break;
            }
            case 304: {
                goOn = visitor.enterFCOMP(this);
                break;
            }
            case 305: {
                goOn = visitor.enterOVR(this);
                break;
            }
            case 306: {
                goOn = visitor.enterPLUS(this);
                break;
            }
            case 307: {
                goOn = visitor.enterMUL(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        for (int i = 0; goOn && i < this.children.length; ++i) {
            if (i != 0) {
                switch (this.getTag()) {
                    case 301: {
                        goOn = visitor.continueBUNION(this);
                        break;
                    }
                    case 302: {
                        goOn = visitor.continueBINTER(this);
                        break;
                    }
                    case 303: {
                        goOn = visitor.continueBCOMP(this);
                        break;
                    }
                    case 304: {
                        goOn = visitor.continueFCOMP(this);
                        break;
                    }
                    case 305: {
                        goOn = visitor.continueOVR(this);
                        break;
                    }
                    case 306: {
                        goOn = visitor.continuePLUS(this);
                        break;
                    }
                    case 307: {
                        goOn = visitor.continueMUL(this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (!goOn) continue;
            goOn = this.children[i].accept(visitor);
        }
        switch (this.getTag()) {
            case 301: {
                return visitor.exitBUNION(this);
            }
            case 302: {
                return visitor.exitBINTER(this);
            }
            case 303: {
                return visitor.exitBCOMP(this);
            }
            case 304: {
                return visitor.exitFCOMP(this);
            }
            case 305: {
                return visitor.exitOVR(this);
            }
            case 306: {
                return visitor.exitPLUS(this);
            }
            case 307: {
                return visitor.exitMUL(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitAssociativeExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        boolean flatten = rewriter.autoFlatteningMode();
        ArrayList<Expression> newChildren = new ArrayList<Expression>(this.children.length + 11);
        boolean changed = false;
        for (Expression child : this.children) {
            Expression newChild = (Expression)child.rewrite(rewriter);
            if (flatten && this.getTag() == newChild.getTag()) {
                Expression[] grandChildren = ((AssociativeExpression)newChild).children;
                newChildren.addAll(Arrays.asList(grandChildren));
                changed = true;
                continue;
            }
            newChildren.add(newChild);
            changed |= newChild != child;
        }
        AssociativeExpression before = !changed ? this : rewriter.getFactory().makeAssociativeExpression(this.getTag(), newChildren, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (Expression child : this.children) {
            child.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        this.checkChildIndex(index);
        return this.children[index];
    }

    @Override
    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        for (Expression child : this.children) {
            IPosition pos = child.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        if (index < 0 || this.children.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        Expression[] newChildren = (Expression[])this.children.clone();
        newChildren[index] = rewriter.rewrite(this.children[index]);
        return this.getFactory().makeAssociativeExpression(this.getTag(), newChildren, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<AssociativeExpression>
    {
        OP_BUNION("\u222a", "Binary Union", StandardGroup.BINOP, 301),
        OP_BINTER("\u2229", "Binary Intersection", StandardGroup.BINOP, 302),
        OP_BCOMP("\u2218", "Backward Composition", StandardGroup.BINOP, 303),
        OP_FCOMP(";", "Forward Composition", StandardGroup.BINOP, 304),
        OP_OVR("\ue103", "Overload", StandardGroup.BINOP, 305),
        OP_PLUS("+", "plus", StandardGroup.ARITHMETIC, 306),
        OP_MUL("\u2217", "mul", StandardGroup.ARITHMETIC, 307);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<AssociativeExpression> makeParser(int kind) {
            return new SubParsers.AssociativeExpressionInfix(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

