/*
 * Decompiled with CFR 0.152.
 */
package de.prob.scripting;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import de.prob.scripting.Api;
import de.prob.scripting.Downloader;
import de.prob.scripting.GroovySE;
import de.prob.scripting.UiFunctionRegistry;
import de.prob.statespace.AnimationSelector;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

@Singleton
public class ScriptEngineProvider
implements Provider<ScriptEngine> {
    private final Api api;
    private final AnimationSelector animations;
    private final ScriptEngineManager manager;
    private final Downloader downloader;
    private static final String[] IMPORTS = new String[]{"import de.prob.statespace.*;", "import de.prob.model.representation.*;", "import de.prob.model.classicalb.*;", "import de.prob.model.eventb.*;", "import de.prob.animator.domainobjects.*;", "import de.prob.animator.command.*;", "import de.prob.visualization.*", "import de.prob.bmotion.*"};
    private UiFunctionRegistry functionRegistry;

    @Inject
    public ScriptEngineProvider(Api api, AnimationSelector animations, Downloader downloader, UiFunctionRegistry functionRegistry) {
        this.api = api;
        this.animations = animations;
        this.downloader = downloader;
        this.functionRegistry = functionRegistry;
        this.manager = new ScriptEngineManager(this.getClass().getClassLoader());
    }

    public ScriptEngine get() {
        ScriptEngine engine = this.manager.getEngineByName("Groovy");
        Bindings bindings = engine.getBindings(200);
        bindings.put("api", (Object)this.api);
        bindings.put("animations", (Object)this.animations);
        bindings.put("downloader", (Object)this.downloader);
        bindings.put("ui_functions", (Object)this.functionRegistry);
        bindings.put("engine", (Object)engine);
        URL url = Resources.getResource((String)"initscript");
        try {
            String script = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            engine.eval(Joiner.on((String)"\n").join((Object[])IMPORTS) + script);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return new GroovySE(engine);
    }
}

