/*
 * Decompiled with CFR 0.152.
 */
package de.prob.scripting;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovySE
implements ScriptEngine {
    private final ScriptEngine groovy;
    private final Logger logger = LoggerFactory.getLogger(GroovySE.class);
    private static volatile int varcount = 0;
    private static final int BUFFER_SIZE = 1024;
    private static final String[] IMPORTS = new String[]{"import de.prob.statespace.*;", "import de.prob.model.representation.*;", "import de.prob.model.classicalb.*;", "import de.prob.model.eventb.*;", "import de.prob.animator.domainobjects.*;", "import de.prob.animator.command.*;", "import de.prob.visualization.*;", "import de.prob.check.*;", "import de.prob.bmotion.*;", "\n "};
    private static final String imports = Joiner.on((String)"\n").join((Object[])IMPORTS);

    public static int nextVar() {
        return varcount++;
    }

    public GroovySE(ScriptEngine engine) {
        this.groovy = engine;
        this.initialize();
    }

    private void initialize() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("initscript");
        String initscript = "";
        try {
            initscript = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
        }
        catch (IOException e) {
            this.logger.error("Error reading from initscript.");
        }
        try {
            this.groovy.eval(imports + "\n" + initscript);
        }
        catch (ScriptException e) {
            this.logger.error("Error initializing groovy", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        Object result;
        StringBuffer buff = new StringBuffer();
        if (this.groovy.get("__console") == null) {
            this.groovy.put("__console", buff);
        }
        if ((result = this.groovy.eval(imports + "\n" + script, context)) == null) {
            return "null";
        }
        if (buff.length() > 0) {
            this.logger.error("Automatically captured prints from groovy. Users of a groovy engine should provide a console. Output was: {}", (Object)buff.toString());
        }
        return result;
    }

    public Object eval(String script, ScriptContext context, StringBuffer console) throws ScriptException {
        this.groovy.put("__console", console);
        Object result = this.eval(script, context);
        return new Object[]{result, console.toString()};
    }

    public Object eval(String script, StringBuffer console) throws ScriptException {
        this.groovy.put("__console", console);
        Object result = this.eval(script, this.getContext());
        return new Object[]{result, console.toString()};
    }

    @Override
    public Bindings createBindings() {
        return this.groovy.createBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.groovy.getFactory();
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.groovy.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.groovy.setBindings(bindings, scope);
    }

    @Override
    public void setContext(ScriptContext context) {
        this.groovy.setContext(context);
    }

    @Override
    public ScriptContext getContext() {
        return this.groovy.getContext();
    }

    @Override
    public Object get(String key) {
        return this.groovy.get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.groovy.put(key, value);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.getContext());
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(this.readFully(reader));
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        ScriptContext ctxt = this.getScriptContext(n);
        return this.eval(script, ctxt);
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        return this.eval(this.readFully(reader), n);
    }

    protected ScriptContext getScriptContext(Bindings nn) {
        SimpleScriptContext ctxt = new SimpleScriptContext();
        Bindings gs = this.getBindings(200);
        if (gs != null) {
            ctxt.setBindings(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        ctxt.setBindings(nn, 100);
        return ctxt;
    }
}

