/*
 * Decompiled with CFR 0.152.
 */
package de.prob.scripting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.CachingDefinitionFileProvider;
import de.be4.classicalb.core.parser.IDefinitionFileProvider;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.model.classicalb.ClassicalBModel;
import de.prob.scripting.ExtractedModel;
import de.prob.scripting.ModelFactory;
import de.prob.scripting.ModelTranslationError;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicalBFactory
implements ModelFactory<ClassicalBModel> {
    Logger logger = LoggerFactory.getLogger(ClassicalBFactory.class);
    private final Provider<ClassicalBModel> modelCreator;

    @Inject
    public ClassicalBFactory(Provider<ClassicalBModel> modelCreator) {
        this.modelCreator = modelCreator;
    }

    @Override
    public ExtractedModel<ClassicalBModel> extract(String modelPath) throws IOException, ModelTranslationError {
        ClassicalBModel classicalBModel = (ClassicalBModel)this.modelCreator.get();
        File f = new File(modelPath);
        BParser bparser = new BParser();
        Start ast = this.parseFile(f, bparser);
        RecursiveMachineLoader rml = this.parseAllMachines(ast, f.getParent(), f, bparser.getContentProvider(), bparser);
        classicalBModel = classicalBModel.create(ast, rml, f, bparser);
        return new ExtractedModel<ClassicalBModel>(classicalBModel, classicalBModel.getMainMachine());
    }

    public ExtractedModel<ClassicalBModel> create(String model) throws ModelTranslationError {
        ClassicalBModel classicalBModel = (ClassicalBModel)this.modelCreator.get();
        BParser bparser = new BParser();
        Start ast = this.parseString(model, bparser);
        RecursiveMachineLoader rml = this.parseAllMachines(ast, ".", new File(""), bparser.getContentProvider(), bparser);
        classicalBModel = classicalBModel.create(ast, rml, new File("from_string"), bparser);
        return new ExtractedModel<ClassicalBModel>(classicalBModel, classicalBModel.getMainMachine());
    }

    public ExtractedModel<ClassicalBModel> create(Start model) throws ModelTranslationError {
        ClassicalBModel classicalBModel = (ClassicalBModel)this.modelCreator.get();
        BParser bparser = new BParser();
        RecursiveMachineLoader rml = this.parseAllMachines(model, ".", new File(""), (IDefinitionFileProvider)new CachingDefinitionFileProvider(), bparser);
        classicalBModel = classicalBModel.create(model, rml, new File("from_string"), bparser);
        return new ExtractedModel<ClassicalBModel>(classicalBModel, classicalBModel.getMainMachine());
    }

    public RecursiveMachineLoader parseAllMachines(Start ast, String directory, File f, IDefinitionFileProvider contentProvider, BParser bparser) throws ModelTranslationError {
        try {
            RecursiveMachineLoader rml = new RecursiveMachineLoader(directory, contentProvider);
            rml.loadAllMachines(f, ast, null, bparser.getDefinitions());
            this.logger.trace("Done parsing '{}'", (Object)f.getAbsolutePath());
            return rml;
        }
        catch (BException e) {
            throw new ModelTranslationError(e.getMessage(), e);
        }
    }

    public Start parseFile(File model, BParser bparser) throws IOException, ModelTranslationError {
        try {
            this.logger.trace("Parsing main file '{}'", (Object)model.getAbsolutePath());
            Start ast = null;
            ast = bparser.parseFile(model, false);
            return ast;
        }
        catch (BException e) {
            throw new ModelTranslationError(e.getMessage(), e);
        }
    }

    private Start parseString(String model, BParser bparser) throws ModelTranslationError {
        try {
            this.logger.trace("Parsing file");
            Start ast = null;
            ast = bparser.parse(model, false);
            return ast;
        }
        catch (BException e) {
            throw new ModelTranslationError(e.getMessage(), e);
        }
    }
}

